<?php
session_start();
include("include/dbcommon.php");

$title = trim(rtrim($_GET['title'] ?? '', "'"));
$company = trim(rtrim($_GET['company'] ?? '', "'"));
$url = $_GET['url'] ?? '';

// Default values if missing
if ($title === '') $title = 'Unknown';
if ($company === '') $company = 'Unknown';

if (!empty($url) && filter_var($url, FILTER_VALIDATE_URL)) {
    $clicked_by = !empty($_SESSION["UserID"]) ? $_SESSION["UserID"] : 'Guest';

    // Check for duplicates in last 10 seconds
    $exists = DB::Lookup("
        SELECT 1 FROM remote_click_logs
        WHERE clicked_by=" . db_prepare_string($clicked_by) . "
          AND title=" . db_prepare_string($title) . "
          AND company=" . db_prepare_string($company) . "
          AND redirect_url=" . db_prepare_string($url) . "
          AND clicked_at >= NOW() - INTERVAL 10 SECOND
    ");

    if (!$exists) {
        $stmt = DB::PrepareSQL(
            "INSERT INTO remote_click_logs (title, company, redirect_url, clicked_at, clicked_by)
             VALUES (%s, %s, %s, NOW(), %s)",
            [$title, $company, $url, $clicked_by]
        );
        DB::Exec($stmt);
    }

    header("Location: " . $url);
    exit;
} else {
    error_log("Invalid redirect attempt: " . $url);
    echo htmlspecialchars("Invalid redirect link.");
    exit;
}
?>