<?php
session_start();
include("include/dbcommon.php");

$url = $_GET['url'] ?? '';
$title = trim(rtrim($_GET['title'] ?? '', "'"));
$company = trim(rtrim($_GET['company'] ?? '', "'"));
$clicked_by = $_SESSION["UserID"] ?? 'Guest';

// Default values if missing
if ($title === '') $title = 'Unknown';
if ($company === '') $company = 'Unknown';

if (!empty($url)) {
    // Check for duplicates in last 10 seconds
    $exists = DB::Lookup("
        SELECT 1 FROM click_logs
        WHERE clicked_by=" . db_prepare_string($clicked_by) . "
          AND title=" . db_prepare_string($title) . "
          AND company=" . db_prepare_string($company) . "
          AND redirect_url=" . db_prepare_string($url) . "
          AND clicked_at >= NOW() - INTERVAL 10 SECOND
    ");

    if (!$exists) {
        DB::Insert("click_logs", [
            "job_id" => null,
            "title" => $title,
            "company" => $company,
            "redirect_url" => $url,
            "clicked_by" => $clicked_by,
            "clicked_at" => date("Y-m-d H:i:s"),
            "source" => "external"
        ]);
    }

    header("Location: " . $url);
    exit;
}
echo "Invalid job link.";
?>