<?php
session_start();
include("include/dbcommon.php");

$job_id = isset($_GET['job_id']) ? (int)$_GET['job_id'] : 0;
$clicked_by = $_SESSION["UserID"] ?? 'Guest';

if ($job_id > 0) {
    // Fetch job title and company safely
    $row = DB::Lookup("SELECT Title, Company FROM jobsjobs WHERE ID = " . $job_id, "", true);
    $title = trim(rtrim($row["Title"] ?? '', "'"));
    $companyRow = DB::Lookup("SELECT employer_businessname FROM jobs_profile WHERE user_id = " . (int)($row["Company"] ?? 0), "", true);
    $company = trim(rtrim($companyRow["employer_businessname"] ?? '', "'"));

    // Default values if missing
    if ($title === '') $title = 'Unknown';
    if ($company === '') $company = 'Unknown';

    $redirectUrl = 'jobsjob_view.php?editid1=' . $job_id;

    // Check for duplicates in last 10 seconds
    $exists = DB::Lookup("
        SELECT 1 FROM click_logs
        WHERE clicked_by=" . db_prepare_string($clicked_by) . "
          AND title=" . db_prepare_string($title) . "
          AND company=" . db_prepare_string($company) . "
          AND redirect_url=" . db_prepare_string($redirectUrl) . "
          AND clicked_at >= NOW() - INTERVAL 10 SECOND
    ");

    if (!$exists) {
        DB::Insert("click_logs", [
            "job_id" => $job_id,
            "title" => $title,
            "company" => $company,
            "redirect_url" => $redirectUrl,
            "clicked_by" => $clicked_by,
            "clicked_at" => date("Y-m-d H:i:s"),
            "source" => "internal"
        ]);
    }

    header("Location: " . $redirectUrl);
    exit;
}
echo "Job not found.";
?>