<?php
// Dummy sector data for test - replace with your database logic
$sector_counts = [
    "Government" => 6,
    "Regional" => 3,
    "Private" => 5,
    "Nonprofit" => 2
];
$total_projects = array_sum($sector_counts);

$sector_labels = array_keys($sector_counts);
$sector_data = array_values($sector_counts);
$sector_colors = [
    '#0288d1', '#ffd54f', '#e57373', '#4caf50', '#ab47bc'
];
?>
<!DOCTYPE html>
<html>
<head>
    <title>Portfolio Pie Chart Demo</title>
</head>
<body>
<div class="portfolio-stats" style="text-align:center;margin-bottom:18px;">
    <span style="font-size:1.2em;margin-right:20px;">
        <strong><?= $total_projects ?></strong> Projects
    </span>
    <div style="max-width:320px;margin:12px auto 4px;">
        <canvas id="sectorPie"></canvas>
        <div id="sectorPieLegend" style="text-align:center;margin-top:10px;"></div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    var ctx = document.getElementById('sectorPie').getContext('2d');
    var sectorLabels = <?= json_encode($sector_labels) ?>;
    var sectorData = <?= json_encode($sector_data) ?>;
    var sectorColors = <?= json_encode(array_slice($sector_colors, 0, count($sector_labels))) ?>;
    var chart = new Chart(ctx, {
        type: 'doughnut',
        data: {
            labels: sectorLabels,
            datasets: [{
                data: sectorData,
                backgroundColor: sectorColors,
            }]
        },
        options: {
            plugins: {
                legend: { display: false }
            },
            cutout: "68%",
        }
    });
    // Legend
    var legend = '';
    sectorLabels.forEach(function(label, i) {
        legend += `<span style="display:inline-block;margin:0 9px 5px 0;">
            <span style="display:inline-block;width:14px;height:14px;background:${sectorColors[i]};border-radius:4px;margin-right:6px;vertical-align:middle;"></span>
            ${label} (${sectorData[i]})
        </span>`;
    });
    document.getElementById('sectorPieLegend').innerHTML = legend;
});
</script>
</body>
</html>
