foreach ($jobList as $job) {
        $source = $job['source'];
        $company = $job['company'];
        $sourceSlug = strtolower(preg_replace('/[^a-zA-Z0-9]+/', '-', $source)); // e.g. 'SPREP' => 'sprep'


        // 🧱 Start card
        $cardClass = $isExpired ? 'job-card expired-card' : 'job-card';
				 $html .= "<div class='{$cardClass} card-{$sourceSlug}'>";


        // 🧾 Title and company/org
        $html .= "<h3>" . htmlspecialchars($job['title']) . "</h3>";

        $label = 'Company';
        if (in_array($source, ['SPREP', 'SPC', 'PIFS', 'FFA', 'UNDP'])) {
            $label = 'Organization';
        } elseif ($source === 'Govt') {
            $label = 'Government';
        } elseif ($source === 'PJN') {
            $label = 'Pacific Jobs Network';

        $html .= "<p><strong>$label:</strong> " . htmlspecialchars($company) . "</p>";
        $html .= "<p><strong>Type:</strong> " . htmlspecialchars($job['type']) . "</p>";

        // 📍 Location
        $locationFull = htmlspecialchars($job['location']);
        $locationPreview = mb_strlen($locationFull) > 100 ? mb_substr($locationFull, 0, 100) : $locationFull;
        $hasMoreLocation = mb_strlen($locationFull) > 100;

        $html .= "<p><strong>Location:</strong> ";
        if ($hasMoreLocation) {
            $html .= "<span class='location-preview'>{$locationPreview}...</span>";
            $html .= "<span class='location-full' style='display:none;'>{$locationFull}</span>";
            $html .= "<a href='javascript:void(0)' class='toggle-location' onclick='toggleLocation(this)'>Read more</a>";
        } else {
            $html .= $locationFull;
        }
        $html .= "</p>";
		
		
		)