<script>
document.addEventListener("DOMContentLoaded", function () {
  document.querySelectorAll(".hover-message").forEach(function (el) {
    const title = el.dataset.title || "this role";
    el.innerHTML = `💡 Great fit if you’ve got experience in <strong>${title}</strong>`;
  });

  const toggleBtn = document.getElementById("toggleSearchBtn");
  const floatingSearch = document.getElementById("floatingSearch");
  if (toggleBtn && floatingSearch) {
    toggleBtn.addEventListener("click", function () {
      floatingSearch.classList.toggle("collapsed");
    });
  }

  const clearBtn = document.getElementById("clearSearch");
  const searchInput = document.getElementById("jobSearchInput");

  if (clearBtn && searchInput) {
    clearBtn.addEventListener("click", function () {
      searchInput.value = "";
      filterJobCards("");
    });

    searchInput.addEventListener("input", function () {
      const query = this.value.trim();
      filterJobCards(query);
    });
  }

  function filterJobCards(query) {
    const cards = document.querySelectorAll(".job-card");
    const regex = new RegExp(`(${escapeRegExp(query)})`, "gi");

    cards.forEach(card => {
      const title = card.querySelector("h3")?.innerText || "";
      const company = card.querySelector("p:nth-of-type(1)")?.innerText || "";
      const desc = card.querySelector(".desc-preview, .desc-full")?.innerText || "";
      const combinedText = `${title} ${company} ${desc}`;
      const match = combinedText.toLowerCase().includes(query.toLowerCase());

      card.style.display = match || query === "" ? "block" : "none";

      // Clear old <mark> safely
      card.querySelectorAll("mark").forEach(mark => {
        const parent = mark.parentNode;
        parent.replaceChild(document.createTextNode(mark.textContent), mark);
        parent.normalize(); // Merge adjacent text nodes
      });

      // Highlight matches
      if (match && query !== "") {
        highlightText(card, regex);
      }
    });
  }

  function highlightText(container, regex) {
    const walker = document.createTreeWalker(container, NodeFilter.SHOW_TEXT, null, false);
    const nodesToHighlight = [];

    while (walker.nextNode()) {
      const currentNode = walker.currentNode;
      if (regex.test(currentNode.textContent)) {
        nodesToHighlight.push(currentNode);
      }
    }

    nodesToHighlight.forEach(node => {
      const parent = node.parentNode;
      const frag = document.createDocumentFragment();
      let lastIndex = 0;
      const text = node.textContent;

      text.replace(regex, (match, _, offset) => {
        const before = text.slice(lastIndex, offset);
        if (before) frag.appendChild(document.createTextNode(before));

        const mark = document.createElement('mark');
        mark.textContent = match;
        frag.appendChild(mark);

        lastIndex = offset + match.length;
      });

      const after = text.slice(lastIndex);
      if (after) frag.appendChild(document.createTextNode(after));

      parent.replaceChild(frag, node);
    });
  }

  function escapeRegExp(string) {
    return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
  }
});
</script>