<?php
session_start();
header('Content-Type: text/plain');

// Validate inputs
$sender = $_POST['sender'] ?? '';
$message = $_POST['message'] ?? '';
$session_id = $_POST['session_id'] ?? session_id();

if (!$sender || !$message || !$session_id) {
    http_response_code(400);
    echo "Missing required fields";
    exit;
}

if (strlen($sender) > 50) {
    http_response_code(400);
    echo "Sender name too long.";
    exit;
}

if (strlen($message) > 1000) {
    http_response_code(400);
    echo "Message too long.";
    exit;
}

// Sanitize input
$message = strip_tags($message);
$message = htmlspecialchars($message, ENT_QUOTES, 'UTF-8');

// Command handler
if ($sender === 'admin' && trim($message) === '!clear') {
    $stmt = $pdo->prepare("DELETE FROM chat_messages WHERE session_id = ?");
    $stmt->execute([$session_id]);
    echo "Chat cleared";
    exit;
}

// Ensure session row exists
$pdo->prepare("INSERT IGNORE INTO chat_sessions (session_id) VALUES (?)")->execute([$session_id]);

// Insert message
$stmt = $pdo->prepare("INSERT INTO chat_messages (session_id, sender, message, created_at) VALUES (?, ?, ?, NOW())");
$stmt->execute([$session_id, $sender, $message]);
echo "ok";

?>
