<?php
require_once('db_connect.php');
$res = $conn->query("SELECT * FROM portfolio ORDER BY project_year DESC, id DESC");
$projects = $res->fetch_all(MYSQLI_ASSOC);

$total_projects = count($projects);
$sector_counts = [];
foreach ($projects as $p) {
    $sector = trim($p['sector']);
    if ($sector !== '') {
        $sector_counts[$sector] = ($sector_counts[$sector] ?? 0) + 1;
    }
}
?>

<!-- Portfolio Stats -->
<div class="portfolio-stats" style="text-align:left;margin-bottom:10px;">
    <span style="font-size:1.2em;margin-right:15px;">
        <strong><?= $total_projects ?></strong> Projects
    </span>
    
</div>
<div class="portfolio-stats">
  <!--   <?php foreach ($sector_counts as $sector => $count): ?>-->
   <!--      <button class="filter-btn" data-sector="<?= htmlspecialchars($sector) ?>">-->
   <!--          <?= htmlspecialchars($sector) ?>: <strong><?= $count ?></strong>-->
 <!--        </button>-->
 <!--    <?php endforeach; ?>-->
</div>



<!-- Portfolio Cards List -->
<div class="portfolio-list">
    <?php if (count($projects) === 0): ?>
        <div class="no-projects">No projects in the portfolio yet.</div>
    <?php else: ?>
        <?php foreach ($projects as $row): ?>
            <div class="portfolio-card" data-sector="<?= htmlspecialchars($row['sector']) ?>">
                <div class="portfolio-header">
                    <br>
                    <?php if ($row['project_year']): ?>
                        <div class="project_year"><strong>Year:</strong> <?= htmlspecialchars($row['project_year']) ?></div>
                    <?php endif; ?>
                    <?php if ($row['client']): ?>
                        <div class="client"><strong>Client:</strong> <?= htmlspecialchars($row['client']) ?></div>
                    <?php endif; ?>
                    <?php if ($row['sector']): ?>
                        <div class="sector"><strong>Sector:</strong> <?= htmlspecialchars($row['sector']) ?></div>
                    <?php endif; ?>
                    <?php if ($row['funded_by']): ?>
                        <div class="funded-by"><strong>Funded by:</strong> <?= htmlspecialchars($row['funded_by']) ?></div>
                    <?php endif; ?>
                    <?php if ($row['task']): ?>
                        <div class="task"><strong>Task:</strong> <?= htmlspecialchars($row['task']) ?></div>
                    <?php endif; ?>
                    <?php if ($row['challenge']): ?>
                        <div class="challenge"><strong>Challenge:</strong> <?= htmlspecialchars($row['challenge']) ?></div>
                    <?php endif; ?>
                    <?php if ($row['solution']): ?>
                        <div class="solution"><strong>Solution:</strong> <?= htmlspecialchars($row['solution']) ?></div>
                    <?php endif; ?>
                    <?php if ($row['technologies']): ?>
                        <div class="technologies"><strong>Technologies:</strong> <?= htmlspecialchars($row['technologies']) ?></div>
                    <?php endif; ?>
                    <?php if ($row['result']): ?>
                        <div class="result"><strong>Result:</strong> <?= nl2br(htmlspecialchars($row['result'])) ?></div>
                    <?php endif; ?>
                    <?php if ($row['testimonial']): ?>
                        <div class="testimonial">“<?= htmlspecialchars($row['testimonial']) ?>”</div>
                    <?php endif; ?> <br>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>



<style>
/* Portfolio card styling */
.portfolio-list {
    max-width: 840px;
    margin: 0 auto 30px auto;
}
.portfolio-card {
    background: #fff;
    border-radius: 18px;
    box-shadow: 0 2px 16px #0001;
    padding: 18px 26px 8px 22px;
    margin-bottom: 22px;
    transition: box-shadow 0.16s;
}
.portfolio-card:hover {
    box-shadow: 0 4px 28px #0288d133;
    background: #f7fafc;
}
.portfolio-header > div {
    margin-bottom: 4px;
    font-size: 1.06em;
}
.project_year, .client, .sector, .funded-by {
    display: inline-block;
    margin-right: 18px;
    margin-bottom: 2px;
    padding: 2px 10px;
    border-radius: 8px;
    font-weight: 500;
}
.project_year { background: #e3f2fd; color: #0277bd; }
.sector { background: #fffde7; color: #e65100; }
.client { background: #e8f5e9; color: #388e3c; }
.funded-by { background: #f3e5f5; color: #8e24aa; }
.task, .challenge, .solution, .technologies, .result, .testimonial {
    margin-bottom: 5px;
    margin-left: 2px;
}
.testimonial {
    color: #7b1fa2;
    font-style: italic;
    font-size: 1.05em;
    background: #f3e5f5;
    border-radius: 6px;
    padding: 3px 8px;
}
.no-projects {
    color: #d32f2f;
    text-align: center;
    font-size: 1.2em;
    margin: 20px 0;
}
</style>
