<?php
session_start();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT client_user_id, password, role FROM sso_users WHERE username=? AND is_active=1 LIMIT 1");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $stmt->bind_result($uid, $hash, $role);
    if ($stmt->fetch()) {
        if ($role === 'admin' && password_verify($password, $hash)) {
            // Use a separate session variable for portfolio admin
            $_SESSION['portfolio_admin_logged_in'] = true;
            $_SESSION['portfolio_admin_user_id'] = $uid;
            $_SESSION['portfolio_admin_username'] = $username;
            header('Location: portfolio_admin.php');
            exit();
        } else {
            $error = "Access denied (must be admin).";
        }
    } else {
        $error = "Invalid username or password.";
    }
    $stmt->close();
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Portfolio Admin Login</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f4f7fa; }
        .login-box { max-width: 340px; margin: 80px auto; padding: 2em 2em; background: #fff; border-radius: 12px; box-shadow: 0 2px 24px #aaa; }
        h2 { text-align: center; color: #0288d1; }
        input { width: 100%; padding: 10px; margin: 1em 0; border-radius: 6px; border: 1px solid #bbb; }
        button { width: 100%; background: #0288d1; color: #fff; border: none; padding: 12px 0; border-radius: 8px; font-size: 16px; cursor: pointer; }
        button:hover { background: #026fa4; }
        .error { color: #b71c1c; background: #ffcdd2; padding: 0.5em 1em; border-radius: 6px; margin-bottom: 1em; text-align: center; }
    </style>
</head>
<body>
    <div class="login-box">
        <h2>Portfolio Admin Login</h2>
        <?php if ($error): ?><div class="error"><?= htmlspecialchars($error) ?></div><?php endif; ?>
        <form method="post" autocomplete="off">
            <input type="text" name="username" placeholder="Username" required autofocus>
            <input type="password" name="password" placeholder="Password" required>
            <button type="submit">Login</button>
        </form>
    </div>
</body>
</html>
