<?php
session_start();
require_once('db_connect.php');
if (!isset($_SESSION['portfolio_admin_logged_in']) || !$_SESSION['portfolio_admin_logged_in']) {
    header('Location: portfolio_admin_login.php'); exit();
}
$user_id = $_SESSION['portfolio_admin_user_id'];
// Fetch user role from database
$stmt = $conn->prepare("SELECT role FROM sso_users WHERE client_user_id=? LIMIT 1");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($role);
$stmt->fetch();
$stmt->close();
if ($role !== 'admin') {
    echo "Access denied."; exit();
}

// Handle Add, Edit, Delete
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = trim($_POST['title']);
    $client = trim($_POST['client']);
    $project_year = intval($_POST['project_year']);
    $sector = trim($_POST['sector']);
    $challenge = trim($_POST['challenge']);
    $solution = trim($_POST['solution']);
    $technologies = trim($_POST['technologies']);
    $result = trim($_POST['result']);
    $testimonial = trim($_POST['testimonial']);
    $image_url = trim($_POST['image_url']);
    $id = isset($_POST['id']) ? intval($_POST['id']) : 0;

    if (isset($_POST['delete']) && $id) {
        $stmt = $conn->prepare("DELETE FROM portfolio WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $msg = "Deleted successfully!";
    } elseif ($id) {
        $stmt = $conn->prepare("UPDATE portfolio SET title=?, client=?, project_year=?, sector=?, challenge=?, solution=?, technologies=?, result=?, testimonial=?, image_url=? WHERE id=?");
        $stmt->bind_param("ssisssssssi", $title, $client, $project_year, $sector, $challenge, $solution, $technologies, $result, $testimonial, $image_url, $id);
        $stmt->execute();
        $msg = "Updated successfully!";
    } else {
        $stmt = $conn->prepare("INSERT INTO portfolio (title, client, project_year, sector, challenge, solution, technologies, result, testimonial, image_url) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("ssisssssss", $title, $client, $project_year, $sector, $challenge, $solution, $technologies, $result, $testimonial, $image_url);
        $stmt->execute();
        $msg = "Added successfully!";
    }
}

// For editing: load entry
$edit = null;
if (isset($_GET['edit'])) {
    $eid = intval($_GET['edit']);
    $eres = $conn->query("SELECT * FROM portfolio WHERE id=$eid LIMIT 1");
    if ($eres && $eres->num_rows) $edit = $eres->fetch_assoc();
}

// List all entries
$list = $conn->query("SELECT * FROM portfolio ORDER BY project_year DESC, id DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
<title>Admin Portfolio Management</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
body { font-family: 'Segoe UI', Arial, sans-serif; background:#f4f7fa; margin:0; }
.main { max-width:980px; margin: 32px auto; background: #fff; padding:24px; border-radius:12px; box-shadow:0 2px 16px #ddd;}
h2 { color:#0288d1; margin-bottom:22px;}
table { width:100%; border-collapse: collapse; margin-top:20px;}
th, td { border:1px solid #ccc; padding:8px; text-align:left;}
th { background:#eaf5fb; color:#026fa4; }
tr:nth-child(even) { background:#f6fbff; }
input, textarea, select { width:97%; padding:6px; margin-bottom:9px; border-radius:5px; border:1px solid #bbb; }
label { font-weight:bold; color:#036; }
button { background:#0288d1; color:#fff; border:none; border-radius:6px; padding:8px 16px; cursor:pointer; }
button:hover { background:#015a92; }
.success { background:#e0ffe0; color:#155724; border-left:5px solid #28a745; padding:9px 17px; border-radius:7px; margin-bottom:15px;}
.form-box { background:#f4faff; border-radius:9px; padding:18px 12px; margin-bottom:19px;}
img { max-width:140px; margin:4px 0; border-radius:7px;}
@media (max-width:600px){ .main{padding:10px;} }
</style>
</head>
<body>
<div class="main">
<h2>Manage Portfolio / Case Studies</h2>
<?php if($msg): ?><div class="success"><?=htmlspecialchars($msg)?></div><?php endif; ?>
<div class="form-box">
<form method="post">
    <?php if($edit): ?>
    <input type="hidden" name="id" value="<?=$edit['id']?>">
    <?php endif; ?>
    <label>Title</label><br>
    <input type="text" name="title" required value="<?=htmlspecialchars($edit['title'] ?? '')?>"><br>
    <label>Client</label><br>
    <input type="text" name="client" value="<?=htmlspecialchars($edit['client'] ?? '')?>"><br>
    <label>Year</label><br>
    <input type="number" name="project_year" min="2000" max="2099" value="<?=htmlspecialchars($edit['project_year'] ?? date('Y'))?>"><br>
    <label>Sector</label><br>
    <input type="text" name="sector" value="<?=htmlspecialchars($edit['sector'] ?? '')?>"><br>
    <label>Challenge</label><br>
    <textarea name="challenge" rows="2"><?=htmlspecialchars($edit['challenge'] ?? '')?></textarea><br>
    <label>Solution</label><br>
    <textarea name="solution" rows="2"><?=htmlspecialchars($edit['solution'] ?? '')?></textarea><br>
    <label>Technologies Used</label><br>
    <input type="text" name="technologies" value="<?=htmlspecialchars($edit['technologies'] ?? '')?>"><br>
    <label>Result</label><br>
    <textarea name="result" rows="2"><?=htmlspecialchars($edit['result'] ?? '')?></textarea><br>
    <label>Testimonial</label><br>
    <textarea name="testimonial" rows="2"><?=htmlspecialchars($edit['testimonial'] ?? '')?></textarea><br>
    <label>Image URL</label><br>
    <input type="text" name="image_url" value="<?=htmlspecialchars($edit['image_url'] ?? '')?>"><br>
    <?php if(!empty($edit['image_url'])): ?>
        <img src="<?=htmlspecialchars($edit['image_url'])?>" alt="Portfolio image"><br>
    <?php endif; ?>
    <button type="submit"><?= $edit ? 'Update' : 'Add' ?> Entry</button>
    <?php if($edit): ?>
        <button type="submit" name="delete" value="1" style="background:#d32f2f;">Delete</button>
        <a href="portfolio_admin.php" style="margin-left:12px;">Cancel Edit</a>
    <?php endif; ?>
</form>
</div>

<table>
    <tr>
        <th>Title</th>
        <th>Client</th>
        <th>Year</th>
        <th>Sector</th>
        <th>Challenge</th>
        <th>Solution</th>
        <th>Result</th>
        <th>Image</th>
        <th>Action</th>
    </tr>
    <?php while($row = $list->fetch_assoc()): ?>
    <tr>
        <td><?=htmlspecialchars($row['title'])?></td>
        <td><?=htmlspecialchars($row['client'])?></td>
        <td><?=htmlspecialchars($row['project_year'])?></td>
        <td><?=htmlspecialchars($row['sector'])?></td>
        <td><?=htmlspecialchars($row['challenge'])?></td>
        <td><?=htmlspecialchars($row['solution'])?></td>
        <td><?=htmlspecialchars($row['result'])?></td>
        <td><?php if($row['image_url']): ?><img src="<?=htmlspecialchars($row['image_url'])?>" alt="" style="max-width:90px;"><?php endif; ?></td>
        <td><a href="?edit=<?=$row['id']?>">Edit</a></td>
    </tr>
    <?php endwhile; ?>
</table>
</div>
</body>
</html>
