<?php
require_once('db_connect.php');
$res = $conn->query("SELECT * FROM portfolio");
echo "<pre>"; print_r($res->fetch_all(MYSQLI_ASSOC)); echo "</pre>";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Bitsolution Case Studies & Portfolio</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
    body { font-family: 'Segoe UI', Arial, sans-serif; background: #f4f7fa; margin:0; padding:0; }
    .portfolio-container { max-width: 920px; margin: 36px auto; padding: 0 14px;}
    .portfolio-title { font-size:2.1em; color: #0288d1; margin-bottom:18px;}
    .portfolio-item { background: #fff; border-radius: 14px; box-shadow: 0 2px 14px #ccd; padding: 28px 22px; margin-bottom: 26px; }
    .portfolio-item h3 { margin:0 0 12px 0; color: #1c85e8;}
    .portfolio-meta { color: #666; margin-bottom: 8px; }
    .portfolio-label { color: #0288d1; font-weight: bold;}
    .portfolio-item img { max-width: 360px; width:100%; border-radius: 10px; margin: 16px 0; display:block;}
    blockquote { background: #f6faff; border-left: 4px solid #0288d1; margin:16px 0; padding: 12px 18px; color: #0b5678;}
    @media (max-width:600px){ .portfolio-item {padding:18px 7px;} }
    </style>
</head>
<body>
<div class="portfolio-container">
    <div class="portfolio-title">Our Work: Case Studies & Portfolio</div>
    <?php while($row = $result->fetch_assoc()): ?>
    <div class="portfolio-item">
        <h3><?=htmlspecialchars($row['title'])?></h3>
        <div class="portfolio-meta">
            <span class="portfolio-label">Client:</span> <?=htmlspecialchars($row['client'])?> |
            <span class="portfolio-label">Year:</span> <?=htmlspecialchars($row['project_year'])?> |
            <span class="portfolio-label">Sector:</span> <?=htmlspecialchars($row['sector'])?>
        </div>
        <p><span class="portfolio-label">Challenge:</span> <?=nl2br(htmlspecialchars($row['challenge']))?></p>
        <p><span class="portfolio-label">Solution:</span> <?=nl2br(htmlspecialchars($row['solution']))?></p>
        <?php if(!empty($row['technologies'])): ?>
        <p><span class="portfolio-label">Technologies:</span> <?=htmlspecialchars($row['technologies'])?></p>
        <?php endif; ?>
        <p><span class="portfolio-label">Result:</span> <?=nl2br(htmlspecialchars($row['result']))?></p>
        <?php if(!empty($row['testimonial'])): ?>
        <blockquote><?=nl2br(htmlspecialchars($row['testimonial']))?></blockquote>
        <?php endif; ?>
        <?php if(!empty($row['image_url'])): ?>
        <img src="<?=htmlspecialchars($row['image_url'])?>" alt="Project Image">
        <?php endif; ?>
    </div>
    <?php endwhile; ?>
    <?php if($result->num_rows == 0): ?>
        <div>No case studies yet.</div>
    <?php endif; ?>
</div>
</body>
</html>
