<?php
// load_public_dashboard.php
@ini_set("display_errors", "1");
@ini_set("display_startup_errors", "1");
include_once("dbcommon.php");
include_once("merged_jobs_feed.php"); // includes fetchFromHimalayas()

// -------------------------------
// Step 1: Determine Year Filter
// -------------------------------
$year = isset($_GET['year']) ? $_GET['year'] : 'all';
$selected_year = $year;
$filter_label = "All Data";
$whereClause = "1 = 1";

switch ($selected_year) {
    case "this_month":
        $filter_label = "This Month";
        $whereClause = "MONTH(DateAdded) = MONTH(CURRENT_DATE()) AND YEAR(DateAdded) = YEAR(CURRENT_DATE())";
        break;
    case "last_12_months":
        $filter_label = "Last 12 Months";
        $whereClause = "DateAdded >= DATE_SUB(CURDATE(), INTERVAL 12 MONTH)";
        break;
    case "all":
    default:
        $filter_label = "All Data";
        $whereClause = "1 = 1";
        break;
}

$xt->assign("selected_year", $selected_year);
$xt->assign("filter_label", $filter_label);

// -------------------------------
// Step 2: Count Active Jobs
// -------------------------------
$himalayasJobs = count(fetchFromHimalayas());

// -------------------------------
// Step 3: Chart by Source using SQL
// -------------------------------
$sourceCountsSql = "
    SELECT source, COUNT(*) AS job_count
    FROM (
        SELECT 'Local' AS source FROM jobsjobs WHERE $whereClause AND COALESCE(extended_due_date, due_date) >= CURDATE()
        UNION ALL
        SELECT source FROM external_jobs WHERE source IN ('Govt', 'SPREP', 'SPC', 'PIFS', 'UNDP') AND (expiry_date IS NULL OR expiry_date >= CURDATE())
    ) AS all_sources
    GROUP BY source
    ORDER BY FIELD(source, 'Local', 'Govt', 'SPREP', 'SPC', 'PIFS', 'UNDP')
";

$data = [];
$rs = DB::Query($sourceCountsSql);
$total = 0;

while ($row = $rs->fetchAssoc()) {
    $data[] = $row;
    $total += (int)$row["job_count"];
}

// Append Himalayas API count manually
$data[] = ["source" => "Himalayas", "job_count" => $himalayasJobs];
$total += $himalayasJobs;

// Assign for Chart.js
$xt->assign("chart_labels", json_encode(array_column($data, 'source')));
$xt->assign("chart_values", json_encode(array_column($data, 'job_count')));
$xt->assign("chart_total", $total);

// Assign individual counts for display cards
$sourceMap = ["Local" => 0, "Govt" => 0, "SPREP" => 0, "SPC" => 0, "PIFS" => 0, "UNDP" => 0];
foreach ($data as $row) {
    if (isset($sourceMap[$row['source']])) {
        $sourceMap[$row['source']] = $row['job_count'];
    }
}
$xt->assign("localJobs", $sourceMap['Local']);
$xt->assign("govtJobs", $sourceMap['Govt']);
$xt->assign("sprepJobs", $sourceMap['SPREP']);
$xt->assign("spcJobs", $sourceMap['SPC']);
$xt->assign("pifsJobs", $sourceMap['PIFS']);
//$xt->assign("undpJobs", $sourceMap['UNDP']);
$xt->assign("himalayasJobs", $himalayasJobs);

$xt->assign("show_dashboard_cards", true);

// -------------------------------
// Step 4: Available Years for Dropdown
// -------------------------------
$available_years = [];
$rsYears = DB::Query("SELECT DISTINCT YEAR(DateAdded) AS year FROM jobsjobs WHERE DateAdded IS NOT NULL ORDER BY year DESC");
while ($row = $rsYears->fetchAssoc()) {
    $available_years[] = $row["year"];
}
$xt->assign("available_years", $available_years);

// -------------------------------
// Step 5: Auto-refresh JS
// -------------------------------
$xt->assign("auto_refresh_script", "<script>
  setInterval(function() {
    fetch(window.location.href, { method: 'GET' })
      .then(res => res.ok && window.location.reload());
  }, 300000);
</script>");
