<?php
@ini_set("display_errors", "1");
@ini_set("display_startup_errors", "1");
include("include/dbcommon.php");

global $xt;

$job_cards = "";
$job_count = 0;
$today = date('Y-m-d');

// Fetch job records
$sql = "
    SELECT
        jobsjobs.ID,
        jobsjobs.Title,
        COALESCE(jobsjobs.DateAdded, due_date) AS expire_date,
        jobsjobs.City,
        jobsjobs.Company,
        jobs_profile.employer_businessname,
        jobsjobs.Description
    FROM jobsjobs
    LEFT JOIN jobs_profile ON jobsjobs.Company = jobs_profile.user_id
    WHERE COALESCE(extended_due_date, due_date) > CURDATE() - INTERVAL 7 DAY
    ORDER BY jobsjobs.Title ASC
    LIMIT 8
";
$rs = DB::Query($sql);

// Build cards
while ($job = $rs->fetchAssoc()) {
    $job_count++;
    $job_id = (int)$job['ID'];
    $title = htmlspecialchars($job['Title']);
    $company = htmlspecialchars($job['employer_businessname']);
    $city = htmlspecialchars($job['City']);
    $desc_full = strip_tags(html_entity_decode($job['Description']));
    $desc_preview = mb_substr($desc_full, 0, 150) . "...";

    // Expiry
  $expireRaw = $job['expire_date'];
$expiryTime = strtotime($expireRaw);
$formattedDate = date("d M Y", $expiryTime);
$timeDiffSeconds = $expiryTime - time();
$daysRemaining = floor($timeDiffSeconds / 86400);

$closingSoon = false;
$isExpired = false;
$graceMessage = '';

// 👀 If job is within 7 days before expiry
if ($daysRemaining <= 7 && $daysRemaining > 0) {
    $closingSoon = true;

} elseif ($daysRemaining < 0) {
    $daysSinceExpiry = abs($daysRemaining);

    if ($daysSinceExpiry <= 7) {
        $leftSeconds = (7 * 86400) - abs($timeDiffSeconds);

        if ($leftSeconds <= 0) {
            $graceMessage = "🔒 Expired — auto-archiving now.";
        } elseif ($leftSeconds < 60) {
            $graceMessage = "🔒 Expired — auto-archiving in < 1 min.";
        } elseif ($leftSeconds < 3600) {
            $mins = floor($leftSeconds / 60);
            $graceMessage = "🔒 Expired — waiting for possible extension. Auto-archiving in {$mins} min" . ($mins != 1 ? "s" : "") . ".";
        } elseif ($leftSeconds < 86400) {
            $hrs = floor($leftSeconds / 3600);
            $mins = floor(($leftSeconds % 3600) / 60);
            $graceMessage = "🔒 Expired — waiting for possible extension. Auto-archiving in {$hrs} hr" . ($hrs != 1 ? "s" : "");
            if ($mins > 0) {
                $graceMessage .= " {$mins} min" . ($mins != 1 ? "s" : "");
            }
            $graceMessage .= ".";
        } else {
            $leftDays = floor($leftSeconds / 86400);
            $graceMessage = "🔒 Expired — waiting for possible extension. Auto-archiving in {$leftDays} day" . ($leftDays != 1 ? "s" : "") . ".";
        }
    } else {
        $isExpired = true;
		$graceMessage = "🔒 Expired — no extension received.";
    }
}
 //If it's expired more than 7 days ago, it is flagged as fully expired and should be archived.

    // Build job card
    $job_cards .= "<div class='job-card'>";
    $job_cards .= "<a href='javascript:void(0)' class='apply-now-btn' onclick='showApplyMessage(this, {$job_id})'>Apply</a>";
    $job_cards .= "<div class='apply-message-popup' style='display:none;'>You need to register to apply.<br><button onclick=\"openModal('register.php?page=register_jobseeker')\">Register</button></div>";
    $job_cards .= "<h3>{$title}</h3>";
    $job_cards .= "<p><strong>Company:</strong> {$company}</p>";
    $job_cards .= "<p><strong>City:</strong> {$city}</p>";
    $job_cards .= "<p><strong>Expires:</strong> {$formattedDate}";

if (!empty($graceMessage)) {
    $job_cards .= " <span class='grace-message'>{$graceMessage}</span>";
}

if ($isExpired) {
    $job_cards .= " <span class='expired-tag'>🔒 Archived</span>";
} elseif ($closingSoon) {
    $label = $daysRemaining == 1 ? "day" : "days";
    $job_cards .= " <span class='closing-soon-animated'>🔴 Closing in {$daysRemaining} {$label}</span>";
}


    $job_cards .= "</p>";
    $job_cards .= "
        <p><strong>Description:</strong>
            <span class='desc-preview'>{$desc_preview}</span>
            <span class='desc-full' style='display:none;'>{$desc_full}</span>
            <a href='javascript:void(0)' class='toggle-desc' onclick='toggleDescription(this)'>Read more</a>
        </p>";
    $job_cards .= "</div>";
}

// No jobs fallback
if ($job_count === 0) {
    $job_cards = "
        <div class='no-local-jobs'>
            <h3>&#10060;  No Local Jobs Posted</h3>
            <p>There are currently no active or recently expired jobs posted on this platform.<br>
            Please refer to the government, regional, and international job feeds below for live opportunities.</p>
        </div>";
    $xt->assign("show_local_heading", false);
    $xt->assign("show_load_more_button", false);
} else {
    $xt->assign("show_local_heading", true);
    $xt->assign("show_load_more_button", true);
}

$xt->assign("job_cards", $job_cards);
