<?php
// load_external_chart_data.php

//$govtJobs = DBLookup("SELECT COUNT(*) FROM external_jobs WHERE source = 'Govt'");
//$sprepJobs = DBLookup("SELECT COUNT(*) FROM external_jobs WHERE source = 'SPREP'");
//$spcJobs = DBLookup("SELECT COUNT(*) FROM external_jobs WHERE source = 'SPC'");
//$undpJobs = DBLookup("SELECT COUNT(*) FROM external_jobs WHERE source = 'UNDP'");
//$pifsJobs = DBLookup("SELECT COUNT(*) FROM external_jobs WHERE source = 'PIFS'");

function getJobCountsBySource($source) {
    $active = DBLookup("SELECT COUNT(*) FROM external_jobs WHERE source = '$source' AND expiry_date > CURDATE()");
    $expired7 = DBLookup("SELECT COUNT(*) FROM external_jobs WHERE source = '$source' AND expiry_date <= CURDATE() AND expiry_date >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)");
	$archived = DBLookup("SELECT COUNT(*) FROM external_jobs WHERE source = '$source' AND expiry_date < DATE_SUB(CURDATE(), INTERVAL 7 DAY)");

    return [
        'active' => $active,
        'expired7' => $expired7,
        'archived' => $archived
    ];
}

// Fetch all sources
$sources = ['Govt', 'SPREP', 'SPC', 'UNDP', 'FFA', 'PJN', 'PIFS'];
foreach ($sources as $src) {
    $key = strtolower($src); // govt, sprep, etc.
    $counts = getJobCountsBySource($src);
	
	// Formatted for display
    $xt->assign("{$key}_active", number_format($counts['active']) . " Active");
    $xt->assign("{$key}_expired7", number_format($counts['expired7']) . " Expired (7d)");
    $xt->assign("{$key}_archived", number_format($counts['archived']) . " Archived");
	
	// Raw values for Chart.js
    $xt->assign("{$key}_active_raw", $counts['active']);
    $xt->assign("{$key}_expired7_raw", $counts['expired7']);
    $xt->assign("{$key}_archived_raw", $counts['archived']);

}

$xt->assign("govtJobs", $govtJobs);
$xt->assign("sprepJobs", $sprepJobs);
$xt->assign("spcJobs", $spcJobs);
$xt->assign("undpJobs", $undpJobs);
$xt->assign("pifsJobs", $pifsJobs);
$xt->assign("ffaJobs", $ffaJobs);
$xt->assign("pjnJobs", $pjnJobs);

// Year filter
$year = isset($_GET['year']) ? $_GET['year'] : 'all';
$xt->assign("selected_year", $year);

switch ($year) {
    case "this_month":
        $filter_label = "This Month";
        $where = "WHERE MONTH(created_at) = MONTH(CURRENT_DATE()) AND YEAR(created_at) = YEAR(CURRENT_DATE())";
        break;
    case "last_12_months":
        $filter_label = "Last 12 Months";
        $where = "WHERE created_at >= DATE_SUB(CURDATE(), INTERVAL 12 MONTH)";
        break;
    case "all":
    default:
        $filter_label = "All Data";
        $where = "";
        break;
}

$xt->assign("filter_label", $filter_label);

// Chart data from external_jobs
$sql = "SELECT COUNT(id) AS source_count, source
        FROM external_jobs
        $where
        GROUP BY source";

$data = [];
$total = 0;
$rs = DB::Query($sql);
if ($rs) {
    while ($row = $rs->fetchAssoc()) {
        $data[] = $row;
        $total += $row["source_count"];
    }
}

$xt->assign("chart_labels", json_encode(array_column($data, 'source')));
$xt->assign("chart_values", json_encode(array_column($data, 'source_count')));
$xt->assign("chart_total", $total);

// Years
$available_years = [];
$rsYears = DB::Query("SELECT DISTINCT YEAR(created_at) AS year FROM external_jobs WHERE created_at IS NOT NULL ORDER BY year DESC");
while ($row = $rsYears->fetchAssoc()) {
    $available_years[] = $row["year"];
}
$xt->assign("available_years", $available_years);
