<?php
// load_external_chart_data.php

function getJobCountsBySource($source) {
    $active = DBLookup("SELECT COUNT(*) FROM external_jobs WHERE source = " . db_prepare_string($source) . " AND expiry_date > CURDATE()");
    $expired7 = DBLookup("SELECT COUNT(*) FROM external_jobs WHERE source = " . db_prepare_string($source) . " AND expiry_date <= CURDATE() AND expiry_date >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)");
    $archived = DBLookup("SELECT COUNT(*) FROM external_jobs WHERE source = " . db_prepare_string($source) . " AND expiry_date < DATE_SUB(CURDATE(), INTERVAL 7 DAY)");

    return [
        'active' => $active,
        'expired7' => $expired7,
        'archived' => $archived
    ];
}

// 🔗 Himalayas API Fetch
function getHimalayasCount() {
    $response = @file_get_contents("https://himalayas.app/jobs/api");
    if (!$response) return 0;

    $data = json_decode($response, true);
    $now = time();
    $count = 0;

    foreach ($data['jobs'] ?? [] as $job) {
        $expiryRaw = $job['expiryDate'] ?? null;

        if (is_numeric($expiryRaw)) {
            $expiry = ($expiryRaw > 9999999999) ? intval($expiryRaw / 1000) : intval($expiryRaw);
        } else {
            $expiry = strtotime($expiryRaw);
        }

        if ($expiry && $expiry > $now) {
            $count++;
        }
    }

    return $count;
}

// ------------------------
// Sources to include
// ------------------------
$sources = ['Govt', 'SPREP', 'SPC', 'UNDP', 'FFA', 'PJN', 'PIFS'];
foreach ($sources as $src) {
    $key = strtolower($src);
    $counts = getJobCountsBySource($src);

    $xt->assign("{$key}_active", number_format($counts['active']) . " Active");
    $xt->assign("{$key}_expired7", number_format($counts['expired7']) . " Expired (7d)");
    $xt->assign("{$key}_archived", number_format($counts['archived']) . " Archived");

    $xt->assign("{$key}_active_raw", $counts['active']);
    $xt->assign("{$key}_expired7_raw", $counts['expired7']);
    $xt->assign("{$key}_archived_raw", $counts['archived']);
}

// Assign for flip card charts
$xt->assign("govtJobs", getJobCountsBySource('Govt')['active']);
$xt->assign("sprepJobs", getJobCountsBySource('SPREP')['active']);
$xt->assign("spcJobs", getJobCountsBySource('SPC')['active']);
$xt->assign("undpJobs", getJobCountsBySource('UNDP')['active']);
$xt->assign("pifsJobs", getJobCountsBySource('PIFS')['active']);
$xt->assign("ffaJobs", getJobCountsBySource('FFA')['active']);
$xt->assign("pjnJobs", getJobCountsBySource('PJN')['active']);

// 🌐 Himalayas - only Active count (live)
$himalayasCount = getHimalayasCount();
$xt->assign("himalayas_active", number_format($himalayasCount) . " Active");
$xt->assign("himalayas_expired7", "0 Expired (7d)");
$xt->assign("himalayas_archived", "0 Archived");
$xt->assign("himalayas_active_raw", $himalayasCount);
$xt->assign("himalayas_expired7_raw", 0);
$xt->assign("himalayas_archived_raw", 0);

// ------------------------
// Year filter
// ------------------------
$year = $_GET['year'] ?? 'all';
$xt->assign("selected_year", $year);

$where = "";
switch ($year) {
    case "this_month":
        $filter_label = "This Month";
        $where = "WHERE MONTH(expiry_date) = MONTH(CURRENT_DATE()) AND YEAR(expiry_date) = YEAR(CURRENT_DATE())";
        break;
    case "last_12_months":
        $filter_label = "Last 12 Months";
        $where = "WHERE expiry_date >= DATE_SUB(CURDATE(), INTERVAL 12 MONTH)";
        break;
    default:
        $filter_label = "Count";
}
$xt->assign("filter_label", $filter_label);

// ------------------------
// Chart Data by Source (only active jobs)
// ------------------------
$sql = "SELECT COUNT(id) AS source_count, source 
        FROM external_jobs 
        WHERE expiry_date > CURDATE()
        GROUP BY source";

$data = [];
$total = 0;
$rs = DB::Query($sql);
if ($rs) {
    while ($row = $rs->fetchAssoc()) {
        $data[] = $row;
        $total += $row["source_count"];
    }
} else {
    error_log("Chart query failed: $sql");
}

// 📌 Add Himalayas to the bar chart
if ($himalayasCount > 0) {
    $data[] = ['source' => 'Himalayas', 'source_count' => $himalayasCount];
    $total += $himalayasCount;
}

$xt->assign("chart_labels", json_encode(array_column($data, 'source')));
$xt->assign("chart_values", json_encode(array_column($data, 'source_count')));
$xt->assign("chart_total", $total);

// ------------------------
// Available Years
// ------------------------
$available_years = [];
$rsYears = DB::Query("SELECT DISTINCT YEAR(expiry_date) AS year FROM external_jobs WHERE expiry_date IS NOT NULL ORDER BY year DESC");
if ($rsYears) {
    while ($row = $rsYears->fetchAssoc()) {
        $available_years[] = $row["year"];
    }
}
$xt->assign("available_years", $available_years);
?>
