<?php
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");

include("include/dbcommon.php");

if (!isLogged()) {
    HeaderRedirect("login.php");
    exit();
}

$today = date('Y-m-d');
$job_cards = "";
$rs = db_query("SELECT Title, Company, City, DateAdded, COALESCE(extended_due_date, due_date) AS expire_date FROM jobsjobs WHERE COALESCE(extended_due_date, due_date) >= '$today' ORDER BY DateAdded DESC");
while ($job = db_fetch_array($rs)) {
  $job_cards .= "<div class='job-card'>";
  $job_cards .= "<h3>" . htmlspecialchars($job['Title']) . "</h3>";
  $job_cards .= "<p><strong>Company:</strong> " . htmlspecialchars($job['Company']) . "</p>";
  $job_cards .= "<p><strong>City:</strong> " . htmlspecialchars($job['City']) . "</p>";
  $job_cards .= "<p><strong>Posted:</strong> " . htmlspecialchars($job['DateAdded']) . "</p>";
  $job_cards .= "<p><strong>Expires:</strong> " . htmlspecialchars($job['expire_date']) . "</p>";
  $job_cards .= "</div>";
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Job Listings</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body { font-family: Arial; padding: 20px; }
    .toolbar { text-align: center; margin-bottom: 20px; }
    .toolbar input, .toolbar button { margin: 5px; padding: 8px; }
    .job-card { border-bottom: 1px solid #ccc; padding: 10px; }
    .job-card h3 { margin: 0; color: #007BFF; }
    .job-card p { margin: 4px 0; }
  </style>
</head>
<body>
<h2>Available Job Listings</h2>
<div class="toolbar">
  <input type="text" id="filterInput" placeholder="🔍 Filter by Title">
  <button onclick="printJobs()">🖨 Print</button>
  <button onclick="downloadCSV()">⬇ Download CSV</button>
</div>
<div id="jobsContainer">
  <?php echo $job_cards; ?>
</div>
<div class="share-buttons">
  <span>🔗 Share: </span>
  <a href="mailto:?subject=Job%20Listings&body=Check%20out%20these%20job%20listings!%20<?php echo urlencode('https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']); ?>" target="_blank">📧 Email</a>
  <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode('https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']); ?>" target="_blank">📘 Facebook</a>
  <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo urlencode('https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']); ?>&title=Job%20Listings" target="_blank">🔗 LinkedIn</a>
</div>
<script>
function filterJobs() {
  const input = document.getElementById("filterInput");
  const filter = input.value.toLowerCase();
  const cards = document.querySelectorAll(".job-card");
  cards.forEach(card => {
    const title = card.querySelector("h3").textContent.toLowerCase();
    card.style.display = title.includes(filter) ? "block" : "none";
  });
}
document.getElementById("filterInput").addEventListener("keyup", filterJobs);

function printJobs() {
  const printContents = document.getElementById("jobsContainer").innerHTML;
  const printWindow = window.open('', '', 'height=600,width=800');
  printWindow.document.write('<html><head><title>Print Jobs</title></head><body>');
  printWindow.document.write(printContents);
  printWindow.document.write('</body></html>');
  printWindow.document.close();
  printWindow.print();
}

function downloadCSV() {
  let csvContent = "data:text/csv;charset=utf-8,Title,Company,City,Posted,Expires\n";
  const cards = document.querySelectorAll(".job-card");
  cards.forEach(card => {
    const title = card.querySelector("h3").textContent;
    const details = card.querySelectorAll("p");
    const row = [title];
    details.forEach(p => row.push(p.textContent.split(': ')[1]));
    csvContent += row.join(",") + "\n";
  });
  const encodedUri = encodeURI(csvContent);
  const link = document.createElement("a");
  link.setAttribute("href", encodedUri);
  link.setAttribute("download", "active_jobs.csv");
  document.body.appendChild(link);
  link.click();
  document.body.removeChild(link);
}
</script>
</body>
</html>
