<?php
include("include/dbcommon.php");
if (!isLogged()) {
    HeaderRedirect("login.php");
    exit();
}
$rs = db_query("SELECT * FROM jobsjobs ORDER BY DateAdded DESC");
?>
<!DOCTYPE html>
<html>
<head>
  <title>Job Listings</title>
  <style>
    body { font-family: Arial; padding: 20px; }
    table { width: 100%; border-collapse: collapse; }
    th, td { padding: 10px; border-bottom: 1px solid #ccc; text-align: left; }
    th { background-color: #f4f4f4; }
  </style>
</head>
<body>
<h2>Available Job Listings</h2>
<table>
  <tr><th>Title</th><th>Company</th><th>City</th><th>Date</th></tr>
  <?php while($data = db_fetch_array($rs)) { ?>
  <tr>
    <td><?= htmlspecialchars($data['Title']) ?></td>
    <td><?= htmlspecialchars($data['Company']) ?></td>
    <td><?= htmlspecialchars($data['City']) ?></td>
    <td><?= htmlspecialchars($data['DateAdded']) ?></td>
  </tr>
  <?php } ?>
</table>
</body>
</html>
