<!doctype html>
<html  {$html_attrs}>
	<head>
	<meta http-equiv="X-UA-Compatible" content="IE=Edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>{$pagetitle}</title>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<base href="{$projectPath}">
	<link REL="stylesheet" href="styles/default.css?{$wizardBuildKey}" type="text/css">
	{BEGIN rtlCSS}
	<link REL="stylesheet" href="styles/defaultRTL.css?{$wizardBuildKey}" type="text/css">
	{END rtlCSS}
	{BEGIN styleCSSFiles}
	<link REL="stylesheet" href="{$stylepath}" type="text/css">
	{END styleCSSFiles}
	<!-- charts -->
	<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>
	<!-- External JS -->
    <script src="custom_assets/js/dashboard.js?v=1.0"></script>
    <!-- Optional CSS -->
    <link rel="stylesheet" href="custom_assets/css/dashboard.css?v=1.0">
   	
	</head>
	<body class="{$stylename} function-list">
	<!-- External JS -->
    <script src="custom_assets/js/dashboard.js?v=1.0"></script>
    <!-- Optional CSS -->
    <link rel="stylesheet" href="custom_assets/css/dashboard.css?v=1.0">

<style>
{$containerCss}
 .dashboard {
  display: flex;
  flex-wrap: wrap;
  gap: 12px;
  justify-content: center;
  padding: 10px;
  transition: all 0.3s ease;
}

.dashboard-toggle-btn {
  position: fixed;
  bottom: 0;
  left: 50%;
  transform: translateX(-50%);
  background: #b45309;
  color: white;
  padding: 10px 28px;
  border: none;
  border-top: 6px solid orange;
  font-weight: bold;
  border-radius: 12px 12px 0 0;
  box-shadow: 0 -4px 8px rgba(0,0,0,0.15);
  cursor: pointer;
  z-index: 999;
  transition: all 0.3s ease;
}

.dashboard-toggle-btn.top {
  position: relative;
  margin: 10px 8px;
  top: auto;
  left: auto;
  transform: none;
  border-radius: 6px;
  padding: 6px 16px;
  font-size: 13px;
  border-top: none;
  box-shadow: 0 2px 6px rgba(0,0,0,0.1);
  display: inline-block;
  background-color: #b45309;
  color: white;
}

.dashboard-hidden,
.dashboard-charts-hidden,
.dashboard-filters-hidden {
  display: none;
  position: relative;
}

#dashboardCharts,
#dashboardFilters {
  transition: all 0.3s ease;
}

.chart-container-user-posted {
  width: 100%;
  height: 300
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  position: relative;
  margin: 0 auto;
}

.chart-container-user-posted h4 {
  margin-bottom: 8px;
  font-size: 16px;
  text-align: center;
  color: #333;
}
	/* Make UI Mobile-Friendly */
    @media (max-width: 600px) {
    .dashboard, .jobs-grid {
    flex-direction: column;
    align-items: center;
    }
    .card, .job-card {
    width: 100%;
    max-width: 90%;
    }
}

?*latest below*/
/* 🔁 Shared ::before layout for all logos */
.job-card::before {
  content: "";
  position: absolute;
  bottom: 0;
  right: 0;
  width: 100%;
  height: 100%;
  z-index: 1;
  background-position: bottom right;
  background-repeat: no-repeat;
  background-size: 100px auto;
  pointer-events: none;
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.95), rgba(255,255,255,0)),
    url('images/logos/default.png'); /* fallback */
}

/* ✅ Logo overrides */

.card-logo-govt::before {
  background-image: url('images/logos/govt.png');
  background-size: 60px auto;
  background-repeat: no-repeat;
  background-position: bottom right;
  opacity: 0.2;
  pointer-events: none;
}

.card-logo-sprep::before {
  background-image: url('images/logos/sprep_logo.png');
  background-size: 60px auto;
  background-repeat: no-repeat;
  background-position: bottom right;
  opacity: 0.2;
}

.card-logo-undp::before {
  background-image: url('images/logos/undp.png');
  background-size: 60px auto;
  background-repeat: no-repeat;
  background-position: bottom right;
  opacity: 0.2;
}

.card-logo-spc::before {
  background-image: url('images/logos/spc.png');
  background-size: 60px auto;
  background-repeat: no-repeat;
  background-position: bottom right;
  opacity: 0.2;
}

.card-logo-pifs::before {
  background-image: url('images/logos/pifs.png');
  background-size: 60px auto;
  background-repeat: no-repeat;
  background-position: bottom right;
  opacity: 0.2;
}

.card-logo-ffa::before {
  background-image: url('images/logos/ffa.png');
  background-size: 60px auto;
  background-repeat: no-repeat;
  background-position: bottom right;
  opacity: 0.2;
}

.card-logo-himalayas::before {
  background-image: url('images/logos/himalayas.png');
  background-size: 60px auto;
  background-repeat: no-repeat;
  background-position: bottom right;
  opacity: 0.2;
}


.card-sprep:hover::before,
.card-govt:hover::before,
.card-undp:hover::before,
.card-spc:hover::before,
.card-pifs:hover::before,
.card-ffa:hover::before,
.card-himalayas:hover::before {
  opacity: 0.08;
  filter: saturate(1.1) brightness(1.5);
}

/* 🔺 Top-left triangle tag (uses ::after so it doesn't conflict with ::before logos) */
.job-card::after {
  content: "";
  position: absolute;
  top: 0;
  left: 0;
  width: 0;
  height: 0;
  border-style: solid;
  border-width: 0 28px 28px 0;
  border-color: transparent #f59e0b transparent transparent; /* default */
  z-index: 3;
  border-radius: 0 0 4px 0;
  box-shadow: 0 2px 4px rgba(0,0,0,0.2);
}



/* 🌐 Source-specific triangle colors */
/* Override based on tag- sourceSlug */
.tag-govt::after      { border-color: transparent #3b82f6 transparent transparent; } /* blue */
.tag-sprep::after     { border-color: transparent #10b981 transparent transparent; } /* green */
.tag-undp::after      { border-color: transparent #6366f1 transparent transparent; } /* indigo */
.tag-spc::after       { border-color: transparent #0ea5e9 transparent transparent; } /* sky */
.tag-pifs::after      { border-color: transparent #ec4899 transparent transparent; } /* pink */
.tag-ffa::after       { border-color: transparent #f59e0b transparent transparent; } /* amber */
.tag-pjn::after       { border-color: transparent #facc15 transparent transparent; } /* yellow */
.tag-public::after    { border-color: transparent #9ca3af transparent transparent; } /* gray */
.tag-himalayas::after { border-color: transparent #8b5cf6 transparent transparent; } /* violet */

/* 🌙 Optional dark mode refinement */
body.dark-mode .job-card::after {
  opacity: 0.85;
}







/* ✅ Grace period tag - Light mode */
.grace-message {
  display: inline-block;
  background-color: #fff3cd; /* soft warning yellow */
  color: #856404;
  border: 1px solid #ffeeba;
  padding: 6px 10px;
  border-radius: 6px;
  font-size: 13px;
  margin-top: 6px;
}

/* 🌙 Dark mode override */
body.dark-mode .grace-message {
  background-color: rgba(255, 193, 7, 0.1); /* subtle dark amber */
  color: #ffc107; /* warm yellow text */
  border: 1px solid rgba(255, 193, 7, 0.3);
  backdrop-filter: blur(2px);
}



.badge-closing-inline {
  display: inline-block;
  padding: 2px 8px;
  font-size: 11px;
  border-radius: 4px;
  margin-left: 8px;
  font-weight: bold;
  vertical-align: middle;
}

.urgent-red {
  background-color: #dc3545;
  color: #fff;
}

.closing-soon-animated {
  background: #fdecea;
  color: #b91c1c;
  padding: 5px 10px;
  border-radius: 5px;
  font-size: 0.85em;
  display: inline-block;
  margin-top: 4px;
  font-weight: 500;
}

.closing-soon-animated:hover {
  transform: translateY(-2px) scale(1.05);
  font-size: 14px;
}

.expired-tag {
  margin-left: 6px;
  color: #6c757d;
  background-color: #e2e3e5;
  font-size: 13px;
  font-weight: bold;
  padding: 4px 8px;
  border-radius: 4px;
}

.expired-card {
  opacity: 0.6;
  filter: grayscale(20%);
/*  pointer-events: none;  optional: disable clicks */
}

.grace-message {
  display: inline-block;
  margin-left: 6px;
  font-size: 13px;
  color: #856404;
  background-color: #fff3cd;
  border-left: 4px solid #fd7e14;
  padding: 4px 8px;
  border-radius: 4px;
}


.no-local-jobs {
  background: #fff6f6;
  border: 1px solid #f5c2c7;
  color: #842029;
  padding: 20px 30px;
  border-radius: 12px;
  text-align: center;
  box-shadow: 0 2px 6px rgba(0,0,0,0.05);
  font-family: 'Segoe UI', sans-serif;
  max-width: 700px;
  margin: 40px auto;
  position: relative;
  transition: all 0.4s ease-in-out;
}

.dismiss-btn {
  position: absolute;
  top: 10px;
  right: 15px;
  border: none;
  background: transparent;
  font-size: 18px;
  color: #d63384;
  cursor: pointer;
  transition: opacity 0.3s;
}
.dismiss-btn:hover {
  opacity: 0.6;
}


.no-local-jobs h3 {
  font-size: 1.5rem;
  color: #d63384;
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 8px;
}

.no-local-jobs p {
  font-size: 1rem;
  line-height: 1.5;
  margin-top: 10px;
}

.jobs-grid {
display: flex;
flex-wrap: wrap;
gap: 20px;
justify-content: center;
padding: 40px 20px;
}
   
.job-card {
/* background: #fff; */
background: white;
border-radius: 10px;
box-shadow: 0 4px 10px rgba(0,0,0,0.1);
padding: 20px;
width: 280px;
border-left: 5px solid #007BFF;
position: relative;
z-index: 2;
transition: all 0.3s ease;
overflow: hidden; 
min-height: 180px;
}

/* Show only on hover */
.job-card:hover .hover-message {
  opacity: 1;
}

.job-card:hover {
  transform: translateY(-3px);
  box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
}


.card-hover-tip {
  position: absolute;
  bottom: 10px;
  right: 10px;
  max-width: 240px;
  background: #1f2937;
  color: #d1fae5;
  font-size: 14px;
  font-style: italic;
  border-radius: 10px;
  padding: 10px 14px 12px;
  box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
  z-index: 3;
  opacity: 0;
  transform: scale(0.9) translateY(20px);
  transition: all 0.4s ease;
  pointer-events: none;
}

/* Show when card is hovered */
.job-card:hover .card-hover-tip {
  opacity: 1;
  transform: scale(1) translateY(0);
  pointer-events: auto;
}

/* Arrow bubble tail */
.card-hover-tip::after {
  content: "";
  position: absolute;
  bottom: -10px;
  right: 18px;
  border-width: 8px 8px 0 8px;
  border-style: solid;
  border-color: #1f2937 transparent transparent transparent;
}

/* Close button (top-right inside bubble) */
.card-hover-tip .close-tip {
  position: absolute;
  top: 6px;
  right: 8px;
  color: #ccc;
  font-size: 14px;
  cursor: pointer;
  font-weight: bold;
  z-index: 5;
}

.card-hover-tip .close-tip:hover {
  color: white;
}


/*.card-hover-tip .close-tip:hover {
  color: #555;
}*/

/* ✨ Show on hover */
.job-card:hover .card-hover-tip {
  opacity: 1;
  transform: translateY(-4px);
}

/*.job-card:hover .card-hover-tip {
  opacity: 1;
  max-height: 200px;
}*/

.job-card:not(:hover) .card-hover-tip {
  opacity: 0;
  pointer-events: none;
  transition: opacity 0.6s ease;
}

.job-description {
opacity: 0;
max-height: 0;
overflow: hidden;
transition: all 0.3s ease;
font-size: 13px;
color: #444;
margin-top: 10px;
}

.job-card:hover .job-description {
opacity: 1;
max-height: 150px;
}

/* ✅ Light mode gradient style */
/* Gradient from Coral to Blue */
/*.job-card h3 {
  background: linear-gradient(90deg, #ff7f50, #1e90ff); 
  -webkit-background-clip: text;
  color: transparent;
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
}*/

/* 🌙 Dark mode gradient style (with a slight brightness boost) */
body.dark-mode .job-card h3 {
  background: linear-gradient(90deg, #ff7f50, #1e90ff); /* Same gradient */
  -webkit-background-clip: text;
  color: transparent;
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
  opacity: 1; /* Fix opacity issue in dark mode */
}


.job-card p {
margin: 4px 0;
font-size: 14px;
}


.dropdown-btn {
  background: transparent;
  border: none;
  color: white;
  font-size: 14px;
  cursor: pointer;
}

.dropdown-content {
  display: none;
  position: absolute;
  right: 0;
  background-color: white;
  color: #333;
  min-width: 180px;
  border-radius: 6px;
  box-shadow: 0 8px 16px rgba(0,0,0,0.15);
  z-index: 9999;
}

.dropdown-content a {
  color: #004080;
  padding: 12px 16px;
  text-decoration: none;
  display: block;
}

.dropdown-content a:hover {
  background-color: #f1f1f1;
}

.show {
  display: block;
}




.filter-btn {
  background-color: #f8f9fa;
  color: #333;
  border: 1px solid #ccc;
  padding: 8px 16px;
  border-radius: 20px;
  font-size: 14px;
  cursor: pointer;
  transition: background-color 0.3s ease, transform 0.2s ease;
  display: inline-block;
  font-weight: 500;
  min-width: 120px;
  text-align: center;
}

.filter-btn:hover {
  background-color: #e2e6ea;
  transform: translateY(-2px);
}

 
.filter-btn.red { background-color: #dc3545; color: white; }
.filter-btn.red:hover { background-color: #c82333; }

.filter-btn.blue { background-color: #007BFF; color: white; }
.filter-btn.blue:hover { background-color: #0056b3; }

.filter-btn.green { background-color: #28a745; color: white; }
.filter-btn.green:hover { background-color: #1e7e34; }

.filter-btn.purple { background-color: #6f42c1; color: white; }
.filter-btn.purple:hover { background-color: #563d7c; }

  .btn-blue {
    background-color: #007BFF;
    color: white;
    border-color: #007BFF;
  }

  .btn-green {
    background-color: #28a745;
    color: white;
    border-color: #28a745;
  }

  .btn-purple {
    background-color: #6f42c1;
    color: white;
    border-color: #6f42c1;
  }

  .btn-blue:hover {
    background-color: #0056b3;
  }

  .btn-green:hover {
    background-color: #1e7e34;
  }

  .btn-purple:hover {
    background-color: #563d7c;
  }

.toggle-chart-btn {
background-color: #dc3545;
color: white;
border: none;
padding: 6px 12px;
font-size: 14px;
border-radius: 4px;
cursor: pointer;
margin-right: 10px;
}
   
.toggle-chart-btn:hover {
background-color: #c82333;
}

.toggle-desc {
  display: inline-block;
  margin-left: 8px;
  color: #007BFF;
  cursor: pointer;
  font-size: 13px;
}
.toggle-desc:hover {
  text-decoration: underline;
}

.hover-message {
  position: absolute;
  bottom: 14px;
  right: 14px;
  z-index: 3;
  padding: 6px 10px;
  font-size: 13px;
  font-weight: 500;
  background: rgba(255,255,255,0.95);
  color: #1e293b;
  border-radius: 6px;
  box-shadow: 0 1px 5px rgba(0,0,0,0.1);
  opacity: 0;
  pointer-events: none;
  max-width: 80%;
  transition: all 0.3s ease;
  white-space: normal;
  text-align: left;
  line-height: 1.3;
}


}
#toggleSearchBtn {
  background: #0288d1;
  color: white;
  border: none;
  padding: 10px 15px;
  border-radius: 10px 0 0 10px;
  font-size: 16px;
  cursor: pointer;
}
.search-panel {
  background: white;
  padding: 10px;
  border-radius: 10px 0 0 10px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.2);
}

.search-panel input {
  width: 200px;
  padding: 6px;
  font-size: 14px;
  border: 1px solid #ccc;
  border-radius: 4px;
}

#clearSearch {
  background: transparent;
  border: none;
  font-size: 18px;
  color: #d33;
  margin-left: 5px;
  cursor: pointer;
}

mark {
  background: yellow;
  padding: 0 2px;
}

.theme-toggle-btn {
  background: #4b5563;
  color: white;
  border: none;
  padding: 10px 15px;
  margin-top: 8px;
  font-size: 14px;
  border-radius: 10px 0 0 10px;
  cursor: pointer;
}


#themeToggleBtn,
#toggleSearchBtn {
  background: #0288d1;
  color: white;
  border: none;
  padding: 10px 15px;
  border-radius: 10px 0 0 10px;
  font-size: 14px;
  cursor: pointer;
  min-width: 120px;
}

.search-panel {
  background: white;
  padding: 10px;
  border-radius: 10px 0 0 10px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.2);
  display: none;
}



/* 🌙 Dark Mode Setup */
body.dark-mode {
  background-color: #121212;
  color: #f3f3f3;
}

body.dark-mode .job-card {
  background-color: #1e1e1e;
  color: #eaeaea;
}

body.dark-mode .job-card h3 {
  color: #90cdf4;
}

body.dark-mode .card-hover-tip {
  background-color: #1a1a1a;
  color: #7dd3fc;
  border-left: 4px solid #38bdf8;
}

.floating-tools {
  position: fixed;
  top: 40%;
  right: 0;
  display: flex;
  flex-direction: column;
  gap: 12px;
  z-index: 9999;
  align-items: flex-end;
}

/* Generic floating button look */
.floating-btn {
  background: #0288d1;
  color: white;
  border: none;
  padding: 10px 16px;
  border-radius: 12px 0 0 12px;
  font-size: 15px;
  cursor: pointer;
  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
  transition: background-color 0.3s ease;
}

.floating-btn:hover {
  background-color: #0071b3;
}

/* Search panel appearance */
.floating-search {
  display: flex;
  flex-direction: column;
  align-items: flex-end;
}

.floating-search .search-panel {
  background: white;
  padding: 10px;
  margin-top: 6px;
  border-radius: 10px 0 0 10px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.2);
  display: none;
}

.floating-search .search-panel input {
  width: 200px;
  padding: 6px;
  font-size: 14px;
  border: 1px solid #ccc;
  border-radius: 4px;
}

.floating-search .search-panel button {
  background: transparent;
  border: none;
  font-size: 18px;
  color: #d33;
  margin-left: 5px;
  cursor: pointer;
}

.floating-search:not(.collapsed) .search-panel {
  display: block;
}

body.dark-mode {
  background-color: #121212 !important;
  color: #f3f3f3 !important;
}

body.dark-mode .panel,
body.dark-mode .navbar,
body.dark-mode .panel-heading,
body.dark-mode .panel-body,
body.dark-mode .panel-footer,
body.dark-mode .r-topbar-page,
body.dark-mode .r-form,
body.dark-mode .searchOptions {
  background-color: #1f1f1f !important;
  color: #eee !important;
  border-color: #444 !important;
}

body.dark-mode .btn,
body.dark-mode .dropdown-menu,
body.dark-mode .job-card {
  background-color: #2a2a2a !important;
  color: #f5f5f5 !important;
  border-color: #444 !important;
}

body.dark-mode .dropdown-menu a:hover {
  background-color: #333 !important;
}

body.dark-mode a {
  color: #90cdf4 !important;
}

body.dark-mode .btn-primary {
  background-color: #007bff !important;
  border-color: #007bff !important;
}

body.dark-mode .btn-primary:hover {
  background-color: #0056b3 !important;
}

/* 🌙 Fix input visibility in dark mode */
body.dark-mode .floating-search .search-panel input {
  background-color: #2c2c2c;
  color: #f1f1f1;
  border: 1px solid #444;
}

body.dark-mode .floating-search .search-panel input::placeholder {
  color: #999;
}


/* 🔲 Floating Tray Style */
/*esults-tray {
  position: fixed;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  display: flex;
  flex-wrap: wrap;
  gap: 16px;
  padding: 20px;
  max-width: 80vw;
  max-height: 80vh;
  background: rgba(255, 255, 255, 0.95);
  border-radius: 16px;
  box-shadow: 0 4px 20px rgba(0, 0, 0, 0.25);
  overflow: auto;
  z-index: 9999;
  display: none;
}

.results-tray .job-card {
  transform: scale(0.98);
  transition: transform 0.4s ease, opacity 0.4s ease;
  opacity: 1;
}

.fade-out {
  opacity: 0;
  transform: scale(0.9);
  pointer-events: none;
}*/

/* 🌐 Results Tray */
.results-tray {
  position: fixed;
  bottom: 80px;
  left: 50%;
  transform: translateX(-50%);
  z-index: 9999;
  background: rgba(255, 255, 255, 0.95);
  border: 2px dashed #38bdf8;
  border-radius: 14px;
  box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
  padding: 18px 20px;
  max-width: 95vw;
  display: none;
  flex-wrap: wrap;
  gap: 12px;
  justify-content: center;
  transition: all 0.5s ease-in-out;
}

.results-tray .job-card {
  transform: scale(0.95);
  transition: transform 0.3s, box-shadow 0.3s;
  animation: slideUpIn 0.5s ease;
}

@keyframes slideUpIn {
  from {
    transform: translateY(60px);
    opacity: 0;
  }
  to {
    transform: translateY(0);
    opacity: 1;
  }
}

/* Expanded card style for full-body view */
.expanded-card {
  width: 100% !important;
  max-width: none;
  flex-direction: column;
  padding: 20px;
  background: white;
  box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

/* 🧊 Results Tray Style */
.results-tray {
  position: relative;
  display: flex;
  flex-wrap: wrap;
  gap: 14px;
  margin-top: 30px;
  padding: 20px 10px;
  background: transparent;
  border-top: 2px dashed #38bdf8;
  justify-content: center;
}

.expanded-card {
  width: 100%;
  max-width: none;
  padding: 18px;
  background: #fff;
  box-shadow: 0 3px 10px rgba(0,0,0,0.1);
}

.dark-mode .expanded-card {
  background: #1e293b;
  color: white;
}

mark {
  background: yellow;
  padding: 2px 4px;
  border-radius: 3px;
}

#stickyHeader {
  position: sticky;
  top: 0;
  z-index: 9999;
  background: #4a148c; /* fallback background */
  box-shadow: 0 2px 5px rgba(0,0,0,0.1);
}

/* Ensure both sub-layers keep their background */
#stickyHeader .r-topbar-page,
#stickyHeader .r-top {
  background: #4a148c;
  z-index: 9999;
}

  /* 🧷 Sticky PHPRunner navbar override */
  nav.navbar.navbar-default[data-location="supertop"] {
    position: sticky;
    top: 0;
    z-index: 10000;
    background: #3b5998 !important; /* match your theme */
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
  }

  /* Prevent layout shift */
/*body {
    padding-top: 70px; /* adjust if needed depending on nav height */
  }*/

/* Change bright white to a soft grayish tone */
body {
  background-color: #f3f4f6 !important;  /* tailwind's gray-100 */
  color: #111827; /* dark slate for contrast */
}



/* 🎨 Custom Login Button (Guest view) */
.navbar-form[data-itemid="loginform_login"] a.btn {
  background: #ff6b00 !important;     /* Orange gradient-style */
  color: #fff !important;
  font-weight: bold;
  border: none !important;
  border-radius: 8px;
  padding: 6px 16px;
  font-size: 1em;
  box-shadow: 0 2px 4px rgba(0,0,0,0.2);
  transition: background 0.3s ease;
}

.navbar-form[data-itemid="loginform_login"] a.btn:hover {
  background: #e55b00 !important;
}

/* 👤 Logged-in User Button */
.navbar-form[data-itemid="username_button"] .btn.dropdown-toggle {
  background: #ffffff !important;
  color: #333 !important;
  font-weight: 600;
  border: 1px solid #ccc !important;
  border-radius: 8px;
  padding: 6px 16px;
  font-size: 1em;
  box-shadow: 0 1px 3px rgba(0,0,0,0.1);
}

/* Optional hover effect */
.navbar-form[data-itemid="username_button"] .btn.dropdown-toggle:hover {
  background-color: #f2f2f2 !important;
}

.navbar-custom {
        display: flex;
        align-items: center;
        justify-content: space-between;
        background-color: #3b5998;
        padding: 10px 20px;
        flex-wrap: wrap;
      }
      .navbar-logo {
        flex: 0 0 auto;
      }
      .navbar-center-search {
        flex: 1 1 auto;
        display: flex;
        justify-content: center;
      }
      .navbar-center-search form {
        width: 90%;
        max-width: 400px;
        display: flex;
        gap: 10px;
        align-items: center;
      }
      .navbar-center-search input {
        flex: 1;
        padding: 12px 20px;
        border-radius: 32px;
        border: none;
        font-size: 16px;
        background-color: #fff;
        box-shadow: inset 0 2px 6px rgba(0,0,0,0.1);
      }
      .navbar-center-search button {
        background: #0d99ff;
        color: white;
        font-weight: bold;
        padding: 12px 24px;
        border-radius: 32px;
        border: none;
        font-size: 16px;
        cursor: pointer;
        box-shadow: 0 2px 6px rgba(0,0,0,0.2);
      }
      .navbar-right-tools {
        flex: 0 0 auto;
        display: flex;
        align-items: center;
        gap: 10px;
      }
      .navbar-right-tools .btn {
        border-radius: 20px;
        padding: 8px 16px;
        font-size: 14px;
      }
      .navbar-center-search input::placeholder {
        color: #888;
        font-style: italic;
      }
      
.navbar-default {
  background: linear-gradient(to right, #0d47a1, #1976d2); /* Modern blue tone */
  border: none;
  box-shadow: 0 2px 8px rgba(0,0,0,0.15);
}



/* end style */

</style>

</head>
<body class="{$stylename} function-list">
{BEGIN body}
{$header}

<nav class="navbar navbar-default" style="padding: 12px 20px; min-height: 80px; display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap;">

  <!-- Logo (Left) -->
  <div style="flex: 0 0 auto; display: flex; align-items: center;">
    <a href="jobsjobs_list.php" class="navbar-brand" style="display: flex; align-items: center; gap: 10px; text-decoration: none;">
      <img src="logo.png" alt="Jobseeker Logo" style="height: 64px; cursor: pointer;" />
      <span style="
        font-size: 1.8em;
        font-weight: bold;
        color: white;
        font-family: 'Segoe UI', sans-serif;
        text-shadow: 0 1px 3px rgba(0,0,0,0.4);
        line-height: 1;
      ">
        Jobseeker
      </span>
    </a>
  </div>

  <!-- Search Bar (Center) -->
  <div style="flex: 1 1 600px; text-align: center; padding: 8px;">
    <form id="topSearchForm" style="display: flex; gap: 10px; max-width: 30%; margin: 0 auto; align-items: center;">
      <div style="position: relative; width: 100%;">
  <input type="text" id="topSearchInput" placeholder="🔍 Search job title, company, or industry..."
    style="width: 100%; padding: 10px 40px 10px 18px; border-radius: 24px; border: none; font-size: 1em;
           background-color: #fff; color: #333; box-shadow: inset 0 1px 4px rgba(0,0,0,0.1); outline: none;">
           
  <!-- Flashy Reset Button -->
  <button id="resetSearch" type="button"
    style="position: absolute; right: 12px; top: 50%; transform: translateY(-50%);
           background: transparent; border: none; color: red; font-size: 0.9em; display: none; animation: flash 1s infinite;">
    ❌
  </button>
</div>
    </form>
  </div>

  <!-- Right Tools (PHPRunner Login/Logout) -->
  <div style="flex: 0 0 auto; display: flex; align-items: center; gap: 10px;">
    <button class="dashboard-toggle-btn top" onclick="toggleDashboardCards()" id="dashToggleBtnTop">Hide Dashboard</button>
	<button id="themeToggleBtn" class="btn btn-outline-light" style="border-radius: 20px;">🌓 Toggle Theme</button>
	
	<!-- PHPRunner Login Buttons -->
		<span class="navbar-form r-align-right navbar-collapse" data-cellId="supertop_c2" data-pageid="{$pageid}" data-itemid="loginform_login" {$item_loginform_login} data-topcell-item-type="loginform_login" >
		{BEGIN guestloginbutton}
		<span data-itemtype="loginform_login" data-itemid="loginform_login" {$item_loginform_login} data-pageid="{$pageid}" data-small data-button-item>
		<a type="button" title="" class="btn btn-primary " href="#" {$guestloginlink_attrs} > Login</a>
		</span>
		{END guestloginbutton}
		</span>
		 
		<span class="navbar-form r-align-right navbar-collapse" data-cellId="supertop_c2" data-pageid="{$pageid}" data-itemid="username_button" {$item_username_button} data-topcell-item-type="username_button" >
		{BEGIN loggedas_message}
		<span data-itemtype="username_button" data-itemid="username_button" {$item_username_button} data-pageid="{$pageid}" data-small data-button-item>
		<span class="dropdown ">
		<button type="button" title="" class="btn btn-default   dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">		
		{BEGIN userbutton_icon}
		<span class="glyphicon glyphicon-user"></span>
		{END userbutton_icon}{$userbutton_image}{$username} <span class="caret"></span>
		</button>
		<ul class="dropdown-menu">
		{BEGIN userinfo_link}
		<li data-itemtype="userinfo_link" data-itemid="userinfo_link" {$item_userinfo_link} data-pageid="{$pageid}" data-small >
		<a  href="userinfo.php"  title="" >
		User Profile		
		</a>
		</li>
		{END userinfo_link}
		{BEGIN logoutbutton}
		<li data-itemtype="logout_link" data-itemid="logout_link" {$item_logout_link} data-pageid="{$pageid}" data-small >
		<a  href="#" {$logoutlink_attrs}  title="" >
		Log out		
		</a>
		</li>
		{END logoutbutton}
		{BEGIN changepwd_link}
		<li data-itemtype="changepassword_link" data-itemid="changepassword_link" {$item_changepassword_link} data-pageid="{$pageid}" data-small >
		<a  href="changepwd.php" {$changepwdlink_attrs} id="changePasswordButton{$id}"  title="" >
		Change password		
		</a>
		</li>
		{END changepwd_link}
		</ul>
		</span>
		</span>
		{END loggedas_message}
		</span>
		</nav>
		
			
<!-- ananei-->



<!-- ✅ DASHBOARD AREA -->
<br>
<div class="dashboard-filters" id="dashboardFilters"style="text-align:center;">
  <button id="filterAll" class="filter-btn blue">Active Jobs</button>
<!--  <button id="filterMonth" class="filter-btn green">🗓 This Month</button> -->
<!--  <button id="filter12mo" class="filter-btn purple">📅 Last 12 Months</button> -->
<!--  <button id="downloadBtn">⬇️ Download</button> -->
</div>
<!-- Load Chart.js and the Data Labels plugin -->
<div class="chart-container-user-posted dashboard-chart-wrapper" id="dashboardCharts">
  <h3 style="text-align:center;">
<!--    All Active Jobs – {$filter_label} -->
    <span style="font-size: 16px; color: #666;">(Total: {$chart_total})</span>
  </h3>
<!--  <canvas id="productChart" width="900" height="220"></canvas> -->
<div style="max-width: 1000px; margin: 0 auto; padding: 10px;">
  <canvas id="productChart" style="width: 100%; height: 400px;"></canvas>
</div>
</div>

<div class="dashboard" id="dashboard">
<!-- GOVT -->
  <!-- Flip Card Template -->
  <div class="flip-card draggable" id="card_govt">
    <div class="flip-card-inner" id="govt_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟩</span>
            <strong>Government Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_govt', 'govt_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="govtChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="govt_active_pct"></span> {$govt_active}</div>
          <div><span class="dot expired"></span> <span id="govt_expired_pct"></span> {$govt_expired7}</div>
          <div><span class="dot archived"></span> <span id="govt_archived_pct"></span> {$govt_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟩</span>
            <strong>Government Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_govt', 'govt_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
        These jobs are posted by government ministries or agencies. Most roles have fixed expiry dates and are managed via official HR systems.
        </div>

        </div>
      </div>
    </div>

  <!-- sprep -->
  <div class="flip-card draggable" id="card_sprep">
    <div class="flip-card-inner" id="sprep_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟧</span>
            <strong>SPREP Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_sprep', 'sprep_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="sprepChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="sprep_active_pct"></span> {$sprep_active}</div>
          <div><span class="dot expired"></span> <span id="sprep_expired_pct"></span> {$sprep_expired7}</div>
          <div><span class="dot archived"></span> <span id="sprep_archived_pct"></span> {$sprep_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟧</span>
            <strong>SPREP Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_sprep', 'sprep_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Jobs posted by the Secretariat of the Pacific Regional Environment Programme. Often focused on climate, conservation, and sustainability.
</div>

      </div>
    </div>
  </div>
 
    <!-- spc -->
  <div class="flip-card draggable" id="card_spc">
    <div class="flip-card-inner" id="spc_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟪</span>
            <strong>SPC Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_spc', 'spc_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="spcChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="spc_active_pct"></span> {$spc_active}</div>
          <div><span class="dot expired"></span> <span id="spc_expired_pct"></span> {$spc_expired7}</div>
          <div><span class="dot archived"></span> <span id="spc_archived_pct"></span> {$spc_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟪</span>
            <strong>SPC Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_spc', 'spc_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Positions offered by the Pacific Community (SPC), covering health, education, agriculture, and regional development sectors.
</div>

      </div>
    </div>
  </div>
 
    <!-- undp -->
  <div class="flip-card draggable" id="card_undp">
    <div class="flip-card-inner" id="undp_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟥</span>
            <strong>UNDP Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_undp', 'undp_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="undpChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="undp_active_pct"></span> {$undp_active}</div>
          <div><span class="dot expired"></span> <span id="undp_expired_pct"></span> {$undp_expired7}</div>
          <div><span class="dot archived"></span> <span id="undp_archived_pct"></span> {$undp_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟥</span>
            <strong>UNDP Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_undp', 'undp_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Vacancies from the United Nations Development Programme. These often involve policy, climate resilience, or technical advisory roles.
</div>

      </div>
    </div>
  </div>
 
    <!-- pifs -->
  <div class="flip-card draggable" id="card_pifs">
    <div class="flip-card-inner" id="pifs_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟨</span>
            <strong>PIFS Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_pifs', 'pifs_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="pifsChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="pifs_active_pct"></span> {$pifs_active}</div>
          <div><span class="dot expired"></span> <span id="pifs_expired_pct"></span> {$pifs_expired7}</div>
          <div><span class="dot archived"></span> <span id="pifs_archived_pct"></span> {$pifs_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟨</span>
            <strong>PIFS Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_pifs', 'pifs_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Jobs listed by the Pacific Islands Forum Secretariat. Focused on regional cooperation, diplomacy, and policy development.
</div>

      </div>
    </div>
  </div>
 
   <!-- ffa -->
  <div class="flip-card draggable" id="card_ffa">
    <div class="flip-card-inner" id="ffa_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🪟</span>
            <strong>FFA Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_ffa', 'ffa_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="ffaChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="ffa_active_pct"></span> {$ffa_active}</div>
          <div><span class="dot expired"></span> <span id="ffa_expired_pct"></span> {$ffa_expired7}</div>
          <div><span class="dot archived"></span> <span id="ffa_archived_pct"></span> {$ffa_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🪟</span>
            <strong>FFA Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_ffa', 'ffa_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Roles from the Pacific Islands Forum Fisheries Agency, often technical and regional in nature, especially fisheries compliance and policy.
</div>

      </div>
    </div>
  </div>
 
    <!-- pjn -->
  <div class="flip-card draggable" id="card_pjn">
    <div class="flip-card-inner" id="pjn_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">📂</span>
            <strong>Pacific Vacancies Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_pjn', 'pjn_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="pjnChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="pjn_active_pct"></span> {$pjn_active}</div>
          <div><span class="dot expired"></span> <span id="pjn_expired_pct"></span> {$pjn_expired7}</div>
          <div><span class="dot archived"></span> <span id="pjn_archived_pct"></span> {$pjn_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">📂</span>
            <strong>Pacific Vacancies Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_pjn', 'pjn_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Curated job opportunities from multiple Pacific organizations and private sectors, collected to support regional talent access.
</div>

      </div>
    </div>
  </div>
 
 <!-- himalayas -->
<div class="flip-card draggable" id="card_himalayas">
  <div class="flip-card-inner" id="himalayas_inner">
    <!-- FRONT: Chart Summary -->
    <div class="flip-card-front">
      <div class="card-header">
        <div style="display:flex;align-items:center;gap:6px;">
          <span class="job-source-icon">🌐</span>
          <strong>Himalayas Jobs</strong>
        </div>
        <div class="pin-control">
          <button class="pin-btn" onclick="togglePin(this, 'card_himalayas', 'himalayas_inner')"></button>
          <small class="pin-label"></small>
          <span class="drag-icon" title="Drag"></span>
        </div>
      </div>
      <div class="chart-center">
        <canvas id="himalayasChart"></canvas>
      </div>
      <div class="chart-legend-stats">
        <div><span class="dot active"></span> <span id="himalayas_active_pct"></span> {$himalayas_active}</div>
        <div><span class="dot expired"></span> <span id="himalayas_expired_pct"></span> {$himalayas_expired7}</div>
        <div><span class="dot archived"></span> <span id="himalayas_archived_pct"></span> {$himalayas_archived}</div>
      </div>
    </div>
    <!-- BACK: Info Text -->
    <div class="flip-card-back">
      <div class="card-header">
        <div style="display:flex;align-items:center;gap:6px;">
          <span class="job-source-icon">🌐</span>
          <strong>Himalayas Jobs</strong>
        </div>
        <div class="pin-control">
          <button class="pin-btn" onclick="togglePin(this, 'card_himalayas', 'himalayas_inner')">📌</button>
          <small class="pin-label">Pin to stop flip</small>
          <span class="drag-icon" title="Drag">⤧</span>
        </div>
      </div>
      <div class="card-description">
Discover remote jobs around the world from the <strong>Himalayas platform</strong>. Opportunities range from startups to global tech firms, including roles in design, software development, support, marketing, and product management.
      </div>
    </div>
  </div>
</div>

 
 
    <!-- user -->
  <!-- Flip Card Template -->
  <div class="flip-card draggable" id="card_user">
    <div class="flip-card-inner" id="user_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟦</span>
            <strong>User-Posted Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_user', 'user_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="userChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="user_active_pct"></span> {$user_active}</div>
          <div><span class="dot expired"></span> <span id="user_expired_pct"></span> {$user_expired7}</div>
          <div><span class="dot archived"></span> <span id="user_archived_pct"></span> {$user_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Description -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟦</span>
            <strong>User-Posted Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_user', 'user_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Jobs manually submitted by employers or recruiters on this platform. These listings follow platform expiry, extension, and archive rules.
</div>

      </div>
    </div>
  </div>
</div>








<!-- 📢 Job Feed Disclaimer & Guest Prompt -->
<div id="disclaimerPopup" class="disclaimer-popup-centered">
  <div class="popup-content">
    <h4 style="margin-bottom: 4px;">📢 Job Sources & Feed <i class="fas fa-info-circle"></i> Disclaimer</h4>
    <small style="font-size: 12px; color: #666;">Transparency notice for all listed opportunities</small>

    <p>This live feed highlights job opportunities from the career pages of regional organizations like SPREP, SPC, PIFS, FFA, and UNDP, government listings from the Samoa Public Service Commission (PSC), and postings from government-owned corporations. It also includes remote global live-feed API job listings from platforms like the Himalayas.</p>

    <p>These listings help jobseekers discover local, regional, and international employment opportunities. Please note that all application procedures, rights, and recruitment decisions are the sole responsibility of the respective hiring organizations or agencies.</p>

    <hr style="margin: 10px 0;">

    <p style="font-weight: bold; font-size: 14px;">👋 Welcome, Guest!</p>
    <p 🧑‍💼 style="font-size: 13px;">To apply for jobs posted by <strong>Private Sector Employers</strong> or receive alerts for <strong>Public Sector</strong> opportunities listed on this platform, please register below:</p>

    <div class="guest-popup-buttons" style="display: flex; gap: 10px; margin-bottom: 12px;">
      <button onclick="openModal('register.php?page=register_jobseeker')" class="btn btn-sm btn-primary">Jobseeker Register</button>
      <button onclick="openModal('register.php?page=register_employer')" class="btn btn-sm btn-success">Employer Register</button>
    </div>
   
    <div style="margin-top: 10px; display: flex; align-items: center; gap: 8px;">
    <input type="checkbox" id="dontShowAgain" style="transform: scale(1.2);" />
    <label for="dontShowAgain" style="font-size: 13px;">Don’t show this again for 7 days</label>
    </div>
   
    <button class="btn btn-sm btn-secondary" onclick="toggleDisclaimerPopup()">Close</button>
  </div>
</div>





<!-- 🌐 Collapsible Floating Panel -->
<div id="floatingPanel" class="floating-panel collapsed">
  <button class="panel-toggle" onclick="togglePanel()">☰</button>

 <div class="panel-buttons">
    <button onclick="toggleDisclaimerPopup()">Disclaimer ℹ️</button>
    </div>
</div>

<div class="custom-jobs-grid">{$job_cards}</div>
<div class="custom-external-jobs-wrapper">{$external_jobs}</div>

<!--end-ananei -->
	
<div class="r-below">
					{BEGIN below-grid_block}
<div class="r-form" data-location="below-grid" id="form_below-grid_{$pageid}" data-makeup="topbar" {$form_below-grid} data-pageid="{$pageid}" >		
	 
				<div class="row">
			 
				<div 
	data-cellId="below-grid_c" data-pageid="{$pageid}"	{$cell_below-grid_c}
	class="r-align-center r-ori-vert			col-md-12
	
">
		 
		{BEGIN pagination_block}
<span data-itemtype="pagination" data-itemid="pagination" {$item_pagination} data-pageid="{$pageid}" >
{$pagination}
</span>
{END pagination_block}
		</div>					</div>
			</div>		
{END below-grid_block}
	</div>

					</div>
				</div>
			</div>
		</div>
		

<!-- script start -->

<script>
// 🔍 On scroll, resize the logo for a sleek effect
window.addEventListener("scroll", function () {
  const logo = document.querySelector(".logo");     // Logo image element
  const header = document.querySelector("header");  // Main page header

  // 🎯 If user scrolls down more than 80px, shrink the logo
  if (window.scrollY > 80) {
    logo.style.transform = "scale(0.8)";
  } else {
    logo.style.transform = "scale(1)";
  }
});
</script>

<script>
function scrollToTop() {
  window.scrollTo({
    top: 0,
    behavior: 'smooth'
  });
  const header = document.querySelector("header");
  // 👇 Add a glow or bounce effect when header becomes visible
  header.classList.add("highlight-top");
  // Remove the class after animation ends (1 second)
  setTimeout(() => {
    header.classList.remove("highlight-top");
  }, 900);
}
</script>



<script>
// 🎯 Toggle popup and store dismiss state
function toggleDisclaimerPopup() {
  const popup = document.getElementById("disclaimerPopup");
  const trigger = document.getElementById("disclaimerTrigger");
  const dontShow = document.getElementById("dontShowAgain");
  const toast = document.getElementById("toastDisclaimer");

  const isHidden = popup.style.display === "none" || !popup.style.display;
  popup.style.display = isHidden ? "block" : "none";
  trigger.style.display = isHidden ? "none" : "block";

  if (!isHidden) {
    const dismissUntil = dontShow?.checked
      ? Date.now() + 7 * 24 * 60 * 60 * 1000 // 7 days
      : Date.now() + 1 * 60 * 60 * 1000;     // 1 hour

    localStorage.setItem("jobDisclaimerDismissedUntil", dismissUntil);

    // ✅ Show toast if checkbox was ticked
    if (dontShow?.checked && toast) {
      toast.style.display = "block";
      setTimeout(() => {
        toast.style.display = "none";
      }, 4000); // hide after 4 seconds
    }
  }
}

document.addEventListener("DOMContentLoaded", function () {
  const jobCards = document.getElementById("jobsContainer");
  const externalJobs = document.querySelector(".external-jobs-wrapper");
  const popup = document.getElementById("disclaimerPopup");
  const trigger = document.getElementById("disclaimerTrigger");

  const hasJobs = jobCards && jobCards.innerHTML.trim() !== "";
  const hasExternal = externalJobs && externalJobs.innerHTML.trim() !== "";

  const storedTime = localStorage.getItem("jobDisclaimerDismissedUntil");
  const now = Date.now();

  const isDismissed = storedTime && parseInt(storedTime) > now;

  if (!hasJobs && !hasExternal) {
    popup.style.display = "none";
    trigger.style.display = "none";
  } else {
    popup.style.display = isDismissed ? "none" : "block";
    trigger.style.display = isDismissed ? "block" : "none";
  }
});
</script>


<script>
// 🔁 Toggle between showing preview and full description in job cards
function toggleDescription(link) {
  // 🔍 Find the preview and full description elements
  const preview = link.previousElementSibling.previousElementSibling; // The short preview
  const full = link.previousElementSibling;                           // The full description

  // 🎭 Show or hide full/preview description
  if (full.style.display === "none") {
    preview.style.display = "none";      // Hide preview
    full.style.display = "inline";       // Show full text
    link.textContent = "Show less";      // Update link text
  } else {
    preview.style.display = "inline";    // Show preview again
    full.style.display = "none";         // Hide full description
    link.textContent = "Read more";      // Reset link text
  }
}
</script>

<script>
// ❌ Close the guest welcome popup
function closeGuestPopup() {
  const popup = document.getElementById("guestPopup");
  popup.style.display = "none";
}
</script>

<!-- Script No user-posted JObs -->
<script>
function dismissNoJobs() {
  const alert = document.getElementById('noJobsAlert');
  alert.style.opacity = '0';
  alert.style.transform = 'translateY(-20px)';
  setTimeout(() => alert.style.display = 'none', 400);
}
</script>

<script>
// 📊 Chart instance reference and default type
let chartInstance = null;
let currentType = 'bar';

// 📁 Chart data passed from PHP (PHPRunner variables)
const allData = {
  labels: {$chart_labels},              // X-axis labels
  values: {$chart_values},              // Y-axis values
  year: "<?php echo $selected_year ?>"  // Selected year
};

// 🔧 Main function to draw the chart
function drawChart(type = 'bar') {
  const ctx = document.getElementById('productChart').getContext('2d');

  // If a chart already exists, destroy it before redrawing
  if (chartInstance) chartInstance.destroy();

  // Create new chart
chartInstance = new Chart(ctx, {
    type: type,
    data: {
      labels: allData.labels,
      datasets: [{
        label: '',
        data: allData.values,
        backgroundColor: '#10b981', // solid green for all bars
        borderRadius: 6
      }]
    },
    options: {
      responsive: true,
      plugins: {
        // 🎯 Show labels directly on top of bars (if bar chart)
        datalabels: {
          display: type === 'bar',
          anchor: 'end',
          align: 'top',
          font: {
            weight: 'bold'
          }
        },
        legend: {
          display: type !== 'bar' // Only show legend for non-bar charts
        },
        title: {
          display: false // Title is hidden (you can enable it if you want)
        }
      },
      animation: {
        duration: 1000,
        easing: 'easeOutBounce'
      },
      scales: type === 'bar' ? {
        y: {
          beginAtZero: true
        }
      } : {} // No Y-axis if not bar
    },
    plugins: [ChartDataLabels]
  });
}


// 🔄 Toggle between bar and pie chart views
function toggleChartType() {
  currentType = currentType === 'bar' ? 'pie' : 'bar';
  drawChart(currentType);
}

// ⬇️ Export the chart as a PNG image
function downloadChart() {
  const link = document.createElement('a');
  link.download = 'product_chart.png';
  link.href = chartInstance.toBase64Image(); // Convert chart to image
  link.click();
}

// 📅 Apply year-based filter to reload the page with a query string
function filterByYear(year) {
  if (year === "all") {
    window.location.href = window.location.pathname;
  } else {
    const params = new URLSearchParams(window.location.search);
    params.set('year', year);
    window.location.search = params.toString();
  }
}

// 🧠 Draw chart after page is fully loaded
document.addEventListener("DOMContentLoaded", () => {
  drawChart();
});
</script>

<!-- 📊 SCRIPT: Initialize All Charts -->
<script>
document.addEventListener("DOMContentLoaded", function () {
  const charts = [
    { id: "govtChart", data: [{$govt_active_raw}, {$govt_expired7_raw}, {$govt_archived_raw}], prefix: 'govt' },
    { id: "sprepChart", data: [{$sprep_active_raw}, {$sprep_expired7_raw}, {$sprep_archived_raw}], prefix: 'sprep' },
    { id: "spcChart", data: [{$spc_active_raw}, {$spc_expired7_raw}, {$spc_archived_raw}], prefix: 'spc' },
    { id: "undpChart", data: [{$undp_active_raw}, {$undp_expired7_raw}, {$undp_archived_raw}], prefix: 'undp' },
    { id: "pifsChart", data: [{$pifs_active_raw}, {$pifs_expired7_raw}, {$pifs_archived_raw}], prefix: 'pifs' },
    { id: "ffaChart", data: [{$ffa_active_raw}, {$ffa_expired7_raw}, {$ffa_archived_raw}], prefix: 'ffa' },
    { id: "pjnChart", data: [{$pjn_active_raw}, {$pjn_expired7_raw}, {$pjn_archived_raw}], prefix: 'pjn' },
    { id: "userChart", data: [{$user_active_raw}, {$user_expired7_raw}, {$user_archived_raw}], prefix: 'user' },
	{ id: "himalayasChart", data: [{$himalayas_active_raw}, {$himalayas_expired7_raw}, {$himalayas_archived_raw}], prefix: 'himalayas' }
<!--    { id: "himalayasChart", data: [0, 0, 0] } -->
  ];

    charts.forEach(({ id, data, prefix }) => {
    const ctx = document.getElementById(id);
    if (!ctx) return;

    const total = data.reduce((a, b) => a + b, 0);
    const percentages = data.map(v => total > 0 ? ((v / total) * 100).toFixed(1) + '%' : '0%');

    if (prefix) {
      const activeEl = document.getElementById(`${prefix}_active_pct`);
      const expiredEl = document.getElementById(`${prefix}_expired_pct`);
      const archivedEl = document.getElementById(`${prefix}_archived_pct`);
      if (activeEl) activeEl.textContent = percentages[0];
      if (expiredEl) expiredEl.textContent = percentages[1];
      if (archivedEl) archivedEl.textContent = percentages[2];
    }

    new Chart(ctx, {
      type: 'doughnut',
      data: {
        labels: ["Active", "Expired", "Archived"],
        datasets: [{
          data: data,
          backgroundColor: ["#34a853", "#ea4335", "#9aa0a6"],
          borderWidth: 0
        }]
      },
      options: {
        plugins: {
          legend: { display: false },
          datalabels: {
            color: '#fff',
            font: { weight: 'bold', size: 12 },
            formatter: (value, ctx) => {
              const sum = ctx.chart.data.datasets[0].data.reduce((a, b) => a + b, 0);
              return sum ? Math.round((value / sum) * 100) + '%' : '';
            }
          }
        },
        cutout: "70%",
        responsive: true,
        maintainAspectRatio: false
      },
      plugins: [ChartDataLabels]
    });
  });
});
</script>

<!-- 📌 DRAG + PIN SCRIPT -->
<script>
function togglePin(button, cardId, innerId) {
  const card = document.getElementById(cardId);
  const inner = document.getElementById(innerId);
  const label = button.nextElementSibling;

  if (inner.classList.contains("pinned")) {
    inner.classList.remove("pinned");
    card.classList.remove("pinned");
    label.textContent = "Pin to stop flip";
    button.textContent = "";
  } else {
    inner.classList.add("pinned");
    card.classList.add("pinned");
    label.textContent = "Unpin to allow flip";
    button.textContent = "📌";
  }
}

function makeDraggable(selector) {
  const container = document.getElementById("dashboard");
  let dragged = null;

  document.querySelectorAll(selector).forEach(card => {
    card.setAttribute("draggable", true);

    card.addEventListener("dragstart", function (e) {
      dragged = this;
      e.dataTransfer.effectAllowed = "move";
      this.style.opacity = 0.5;
    });

    card.addEventListener("dragend", function () {
      this.style.opacity = 1;
    });

    card.addEventListener("dragover", function (e) {
      e.preventDefault();
      e.dataTransfer.dropEffect = "move";
    });

    card.addEventListener("drop", function (e) {
      e.preventDefault();
      if (dragged && dragged !== this) {
        const children = Array.from(container.children);
        const draggedIndex = children.indexOf(dragged);
        const targetIndex = children.indexOf(this);
        if (draggedIndex < targetIndex) {
          container.insertBefore(dragged, this.nextSibling);
        } else {
          container.insertBefore(dragged, this);
        }
      }
    });
  });
}

document.addEventListener("DOMContentLoaded", function () {
  makeDraggable(".draggable");
});
</script>

<script>
function togglePin(button, cardId, innerId) {
  const card = document.getElementById(cardId);
  const inner = document.getElementById(innerId);
  const label = button.nextElementSibling;

  if (inner.classList.contains("pinned")) {
    inner.classList.remove("pinned");
    card.classList.remove("pinned");
    label.textContent = "Pin to stop flip";
    button.textContent = "📌";
  } else {
    inner.classList.add("pinned");
    card.classList.add("pinned");
    label.textContent = "Unpin to allow flip";
    button.textContent = "📍";
  }
}
</script>

<script>
function toggleDashboardCards() {
  const dash = document.getElementById("dashboard");
  const filters = document.getElementById("dashboardFilters");
  const charts = document.getElementById("dashboardCharts");
  const btn = document.getElementById("dashToggleBtnTop");

  dash.classList.toggle("dashboard-hidden");
  filters.classList.toggle("dashboard-filters-hidden");
  charts.classList.toggle("dashboard-charts-hidden");
  charts.classList.toggle("dashboard-chart-wrapper-hidden");

  const isHidden = dash.classList.contains("dashboard-hidden");
  btn.textContent = isHidden ? "Show Dashboard" : "Hide Dashboard";
  localStorage.setItem("dashboardVisible", isHidden ? "hidden" : "visible");

  if (!isHidden) {
    window.scrollTo({ top: 0, behavior: 'smooth' });
  }
}

document.addEventListener("DOMContentLoaded", function () {
  const dash = document.getElementById("dashboard");
  const filters = document.getElementById("dashboardFilters");
  const charts = document.getElementById("dashboardCharts");
  const btn = document.getElementById("dashToggleBtnTop");

  const dashState = localStorage.getItem("dashboardVisible");
  const isInitiallyHidden = dashState === "hidden";

  if (isInitiallyHidden) {
    dash.classList.add("dashboard-hidden");
    filters.classList.add("dashboard-filters-hidden");
    charts.classList.add("dashboard-charts-hidden", "dashboard-chart-wrapper-hidden");
    btn.textContent = "Show Dashboard";
  }
});

function togglePin(button, cardId, innerId) {
  const card = document.getElementById(cardId);
  const inner = document.getElementById(innerId);
  const label = button.nextElementSibling;

  if (inner.classList.contains("pinned")) {
    inner.classList.remove("pinned");
    card.classList.remove("pinned");
    label.textContent = "Pin to stop flip";
    button.textContent = "📌";
  } else {
    inner.classList.add("pinned");
    card.classList.add("pinned");
    label.textContent = "Unpin to allow flip";
    button.textContent = "📍";
  }
}

function toggleUserPostedChart() {
  const chart = document.getElementById("dashboardCharts");
  const filtersToHide = [
    document.getElementById("filterAll"),
    document.getElementById("filterMonth"),
    document.getElementById("filter12mo"),
    document.getElementById("downloadBtn")
  ];
  const btn = document.getElementById("toggleChartBtn");

  const isHidden = chart.classList.toggle("dashboard-charts-hidden");
  chart.classList.toggle("dashboard-chart-wrapper-hidden");

  filtersToHide.forEach(el => {
    if (isHidden) {
      el.classList.add("dashboard-buttons-hidden");
    } else {
      el.classList.remove("dashboard-buttons-hidden");
    }
  });

  btn.textContent = isHidden ? "📊 Show Chart" : "📉 Hide Chart";
}
</script>


<script>
document.addEventListener("DOMContentLoaded", function () {
  const searchInput = document.getElementById("jobSearchInput");
  const floatingSearch = document.getElementById("floatingSearch");
  const resultsTray = document.getElementById("resultsTray");
  const sectionHeadings = document.querySelectorAll("h3[id^='section--']");
  const allCards = document.querySelectorAll(".job-card");

  let originalPositions = new Map();

  function escapeRegExp(string) {
    return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
  }

  function highlightText(container, regex) {
    const walker = document.createTreeWalker(container, NodeFilter.SHOW_TEXT, null, false);
    const nodesToHighlight = [];

    while (walker.nextNode()) {
      const currentNode = walker.currentNode;
      if (regex.test(currentNode.textContent)) {
        nodesToHighlight.push(currentNode);
      }
    }

    nodesToHighlight.forEach(node => {
      const parent = node.parentNode;
      const frag = document.createDocumentFragment();
      let lastIndex = 0;
      const text = node.textContent;

      text.replace(regex, (match, _, offset) => {
        const before = text.slice(lastIndex, offset);
        if (before) frag.appendChild(document.createTextNode(before));

        const mark = document.createElement('mark');
        mark.textContent = match;
        frag.appendChild(mark);

        lastIndex = offset + match.length;
      });

      const after = text.slice(lastIndex);
      if (after) frag.appendChild(document.createTextNode(after));

      parent.replaceChild(frag, node);
    });
  }

  function filterJobCards(query) {
    const cards = document.querySelectorAll(".job-card");
    const regex = new RegExp(`(${escapeRegExp(query)})`, "gi");

    cards.forEach(card => {
      const title = card.querySelector("h3")?.innerText || "";
	const company = card.querySelector("p:nth-of-type(1)")?.innerText || "";
	const type = card.querySelector("p:nth-of-type(2)")?.innerText || "";
	const location = card.querySelector("p:nth-of-type(3)")?.innerText || "";
	const desc = card.querySelector(".desc-preview, .desc-full")?.innerText || "";

	const combinedText = `${title} ${company} ${type} ${location} ${desc}`;
	  
      const match = combinedText.toLowerCase().includes(query.toLowerCase());

      card.style.display = match || query === "" ? "block" : "none";

      // Clear old highlights
      card.querySelectorAll("mark").forEach(mark => {
        const parent = mark.parentNode;
        parent.replaceChild(document.createTextNode(mark.textContent), mark);
        parent.normalize();
      });

      if (match && query !== "") {
        highlightText(card, regex);
      }
    });

    // 🧠 Toggle section headers
    document.querySelectorAll("h3[id^='section--']").forEach(sectionHeading => {
      const sourceSlug = sectionHeading.id.replace("section--", "");
      const cardsInSection = document.querySelectorAll(".card-" + sourceSlug);
      const anyVisible = Array.from(cardsInSection).some(card => card.style.display !== "none");
      sectionHeading.style.display = anyVisible ? "block" : "none";
    });
  }

  // 🌙 Theme toggle
  document.getElementById("themeToggleBtn")?.addEventListener("click", function () {
    document.body.classList.toggle("dark-mode");
  });

  // 🔍 Search toggle
  document.getElementById("toggleSearchBtn")?.addEventListener("click", function () {
    document.getElementById("floatingSearch")?.classList.toggle("collapsed");
  });

  // ✅ Reset button - clears search
  document.getElementById("resetSearch")?.addEventListener("click", function () {
    const searchInput = document.getElementById("jobSearchInput");
    if (searchInput) {
      searchInput.value = "";
      filterJobCards("");
    }
  });

  // ❌ Close button - hides panel only
  document.getElementById("closeSearchBox")?.addEventListener("click", function () {
    document.getElementById("floatingSearch")?.classList.add("collapsed");
  });

  // 🔎 Live filter
  document.getElementById("jobSearchInput")?.addEventListener("input", function () {
    const query = this.value.trim();
    filterJobCards(query);
  });

});
</script>


<script>
document.addEventListener("DOMContentLoaded", function () {
  // Attach same dark mode toggle to the floating button
  const floatingThemeBtn = document.querySelector(".floating-tools #themeToggleBtn");
  floatingThemeBtn?.addEventListener("click", function () {
    document.body.classList.toggle("dark-mode");
  });
});
</script>

<script>
document.getElementById("logo")?.addEventListener("click", () => {
  window.scrollTo({ top: 0, behavior: "smooth" });
});
</script>

<script>
  // 🧭 Scroll to top when logo is clicked
  document.addEventListener("DOMContentLoaded", function () {
    const logo = document.querySelector(".navbar-brand");
    if (logo) {
      logo.addEventListener("click", function (e) {
        e.preventDefault();
        window.scrollTo({ top: 0, behavior: "smooth" });
      });
    }
  });
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {
  // Force clean classes on login button
  const loginBtn = document.querySelector('[data-itemid="loginform_login"] a.btn');
  if (loginBtn) {
    loginBtn.className = 'btn custom-login-btn';
  }

  // Optional: customize dropdown button for logged-in users
  const userBtn = document.querySelector('[data-itemid="username_button"] .dropdown-toggle');
  if (userBtn) {
    userBtn.className = 'btn custom-user-btn dropdown-toggle';
  }
});
</script>



<script>
document.addEventListener("DOMContentLoaded", function () {
  const topInput = document.getElementById("topSearchInput");
  const floatingInput = document.getElementById("jobSearchInput");

  // 🔁 Top search reuses floating search logic
  document.getElementById("topSearchForm").addEventListener("submit", function (e) {
    e.preventDefault();

    const query = topInput.value.trim();

    // Sync value to the floating input
    floatingInput.value = query;

    // Trigger input event to use the same filtering
    const inputEvent = new Event("input", { bubbles: true });
    floatingInput.dispatchEvent(inputEvent);
  });

  // 🔄 Optional: sync both inputs in real-time
  topInput.addEventListener("input", function () {
    floatingInput.value = topInput.value;
    const inputEvent = new Event("input", { bubbles: true });
    floatingInput.dispatchEvent(inputEvent);
  });
});
</script>

<script>
  const searchInput = document.getElementById("topSearchInput");
  const resetBtn = document.getElementById("resetSearch");

  searchInput.addEventListener("input", () => {
    resetBtn.style.display = searchInput.value.length > 0 ? "inline" : "none";
  });

  resetBtn.addEventListener("click", () => {
    searchInput.value = "";
    resetBtn.style.display = "none";
    searchInput.focus();
  });
</script>


<div id="stickyHeader">
  <!-- Row 1: Logo + Navigation -->
  <div class="top-bar">
    <!-- Logo, menu, register links -->
  </div>

  <!-- Row 2: Filters or Tabs -->
  <div class="sub-bar">
    <!-- Dropdowns like 'Industrial Areas' -->
  </div>
</div>


<!-- 🌗 Floating Tools Wrapper -->
<div class="floating-tools">
  <!-- Theme toggle button -->
  <button id="themeToggleBtn" class="floating-btn">🌓 Theme</button>

  <!-- Search toggle and input -->
  <div id="floatingSearch" class="floating-search collapsed">
    <button id="toggleSearchBtn" title="Search Jobs">🔍 Search</button>
    <div class="search-panel">
      <input type="text" id="jobSearchInput" placeholder="Search job title, company, or description..." />
      <div style="display: flex; gap: 6px; margin-top: 6px;">
        <button id="resetSearch" title="Clear search and show all">Reset</button>
        <button id="closeSearchBox" title="Hide search panel">✖</button>
      </div>
    </div>
  </div>
</div>

<div id="chatWaver" style="
  position: fixed;
  bottom: 80px;
  right: 20px;
  z-index: 9999;
">
  <a href="https://m.me/MCILSamoa" target="_blank" id="chatBtn" style="
    display: flex;
    align-items: center;
    justify-content: center;
    background: #0084FF;
    color: #fff;
    padding: 10px 16px;
    border-radius: 8px;
    text-decoration: none;
    font-weight: 500;
    font-size: 14px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    transition: transform 0.3s ease;
  ">
    💬 Chat with our team
  </a>
</div>


		{$footer}
	{END body}
	</body>
</html>
