include_once("load_external_chart_data.php");
if($pageObject->pageName!=="list1")
$xt->assign("stylename","jobslist");
$_SESSION["active_category"] = "";
$_SESSION["active_category_name"] = "";
$find = array();
preg_match_all("/\(TypeID~equals~(.+)\)/U",postvalue("f"),$find,PREG_PATTERN_ORDER);
if(count($find[1]) > 0 && $find[1][0]){
$_SESSION["active_category"] = $find[1][0];
$_SESSION["active_category_name"] = DB::DBLookup("select sType from jobsjobtype where ID=".$find[1][0]);
$xt->assign( "breadcrumbs", true );
$xt->assign( "breadcrumb", true );

$breadcrumb[0] = array("crumb_attrs"=> 'href="'.GetTableLink("jobsjobs","list").'"' ,"crumb_title_link"=> true, "crumb_title"=> "All Jobs");
$breadcrumb[1] = array("crumb_attrs" => "", "crumb_title_span"=> true,"crumb_title" => $_SESSION["active_category_name"] );
$xt->assign_loopsection("crumb", $breadcrumb);
}
if(Security::getUserGroup()!=="isGuest")
$pageObject->hideItem("job_apply_now");

$is_sub = DB::SelectValue("subscription","jobsusers",array("ID" => $_SESSION["profile"]["user_id"]));
if( !isLogged() || Security::isGuest() || $is_sub || Security::getUserGroup()!=="jobseeker") {
$pageObject->hideItem("Subscribe_button");
}

// User-Posted Jobs Card
//$open_jobs = DBLookup("SELECT COUNT(*) FROM jobsjobs");
//$xt->assign("open_jobs", $open_jobs);
// User-Posted Jobs Expiry-Aware Counts
$user_active = DBLookup("
    SELECT
  jobsjobs.ID,
  jobsjobs.Title,
  COALESCE(extended_due_date, due_date) AS expire_date,
  jobsjobs.City,
  jobsjobs.Company,
  jobs_profile.employer_businessname AS employer_businessname,
  jobsjobs.TypeID,
  jobsjobs.SubCategory,
  jobsjobs.Country,
  jobsjobs.Description,
  jobsjobs.HowToApply,
  jobsjobs.LogoURL,
  jobsjobs.state
FROM jobsjobs
LEFT JOIN jobs_profile ON jobsjobs.Company = jobs_profile.user_id
WHERE COALESCE(extended_due_date, due_date) > CURDATE()
ORDER BY jobsjobs.Title ASC
LIMIT 8
");

$user_active = DBLookup("
    SELECT COUNT(*) 
    FROM jobsjobs 
    LEFT JOIN jobs_profile ON jobsjobs.Company = jobs_profile.user_id
    WHERE COALESCE(extended_due_date, due_date) > CURDATE()
");

$user_expired7 = DBLookup("
    SELECT COUNT(*) 
    FROM jobsjobs 
    LEFT JOIN jobs_profile ON jobsjobs.Company = jobs_profile.user_id
    WHERE COALESCE(extended_due_date, due_date) <= CURDATE()
      AND COALESCE(extended_due_date, due_date) >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)
");

$user_archived = DBLookup("
    SELECT COUNT(*) 
    FROM jobsjobs 
    LEFT JOIN jobs_profile ON jobsjobs.Company = jobs_profile.user_id
    WHERE COALESCE(extended_due_date, due_date) < DATE_SUB(CURDATE(), INTERVAL 7 DAY)
");


$xt->assign("user_active", number_format($user_active) . " Active");
$xt->assign("user_expired7", number_format($user_expired7) . " Expired (7d)");
$xt->assign("user_archived", number_format($user_archived) . " Archived");


// Year filter
$year = isset($_GET['year']) ? $_GET['year'] : 'all';
$selected_year = $year;
$xt->assign("selected_year", $selected_year);

//Update the Title in PHP
switch ($selected_year) {
    case "this_month":
        $filter_label = "This Month";
        break;
    case "last_12_months":
        $filter_label = "Last 12 Months";
        break;
    case "all":
    default:
        $filter_label = "All Data";
        break;
}

$xt->assign("filter_label", $filter_label);

// Build WHERE clause
$where = "";
if ($year === "this_month") {
    $where = "WHERE MONTH(DateAdded) = MONTH(CURRENT_DATE()) AND YEAR(DateAdded) = YEAR(CURRENT_DATE())";
} elseif ($year === "last_12_months") {
    $where = "WHERE DateAdded >= DATE_SUB(CURDATE(), INTERVAL 12 MONTH)";
} elseif ($year !== "all") {
    $where = "WHERE YEAR(Date) = " . db_prepare_string($year);
}

// Chart data 001
$sql = "SELECT COUNT(ID) AS state_count, state
        FROM jobsjobs
        $where
        GROUP BY state";

$data = [];
$total = 0;
$rs = DB::Query($sql);
while ($row = $rs->fetchAssoc()) {
    $data[] = $row;
    $total += $row["state_count"];
}

$xt->assign("chart_labels", json_encode(array_column($data, 'state')));
$xt->assign("chart_values", json_encode(array_column($data, 'state_count')));
$xt->assign("chart_total", $total);

// Available years (once)
$available_years = [];
$rsYears = DB::Query("SELECT DISTINCT YEAR(DateAdded) AS year FROM jobsjobs WHERE DateAdded IS NOT NULL ORDER BY year DESC");
while ($row = $rsYears->fetchAssoc()) {
    $available_years[] = $row["year"];
}
$xt->assign("available_years", $available_years);



// ===============================
// Step 1: Initialize job cards and count
// ===============================
$job_cards = "";
$job_count = 0;
$today = date('Y-m-d');

// ===============================
// Step 2: Fetch valid job records
// ===============================
$sql = " SELECT
jobsjobs.ID,
jobsjobs.Title,
COALESCE(jobsjobs.DateAdded, due_date) AS expire_date,
jobsjobs.City,
jobsjobs.Company,
jobs_profile.employer_businessname AS employer_businessname,
jobsjobs.TypeID,
jobsjobs.SubCategory,
jobsjobs.Country,
jobsjobs.Description,
jobsjobs.HowToApply,
jobsjobs.LogoURL,
jobsjobs.state
FROM jobsjobs
LEFT OUTER JOIN jobs_profile ON jobsjobs.Company = jobs_profile.user_id
WHERE (COALESCE(extended_due_date, due_date) < CURDATE() - INTERVAL 7 DAY)
ORDER BY jobsjobs.Title ASC
LIMIT 8
";

$rs = DB::Query($sql);

// ===============================
// Step 3: Build cards loop with Sticky Notes
// ===============================

function BeforeProcessRowList(&$data, &$pageObject)
{
    $expiryRaw = $data['expire_date'];
    $formattedDate = date("d M Y", strtotime($expiryRaw));
    $timeDiffSeconds = strtotime($expiryRaw) - time();
    $daysRemaining = floor($timeDiffSeconds / 86400);

    $closingSoon = false;
    $isExpired = false;
    $graceMessage = '';

    if ($daysRemaining <= 7 && $daysRemaining > 0) {
        $closingSoon = true;

    } elseif ($daysRemaining < 0) {
        $daysSinceExpiry = abs($daysRemaining);

        if ($daysSinceExpiry <= 7) {
            $leftSeconds = (7 * 86400) - abs($timeDiffSeconds);

            if ($leftSeconds <= 0) {
                $graceMessage = "🔒 Expired — auto-archiving now.";
            } elseif ($leftSeconds < 60) {
                $graceMessage = "🔒 Expired — auto-archiving in < 1 min.";
            } elseif ($leftSeconds < 3600) {
                $mins = floor($leftSeconds / 60);
                $graceMessage = "🔒 Expired — waiting for possible extension. Auto-archiving in {$mins} min" . ($mins != 1 ? "s" : "") . ".";
            } elseif ($leftSeconds < 86400) {
                $hrs = floor($leftSeconds / 3600);
                $mins = floor(($leftSeconds % 3600) / 60);
                $graceMessage = "🔒 Expired — waiting for possible extension. Auto-archiving in {$hrs} hr" . ($hrs != 1 ? "s" : "");
                if ($mins > 0) {
                    $graceMessage .= " {$mins} min" . ($mins != 1 ? "s" : "");
                }
                $graceMessage .= ".";
            } else {
                $leftDays = floor($leftSeconds / 86400);
                $graceMessage = "🔒 Expired — waiting for possible extension. Auto-archiving in {$leftDays} day" . ($leftDays != 1 ? "s" : "") . ".";
            }
        } else {
            $isExpired = true;
            $graceMessage = "🔒 Expired — no extension received.";
        }
    }

    // Assign to virtual field (must be shown in List layout or in {$expiry_status})
    $data["expiry_status"] = $graceMessage;

    return true;
}



    $desc_full = strip_tags(html_entity_decode($job['Description']));
    $desc_preview = mb_substr($desc_full, 0, 150); // first 150 characters

    // Sticky Note design added here
    $job_cards .= "<div class='sticky-note'>"; // Begin sticky note structure
    $job_cards .= "<h3><span class='pin-icon'>📌</span> " . htmlspecialchars($job['Title']) . "</h3>";  // Job Title
    $job_cards .= "<p><strong>Company:</strong> " . htmlspecialchars($job['employer_businessname']) . "</p>";  // Company name
    $job_cards .= "<p><strong>City:</strong> " . htmlspecialchars($job['City']) . "</p>";  // City

    // Expiry Info
$job_cards .= "<p><strong>Expires:</strong> {$formattedDate}</p>";

// Put "Closing in" in its own line under expiry
if ($closingSoon) {
    $label = $daysRemaining == 1 ? "day" : "days";
    $job_cards .= "<div class='closing-soon-animated'>🔴 Closing in {$daysRemaining} {$label}</div>";
}

// Handle expired or grace message in a grouped box
if (!empty($graceMessage) || $isExpired) {
    $job_cards .= "<div class='expired-box'>";

    if (!empty($graceMessage)) {
        $job_cards .= "<span class='grace-message'>{$graceMessage}</span>";
    }

    if ($isExpired) {
        $job_cards .= "<span class='expired-tag'>🔒 Archived</span>";
    }

    $job_cards .= "</div>";
}


// ===============================
// Step 4: Handle no jobs fallback
// ===============================
if ($user_active == 0) {
  $job_cards = <<<HTML
<div class="no-local-jobs" id="noJobsAlert">
  <button class="alert-close-btn" onclick="dismissNoJobs()" aria-label="Close alert">
  <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="#d63384" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
    <line x1="18" y1="6" x2="6" y2="18"></line>
    <line x1="6" y1="6" x2="18" y2="18"></line>
  </svg>
</button>

  <h3><span style="font-size: 24px;">❌</span> No Active User-Posted or Private Sector Jobs Available</h3>
  <p>We're sorry — there are currently no active job postings submitted by Users or Private Sector Employers on this platform.</p>
  <p>Expired jobs are archived and no longer listed publicly. Please explore <strong>Government Jobs</strong>, <strong>Regional Listings</strong>, and <strong>International Opportunities</strong> below for current openings.</p>
</div>


HTML;

  $xt->assign("show_local_heading", false);
  $xt->assign("show_load_more_button", false);
} else {
  $xt->assign("show_local_heading", true);
  $xt->assign("show_load_more_button", true);
}

$xt->assign("job_cards", $job_cards);

//_______________________________________________________________________________________________________

// Fetch distinct state values from the database
$stateOptions = array();
$rs = DB::Query("SELECT DISTINCT state FROM jobsjobs WHERE state IS NOT NULL AND state <> '' ORDER BY state");
while ($data = $rs->fetchAssoc()) {
    $stateOptions[] = array("state" => $data["state"]);
}
// Assign to HTML template block
$xt->assign_loopsection("state_dropdown", $stateOptions);

// Include the merged feed
include_once("merged_jobs_feed.php");

// Fetch grouped jobs
$jobsBySource = fetchJobsBySource();

// Start HTML content
$html = "";
//$html .= "<h2 style='text-align:center; margin-top:40px;'>🌐 Samoa Government, Regional & Remote Tech Jobs (Live Feed)</h2>";
//$html .= getExternalJobsDisclaimer();  // ✅ disclaimer from merged_jobs_feed.php

// Loop through each source block (SPREP, UNDP, Himalayas, etc.)
foreach ($jobsBySource as $source => $jobList) {
    if (empty($jobList)) continue;

    $html .= "<h3 style='text-align:center; margin-top:30px;'>🌍 " . htmlspecialchars($source) . "</h3>";
    $html .= "<div class='jobs-grid'>";

    foreach ($jobList as $job) {
        $source = $job['source'];
        $company = $job['company'];
        $sourceSlug = strtolower(preg_replace('/[^a-zA-Z0-9]+/', '-', $source)); // e.g. 'SPREP' => 'sprep'


        // 🧱 Start card
        $cardClass = $isExpired ? 'job-card expired-card' : 'job-card';
				 $html .= "<div class='{$cardClass} card-{$sourceSlug}'>";


        // 🧾 Title and company/org
        $html .= "<h3>" . htmlspecialchars($job['title']) . "</h3>";
switch ($source) {
    case 'Govt':
        $label = 'Government';
        break;
    case 'PJN':
        $label = 'Pacific Vacancies';
        break;
    case 'SPREP':
    case 'SPC':
    case 'PIFS':
    case 'FFA':
    case 'UNDP':
        $label = 'Organization';
        break;
    default:
        $label = 'Company';
}

        $html .= "<p><strong>$label:</strong> " . htmlspecialchars($company) . "</p>";
        $html .= "<p><strong>Type:</strong> " . htmlspecialchars($job['type']) . "</p>";

        // 📍 Location
        $locationFull = htmlspecialchars($job['location']);
        $locationPreview = mb_strlen($locationFull) > 100 ? mb_substr($locationFull, 0, 100) : $locationFull;
        $hasMoreLocation = mb_strlen($locationFull) > 100;

        $html .= "<p><strong>Location:</strong> ";
        if ($hasMoreLocation) {
            $html .= "<span class='location-preview'>{$locationPreview}...</span>";
            $html .= "<span class='location-full' style='display:none;'>{$locationFull}</span>";
            $html .= "<a href='javascript:void(0)' class='toggle-location' onclick='toggleLocation(this)'>Read more</a>";
        } else {
            $html .= $locationFull;
        }
        $html .= "</p>";

// 📅 Expiry + inline "Closing Soon"

$closingSoon = false;
$isExpired = false;
$formattedDate = '';
$daysRemaining = null;

if (!empty($job['expiry_date'])) {
    $rawDate = $job['expiry_date'];

    if (is_numeric($rawDate)) {
        if ($rawDate > 9999999999) {
            $rawDate = $rawDate / 1000;
        }
        $formattedDate = date("d M Y", (int)$rawDate);
        $daysRemaining = floor(($rawDate - time()) / 86400);

        if ($daysRemaining <= 7 && $daysRemaining > 0) {
            $closingSoon = true;
        } elseif ($daysRemaining < 0) {
            $isExpired = true;
        }
    } else {
        $formattedDate = htmlspecialchars($rawDate);
    }
}


$html .= "<p><strong>Expires:</strong> {$formattedDate}";

if ($isExpired) {
    $daysSinceExpiry = abs($daysRemaining);
    if ($daysSinceExpiry <= 7) {
        $left = 7 - $daysSinceExpiry;
        $html .= " <span class='grace-message'>🔒 Expired — waiting for possible extension. Auto-archiving in {$left} day" . ($left != 1 ? "s" : "") . ".</span>";
    } else {
        $html .= " <span class='expired-tag'>🔒 Expired</span>";
    }
} elseif ($closingSoon) {
    $daysLabel = $daysRemaining == 1 ? "day" : "days";
    $html .= " <span class='closing-soon-animated'>🔴 Closing in {$daysRemaining} {$daysLabel}</span>";
}

$html .= "</p>";

        // 📄 Description
        $descFull = htmlspecialchars($job['excerpt_full']);
        $hasMoreDesc = mb_strlen($descFull) > 160;
        $descPreview = mb_substr($descFull, 0, 160);

        if (!empty(trim($descFull))) {
            $html .= "<p><strong>Description:</strong><br>";
            if ($hasMoreDesc) {
                $html .= "<span class='desc-preview'>{$descPreview}...</span>";
                $html .= "<span class='desc-full' style='display:none;'>{$descFull}</span>";
                $html .= "<a href='javascript:void(0)' class='toggle-desc' onclick='toggleDescription(this)'>Read more</a>";
            } else {
                $html .= $descFull;
            }
            $html .= "</p>";
        }

        // 🔗 View Job button
//        $html .= "<a class='view-job-btn' href='track_remote_click.php?url=" . urlencode($job['url']) .
//                 "&title=" . urlencode($job['title']) .
//                  "&company=" . urlencode($job['company']) .
//                 "' target='_blank'>View Job</a>";

					$html .= "<a class='view-job-btn' href='track_remote_click.php?" .
         "url=" . urlencode($job['url']) .
         "&title=" . urlencode($job['title']) .
         "&company=" . urlencode($job['company']) .
         "' target='_blank'>View Job</a>";	

//					$html .= "<div class='card-hover-tip'>💡 Great fit if you’ve got experience in <strong>" . htmlspecialchars($job['title']) . "</strong></div>";
					$html .= "<div class='card-hover-tip'>
  <span class='close-tip' onclick='this.parentElement.style.display=\"none\"' title='Dismiss tip'>✖</span>
  💡 Great fit if you’ve got experience in <strong>" . htmlspecialchars($job['title']) . "</strong>
</div>";



        $html .= "</div>"; // Close .job-card
    }

    $html .= "</div>"; // Close .jobs-grid
}

// Assign to template
$xt->assign("external_jobs", $html);

// Handle AJAX refresh
if (postvalue("ajax_remote_jobs") == "1") {
    echo $xt->fetchVar("external_jobs");
    exit();
}


//____________________________________________________________________________________________________________

// 📊 Prepare chart data for User-Posted Jobs flip card
$user_active = DB::Lookup("SELECT COUNT(*) FROM jobsjobs WHERE COALESCE(extended_due_date, due_date) > CURDATE()");
$user_expired7 = DB::Lookup("
    SELECT COUNT(*) FROM jobsjobs
    WHERE COALESCE(extended_due_date, due_date) <= CURDATE()
      AND COALESCE(extended_due_date, due_date) >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)
");
$user_archived = DB::Lookup("
    SELECT COUNT(*) FROM jobsjobs
    WHERE COALESCE(extended_due_date, due_date) < DATE_SUB(CURDATE(), INTERVAL 7 DAY)
");

// Assign raw values for JS use
$xt->assign("user_active_raw", $user_active);
$xt->assign("user_expired7_raw", $user_expired7);
$xt->assign("user_archived_raw", $user_archived);

// Assign formatted values for HTML display
$xt->assign("user_active", number_format($user_active) . " Active");
$xt->assign("user_expired7", number_format($user_expired7) . " Expired (7d)");
$xt->assign("user_archived", number_format($user_archived) . " Archived");

