<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["jobsjobtype"] ) ) {
			$lookupTableLinks["jobsjobtype"] = array();
		}
		if( !isset( $lookupTableLinks["jobsjobtype"]["jobsjobs.TypeID"] )) {
			$lookupTableLinks["jobsjobtype"]["jobsjobs.TypeID"] = array();
		}
		$lookupTableLinks["jobsjobtype"]["jobsjobs.TypeID"]["edit"] = array("table" => "jobsjobs", "field" => "TypeID", "page" => "edit");
		if( !isset( $lookupTableLinks["jobsjobtype"] ) ) {
			$lookupTableLinks["jobsjobtype"] = array();
		}
		if( !isset( $lookupTableLinks["jobsjobtype"]["jobsjobs_admin.TypeID"] )) {
			$lookupTableLinks["jobsjobtype"]["jobsjobs_admin.TypeID"] = array();
		}
		$lookupTableLinks["jobsjobtype"]["jobsjobs_admin.TypeID"]["edit"] = array("table" => "jobsjobs_admin", "field" => "TypeID", "page" => "edit");
		if( !isset( $lookupTableLinks["address"] ) ) {
			$lookupTableLinks["address"] = array();
		}
		if( !isset( $lookupTableLinks["address"]["jobsjobs_admin.state"] )) {
			$lookupTableLinks["address"]["jobsjobs_admin.state"] = array();
		}
		$lookupTableLinks["address"]["jobsjobs_admin.state"]["edit"] = array("table" => "jobsjobs_admin", "field" => "state", "page" => "edit");
		if( !isset( $lookupTableLinks["jobsjobtype"] ) ) {
			$lookupTableLinks["jobsjobtype"] = array();
		}
		if( !isset( $lookupTableLinks["jobsjobtype"]["jobsjobs_admin.SubCategory"] )) {
			$lookupTableLinks["jobsjobtype"]["jobsjobs_admin.SubCategory"] = array();
		}
		$lookupTableLinks["jobsjobtype"]["jobsjobs_admin.SubCategory"]["edit"] = array("table" => "jobsjobs_admin", "field" => "SubCategory", "page" => "edit");
		if( !isset( $lookupTableLinks["jobsjobtype"] ) ) {
			$lookupTableLinks["jobsjobtype"] = array();
		}
		if( !isset( $lookupTableLinks["jobsjobtype"]["jobs_jobseeker_profile.industrial_area"] )) {
			$lookupTableLinks["jobsjobtype"]["jobs_jobseeker_profile.industrial_area"] = array();
		}
		$lookupTableLinks["jobsjobtype"]["jobs_jobseeker_profile.industrial_area"]["edit"] = array("table" => "jobs_jobseeker_profile", "field" => "industrial_area", "page" => "edit");
		if( !isset( $lookupTableLinks["jobsjobtype"] ) ) {
			$lookupTableLinks["jobsjobtype"] = array();
		}
		if( !isset( $lookupTableLinks["jobsjobtype"]["jobs_jobseeker_profile.employment_sought"] )) {
			$lookupTableLinks["jobsjobtype"]["jobs_jobseeker_profile.employment_sought"] = array();
		}
		$lookupTableLinks["jobsjobtype"]["jobs_jobseeker_profile.employment_sought"]["edit"] = array("table" => "jobs_jobseeker_profile", "field" => "employment_sought", "page" => "edit");
		if( !isset( $lookupTableLinks["mmtasks"] ) ) {
			$lookupTableLinks["mmtasks"] = array();
		}
		if( !isset( $lookupTableLinks["mmtasks"]["mmlog.taskid"] )) {
			$lookupTableLinks["mmtasks"]["mmlog.taskid"] = array();
		}
		$lookupTableLinks["mmtasks"]["mmlog.taskid"]["edit"] = array("table" => "mmlog", "field" => "taskid", "page" => "edit");
		if( !isset( $lookupTableLinks["mmencodings"] ) ) {
			$lookupTableLinks["mmencodings"] = array();
		}
		if( !isset( $lookupTableLinks["mmencodings"]["mmtasks.encoding"] )) {
			$lookupTableLinks["mmencodings"]["mmtasks.encoding"] = array();
		}
		$lookupTableLinks["mmencodings"]["mmtasks.encoding"]["edit"] = array("table" => "mmtasks", "field" => "encoding", "page" => "edit");
		if( !isset( $lookupTableLinks["mmintervaltype"] ) ) {
			$lookupTableLinks["mmintervaltype"] = array();
		}
		if( !isset( $lookupTableLinks["mmintervaltype"]["mmtasks.interval"] )) {
			$lookupTableLinks["mmintervaltype"]["mmtasks.interval"] = array();
		}
		$lookupTableLinks["mmintervaltype"]["mmtasks.interval"]["edit"] = array("table" => "mmtasks", "field" => "interval", "page" => "edit");
		if( !isset( $lookupTableLinks["mmoptions"] ) ) {
			$lookupTableLinks["mmoptions"] = array();
		}
		if( !isset( $lookupTableLinks["mmoptions"]["mmtasks.sendoptions"] )) {
			$lookupTableLinks["mmoptions"]["mmtasks.sendoptions"] = array();
		}
		$lookupTableLinks["mmoptions"]["mmtasks.sendoptions"]["edit"] = array("table" => "mmtasks", "field" => "sendoptions", "page" => "edit");
		if( !isset( $lookupTableLinks["weekdays"] ) ) {
			$lookupTableLinks["weekdays"] = array();
		}
		if( !isset( $lookupTableLinks["weekdays"]["mmtasks.weekday"] )) {
			$lookupTableLinks["weekdays"]["mmtasks.weekday"] = array();
		}
		$lookupTableLinks["weekdays"]["mmtasks.weekday"]["edit"] = array("table" => "mmtasks", "field" => "weekday", "page" => "edit");
		if( !isset( $lookupTableLinks["mmlists"] ) ) {
			$lookupTableLinks["mmlists"] = array();
		}
		if( !isset( $lookupTableLinks["mmlists"]["mmsubscribers.listid"] )) {
			$lookupTableLinks["mmlists"]["mmsubscribers.listid"] = array();
		}
		$lookupTableLinks["mmlists"]["mmsubscribers.listid"]["edit"] = array("table" => "mmsubscribers", "field" => "listid", "page" => "edit");
		if( !isset( $lookupTableLinks["clcategory"] ) ) {
			$lookupTableLinks["clcategory"] = array();
		}
		if( !isset( $lookupTableLinks["clcategory"]["jobsusers_upload.industrial_area"] )) {
			$lookupTableLinks["clcategory"]["jobsusers_upload.industrial_area"] = array();
		}
		$lookupTableLinks["clcategory"]["jobsusers_upload.industrial_area"]["edit"] = array("table" => "jobsusers_upload", "field" => "industrial_area", "page" => "edit");
		if( !isset( $lookupTableLinks["jobsjobtype"] ) ) {
			$lookupTableLinks["jobsjobtype"] = array();
		}
		if( !isset( $lookupTableLinks["jobsjobtype"]["your_job_s.TypeID"] )) {
			$lookupTableLinks["jobsjobtype"]["your_job_s.TypeID"] = array();
		}
		$lookupTableLinks["jobsjobtype"]["your_job_s.TypeID"]["edit"] = array("table" => "your_job/s", "field" => "TypeID", "page" => "edit");
		if( !isset( $lookupTableLinks["jobsjobtype"] ) ) {
			$lookupTableLinks["jobsjobtype"] = array();
		}
		if( !isset( $lookupTableLinks["jobsjobtype"]["jobsjobs_cards_limits_10.TypeID"] )) {
			$lookupTableLinks["jobsjobtype"]["jobsjobs_cards_limits_10.TypeID"] = array();
		}
		$lookupTableLinks["jobsjobtype"]["jobsjobs_cards_limits_10.TypeID"]["edit"] = array("table" => "jobsjobs-cards-limits-10", "field" => "TypeID", "page" => "edit");
		if( !isset( $lookupTableLinks["jobsjobtype"] ) ) {
			$lookupTableLinks["jobsjobtype"] = array();
		}
		if( !isset( $lookupTableLinks["jobsjobtype"]["combine_charts_local_and_external.TypeID"] )) {
			$lookupTableLinks["jobsjobtype"]["combine_charts_local_and_external.TypeID"] = array();
		}
		$lookupTableLinks["jobsjobtype"]["combine_charts_local_and_external.TypeID"]["edit"] = array("table" => "combine_charts-local-and-external", "field" => "TypeID", "page" => "edit");
		if( !isset( $lookupTableLinks["jobsjobtype"] ) ) {
			$lookupTableLinks["jobsjobtype"] = array();
		}
		if( !isset( $lookupTableLinks["jobsjobtype"]["jobsjobs_dashboard.TypeID"] )) {
			$lookupTableLinks["jobsjobtype"]["jobsjobs_dashboard.TypeID"] = array();
		}
		$lookupTableLinks["jobsjobtype"]["jobsjobs_dashboard.TypeID"]["edit"] = array("table" => "jobsjobs-dashboard", "field" => "TypeID", "page" => "edit");
}

?>