<?php
/**
 * 	Dear developer!
 *	Never modify events.php file, it is autogenerated.
 *  Modify PHP/EventTemplates/events.txt instead.
 *
 */

 class eventclass_jobsjobs  extends eventsBase
{
	function __construct()
	{
	// fill list of events
		$this->events["BeforeShowList"]=true;
		$this->events["BeforeShowView"]=true;
		$this->events["BeforeProcessList"]=true;
	}
//	handlers
		
// Before display
function BeforeShowList(&$xt, &$templatefile, $pageObject)
{

//New

// Show Admin button only if logged in as Admin
    if (Security::isLoggedIn() && Security::isAdmin()) {
        $xt->assign("admin_button", true);
    } else {
        $xt->assign("admin_button", false);
    }

// =======================
        // USER-POSTED JOB CARDS
        // =======================
        $job_cards = "";
        $job_count = 0;
        $today = date('Y-m-d');
        $isLoggedJobseeker = Security::isLoggedIn() && Security::getUserGroup() === "jobseeker";

        $sql = "
            SELECT
        jobsjobs.ID,
        jobsjobs.Title,
        COALESCE(extended_due_date, due_date) AS expire_date,
        jobsjobs.City,
        jobsjobs.Company,
        jobs_profile.employer_businessname,
        jobsjobs.Description
    FROM jobsjobs
    LEFT JOIN jobs_profile ON jobsjobs.Company = jobs_profile.user_id
    WHERE COALESCE(extended_due_date, due_date) > CURDATE() - INTERVAL 7 DAY
    ORDER BY jobsjobs.Title ASC
    LIMIT 8
        ";
        $rs = DB::Query($sql);

        while ($job = $rs->fetchAssoc()) {
            $job_count++;
            $job_id = (int)$job['ID'];
            $title = htmlspecialchars($job['Title']);
            $company = htmlspecialchars($job['employer_businessname']);
            $city = htmlspecialchars($job['City']);
            $desc_full = strip_tags(html_entity_decode($job['Description']));
            $desc_preview = mb_substr($desc_full, 0, 160);

            // Expiry calculations
            $expiryRaw = $job['expire_date'];
            $expiryTime = strtotime($expiryRaw);
            $formattedDate = date("d M Y", $expiryTime);
            $daysRemaining = floor(($expiryTime - time()) / 86400);

            $closingSoon = false;
            $isExpired = false;
            $graceMessage = '';

            if ($daysRemaining <= 7 && $daysRemaining > 0) {
                $closingSoon = true;
            } elseif ($daysRemaining < 0) {
                $daysSinceExpiry = abs($daysRemaining);
                if ($daysSinceExpiry <= 7) {
                    $left = 7 - $daysSinceExpiry;
                    $graceMessage = "🔒 Expired — waiting for possible extension. Auto-archiving in {$left} day" . ($left != 1 ? "s" : "") . ".";
                } else {
                    $isExpired = true;
                    $graceMessage = "🔒 Expired — no extension received.";
                }
            }

            // Build job card (similar style as external)
            $job_cards .= "<div class='job-card'>";
            
            // Apply Now logic (logged-in jobseeker vs popup)
            $applyLink = $isLoggedJobseeker
                ? "application_form_add.php?jobid={$job_id}"
                : "javascript:void(0)";
            $applyOnClick = $isLoggedJobseeker ? "" : "onclick='showApplyMessage(this, {$job_id})'";

            $job_cards .= "<a href='{$applyLink}' class='apply-now-btn' {$applyOnClick}>Apply</a>";
            if (!$isLoggedJobseeker) {
                $job_cards .= "<div class='apply-message-popup' style='display:none;'>You need to register to apply.<br><button onclick=\"openModal('register.php?page=register_jobseeker')\">Register</button></div>";
            }

            $job_cards .= "<h3>{$title}</h3>";
            $job_cards .= "<p><strong>Company:</strong> {$company}</p>";
            $job_cards .= "<p><strong>City:</strong> {$city}</p>";
            $job_cards .= "<p><strong>Expires:</strong> {$formattedDate}";

            if (!empty($graceMessage)) {
                $job_cards .= " <span class='grace-message'>{$graceMessage}</span>";
            } elseif ($isExpired) {
                $job_cards .= " <span class='expired-tag'>🔒 Archived</span>";
            } elseif ($closingSoon) {
                $label = $daysRemaining == 1 ? "day" : "days";
                $job_cards .= " <span class='closing-soon-animated'>🔴 Closing in {$daysRemaining} {$label}</span>";
            }
            $job_cards .= "</p>";

            $job_cards .= "<p><strong>Description:</strong><br>
                <span class='desc-preview'>{$desc_preview}...</span>
                <span class='desc-full' style='display:none;'>{$desc_full}</span>
                <a href='javascript:void(0)' class='toggle-desc' onclick='toggleDescription(this)'>Read more</a>
            </p>";

            $job_cards .= "</div>";
        }

        if ($job_count > 0) {
    // Add a wrapper with center alignment
    $wrapperClass = ($job_count <= 2) ? "jobs-grid center-grid" : "jobs-grid";
    $job_cards = "<div class='{$wrapperClass}'>" . $job_cards . "</div>";
} else {
    $job_cards = <<<HTML
<div class="no-local-jobs" id="noJobsAlert">
  <button class="alert-close-btn" onclick="dismissNoJobs()" aria-label="Close alert">
  <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="#d63384" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
    <line x1="18" y1="6" x2="6" y2="18"></line>
    <line x1="6" y1="6" x2="18" y2="18"></line>
  </svg>
</button>

  <h3><span style="font-size: 24px;">❌</span> No Active User-Posted or Private Sector Jobs Available</h3>
  <p>We're sorry — there are currently no active job postings submitted by Users or Private Sector Employers on this platform.</p>
  <p>Expired jobs are archived and no longer listed publicly. Please explore <strong>Government Jobs</strong>, <strong>Regional Listings</strong>, and <strong>International Opportunities</strong> below for current openings.</p>
</div>
HTML;
    $xt->assign("show_local_heading", false);
}

$xt->assign("job_cards", $job_cards);

		
		//----------------------------------------------------------

include_once("load_external_chart_data.php");
include_once("merged_jobs_feed.php");

$jobsBySource = fetchJobsBySource();
$html = "";

foreach ($jobsBySource as $source => $jobList) {
    if (empty($jobList)) continue;
		
		 $sourceSlug = strtolower(preg_replace('/[^a-zA-Z0-9]+/', '-', $source));
    $sourceSlug = getSourceSlug($source);
    $html .= "<h3 id='section--{$sourceSlug}' style='text-align:center; margin-top:30px;'>🌍 " . htmlspecialchars($source) . "</h3>";
    $html .= "<div class='jobs-grid'>";

    foreach ($jobList as $job) {
        $sourceSlug = getSourceSlug($job['source']);
        $cardClass = 'job-card';
		
		switch ($job['source']) {
	case 'Govt':
        $label = 'Government';
        $logoSlug = 'govt';
        break;
    case 'PJN':
        $label = 'Pacific Vacancies';
        $logoSlug = 'pjn';
        break;
    case 'SPREP':
        $label = 'Organization';
        $logoSlug = 'sprep';
        break;
    case 'SPC':
        $label = 'Organization';
        $logoSlug = 'spc';
        break;
    case 'PIFS':
        $label = 'Organization';
        $logoSlug = 'pifs';
        break;
    case 'FFA':
        $label = 'Organization';
        $logoSlug = 'ffa';
        break;
    case 'UNDP':
        $label = 'Organization';
        $logoSlug = 'undp';
        break;
    default:
        $label = 'Employer';
        $logoSlug = 'default'; // fallback class if no logo
		}
 
		
        // Determine expiry status
        $isExpired = false;
        $closingSoon = false;
        $formattedDate = '';
        $daysRemaining = null;

        if (!empty($job['expiry_date'])) {
            $rawDate = $job['expiry_date'];
            if (is_numeric($rawDate)) {
                if ($rawDate > 9999999999) $rawDate = $rawDate / 1000;
                $formattedDate = date("d M Y", (int)$rawDate);
                $daysRemaining = floor(($rawDate - time()) / 86400);
                $closingSoon = $daysRemaining <= 7 && $daysRemaining > 0;
                $isExpired = $daysRemaining < 0;
            } else {
                $formattedDate = htmlspecialchars($rawDate);
            }
        }

        if ($isExpired) $cardClass .= " expired-card";

//      $html .= "<div class='{$cardClass} card-{$sourceSlug}'>";
//		$html .= "<div class='{$cardClass} card-logo-{$logoSlug}'>";
		$html .= "<div class='{$cardClass} card-logo-{$logoSlug} tag-{$logoSlug}'>";
//		$html .= "<div class='{$cardClass} tag-{$logoSlug}'>";
//		$html .= "<div class='card-logo card-logo-{$logoSlug}'></div>"; // 👈 insert logo block


        $html .= "<h3>" . htmlspecialchars($job['title']) . "</h3>";
		$html .= "<p><strong>{$label}:</strong> " . htmlspecialchars($job['company']) . "</p>";
        $html .= "<p><strong>Type:</strong> " . htmlspecialchars($job['type']) . "</p>";
        $locationFull = htmlspecialchars($job['location']);
        $hasMoreLocation = mb_strlen($locationFull) > 100;
        $locationPreview = mb_substr($locationFull, 0, 100);
        $html .= "<p><strong>Location:</strong> ";
        if ($hasMoreLocation) {
            $html .= "<span class='location-preview'>{$locationPreview}...</span><span class='location-full' style='display:none;'>{$locationFull}</span><a href='javascript:void(0)' class='toggle-location' onclick='toggleLocation(this)'>Read more</a>";
        } else {
            $html .= $locationFull;
        }
        $html .= "</p>";

        $html .= "<p><strong>Expires:</strong> {$formattedDate}";
        if ($isExpired) {
            $daysSinceExpiry = abs($daysRemaining);
            if ($daysSinceExpiry <= 7) {
                $left = 7 - $daysSinceExpiry;
                $html .= " <span class='grace-message'>🔒 Expired — waiting for possible extension. Auto-archiving in {$left} day" . ($left != 1 ? "s" : "") . ".</span>";
            } else {
                $html .= " <span class='expired-tag'>🔒 Expired</span>";
            }
        } elseif ($closingSoon) {
            $daysLabel = $daysRemaining == 1 ? "day" : "days";
            $html .= " <span class='closing-soon-animated'>🔴 Closing in {$daysRemaining} {$daysLabel}</span>";
        }
        $html .= "</p>";

        $descFull = htmlspecialchars($job['excerpt_full']);
        $hasMoreDesc = mb_strlen($descFull) > 160;
        $descPreview = mb_substr($descFull, 0, 160);

        if (!empty(trim($descFull))) {
            $html .= "<p><strong>Description:</strong><br>";
            if ($hasMoreDesc) {
                $html .= "<span class='desc-preview'>{$descPreview}...</span><span class='desc-full' style='display:none;'>{$descFull}</span><a href='javascript:void(0)' class='toggle-desc' onclick='toggleDescription(this)'>Read more</a>";
            } else {
                $html .= $descFull;
            }
            $html .= "</p>";
        }

        $html .= "<a class='view-job-btn' href='track_remote_click.php?url=" . urlencode($job['url']) . "&title=" . urlencode($job['title']) . "&company=" . urlencode($job['company']) . "' target='_blank'>View Job</a>";
		
		$html .= "
			<div class='card-actions'>
			  <button onclick=\"copyJobLink('{$job['url']}')\" title='Copy link'><i class='icon-copy'></i></button>
			  <button onclick=\"likeJob(this)\" title='Like'><i class='icon-like'></i></button>
			  <button onclick=\"dislikeJob(this)\" title='Dislike'><i class='icon-dislike'></i></button>
			  <button onclick=\"readJobTitle('{$job['title']}')\" title='Read aloud'><i class='icon-sound'></i></button>
			  <button onclick=\"toggleDescription(this)\" title='Toggle full text'><i class='icon-eye'></i></button>
			  <button onclick=\"bookmarkJob(this)\" title='Save job'><i class='icon-bookmark'></i></button>
			  <button onclick=\"refreshJob(this)\" title='Reload job'><i class='icon-refresh'></i></button>
			  <button onclick=\"shareJob('{$job['url']}')\" title='Share'><i class='icon-share'></i></button>
			</div>";

		
        $encouragements = [
            "🚀 Your moment is now — make the leap!",
            "💪 You've got what it takes. Let’s go!",
            "🌱 Every expert was once a beginner.",
            "🔥 Shine bright, this could be your spark.",
            "💡 Opportunity knocks. Open the door.",
            "📈 Ready to grow your career?",
            "🎯 You’re closer than you think!",
            "🌟 This could be your breakout role.",
            "🛠️ Skills ready. Time to apply!",
            "🎓 Learning never stops — go for it.",
            "🌍 New challenges bring new rewards.",
            "🏆 You deserve this opportunity.",
            "💬 Apply confidently — your voice matters.",
            "🎉 You’re qualified. Celebrate the chance.",
            "💖 Your passion shines — show them.",
            "🧠 Smart, driven, and ready to lead.",
            "📌 This could be your next adventure.",
            "📚 Every job teaches — what will you learn?",
            "💼 Time to upgrade your story.",
            "🧭 Trust your direction.",
            "🪄 Believe in your magic — apply now.",
            "🎯 A great match is one click away.",
            "🌟 Go where your skills are valued.",
            "🌈 This role may open new doors.",
            "✈️ Don’t just dream it — do it.",
            "🧗 Take the step. You’re ready.",
            "🎬 Time to take the lead role.",
            "⚡ Spark change with your ideas.",
            "📣 You bring the energy they need.",
            "💎 Your talent is rare — use it.",
            "🔍 This could be your perfect fit.",
            "🥇 Every win starts with an attempt.",
            "🌻 Let your growth bloom here.",
            "🏁 Why wait? Start your journey.",
            "🧳 Pack your strengths and go!",
            "🎵 This could be your rhythm.",
            "🏗️ Build your future brick by brick.",
            "🧩 You complete the puzzle.",
            "🕊️ Set your career free.",
            "🛎️ It’s your time to answer the call.",
            "🪴 Plant your potential here.",
            "🧬 You’re made for this.",
            "🌐 Let the world see your worth.",
            "💬 Every story needs a voice — yours.",
            "⚙️ The right role makes all the difference.",
            "📍 Find purpose in your path.",
            "🧠 Bring your best ideas forward.",
            "🎯 Aim high. You’re ready.",
            "🎓 This could be your real-world degree.",
            "🏄 Ride the wave — don't miss out."
        ];

        $random_tip = $encouragements[array_rand($encouragements)];
        $html .= "<div class='card-hover-tip'><span class='close-tip' onclick='this.parentElement.style.display=\"none\"' title='Dismiss tip'>✖</span>{$random_tip}</div>";

        $html .= "</div>"; // Close job-card
    }
    $html .= "</div>"; // Close jobs-grid
}

$xt->assign("external_jobs", $html);

// Handle AJAX refresh
if (postvalue("ajax_remote_jobs") == "1") {
    echo $xt->fetchVar("external_jobs");
    exit();
}




//____________________________________________________________________________________________________________

// 📊 Prepare chart data for User-Posted Jobs flip card
$user_active = DB::Lookup("SELECT COUNT(*) FROM jobsjobs WHERE COALESCE(extended_due_date, due_date) > CURDATE()");
$user_expired7 = DB::Lookup("
    SELECT COUNT(*) FROM jobsjobs
    WHERE COALESCE(extended_due_date, due_date) <= CURDATE()
      AND COALESCE(extended_due_date, due_date) >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)
");
$user_archived = DB::Lookup("
    SELECT COUNT(*) FROM jobsjobs
    WHERE COALESCE(extended_due_date, due_date) < DATE_SUB(CURDATE(), INTERVAL 7 DAY)
");

// Assign raw values for JS use
$xt->assign("user_active_raw", $user_active);
$xt->assign("user_expired7_raw", $user_expired7);
$xt->assign("user_archived_raw", $user_archived);

// Assign formatted values for HTML display
$xt->assign("user_active", number_format($user_active) . " Active");
$xt->assign("user_expired7", number_format($user_expired7) . " Expired (7d)");
$xt->assign("user_archived", number_format($user_archived) . " Archived");

;		
} // function BeforeShowList

				// Before display
function BeforeShowView(&$xt, &$templatefile, &$values, $pageObject)
{

		$stylename = "jobsjobs jobsjobs_view";
if(Security::isLoggedIn())	
	$stylename.=" LoggedIn";
$xt->assign("stylename",$stylename);

$_SESSION["Category"] = $values["Category"];
$_SESSION["Subcategory"] = $values["Subcategory"];
$_SESSION["Title"] = $values["Title"];
$_SESSION["Posted"] = $values["Posted"];
$_SESSION["Details"] = $values["Details"];
$_SESSION["Picture"] = $values["Picture"];
$_SESSION["userinfo"] = $values["UserID"];

$dataUser = Security::currentUserData();
$_SESSION["email"] = $dataUser["email"];
$_SESSION["name"] = $dataUser["fullname"];

$_SESSION["subject"] = $_SESSION["Title"];
$keys = $pageObject->keys;
$_SESSION["mess"]= projectUrl().GetTableLink("jobsjobs","view","editid1=".$keys["ID"]);

$xt->assign( "breadcrumbs", true );
$xt->assign( "breadcrumb", true );
$xt->assign("crumb_home_link",GetTableLink("jobsjobs","list"));

$breadcrumb = array();
$breadcrumb[0] = array("crumb_attrs" => "href='".GetTableLink("jobsjobs","list")."?page=list&f=(Category~equals~".rawurlencode($values["Category"]).")'" ,"crumb_title_link"=>true, "crumb_title"=> $values["Category"]);
$breadcrumb[1] = array("crumb_attrs" => "", "crumb_title_span" => true,"crumb_title" => $values["Title"]);
$xt->assign_loopsection("crumb", $breadcrumb);
;		
} // function BeforeShowView

// List page: Before process
function BeforeProcessList($pageObject)
{
		$pageObject->hideItem("grid_inline_edit"); 
// Place event code here.
// Use "Add Action" button to add code snippets.
;		
} // function BeforeProcessList
}
?>
