<?php
// Fixed jobsjobs_event.php with User-Posted Jobs integrated

class eventclass_jobsjobs extends eventsBase {
    function __construct() {
        $this->events["BeforeShowList"]=true;
        $this->events["BeforeShowView"]=true;
        $this->events["BeforeProcessList"]=true;
    }

    function BeforeShowList(&$xt, &$templatefile, $pageObject) {
        include_once("load_external_chart_data.php");
        include_once("merged_jobs_feed.php");

        $jobsBySource = fetchJobsBySource();
        $externalHtml = "";

        foreach ($jobsBySource as $source => $jobList) {
            if (empty($jobList)) continue;
            $sourceSlug = getSourceSlug($source);
            $externalHtml .= "<h3 id='section--{$sourceSlug}' style='text-align:center; margin-top:30px;'>🌍 " . htmlspecialchars($source) . "</h3>";
            $externalHtml .= "<div class='jobs-grid'>";
            foreach ($jobList as $job) {
                $sourceSlug = getSourceSlug($job['source']);
                $logoSlug = strtolower($sourceSlug);
                $cardClass = 'job-card card-logo-' . $logoSlug . ' tag-' . $logoSlug;

                $isExpired = false; $closingSoon = false; $formattedDate = ''; $daysRemaining = null;
                if (!empty($job['expiry_date'])) {
                    $rawDate = $job['expiry_date'];
                    if (is_numeric($rawDate)) {
                        if ($rawDate > 9999999999) $rawDate = $rawDate / 1000;
                        $formattedDate = date("d M Y", (int)$rawDate);
                        $daysRemaining = floor(($rawDate - time()) / 86400);
                        $closingSoon = $daysRemaining <= 7 && $daysRemaining > 0;
                        $isExpired = $daysRemaining < 0;
                    } else {
                        $formattedDate = htmlspecialchars($rawDate);
                    }
                }
                if ($isExpired) $cardClass .= " expired-card";

                $externalHtml .= "<div class='{$cardClass}'>";
                $externalHtml .= "<h3>" . htmlspecialchars($job['title']) . "</h3>";
                $externalHtml .= "<p><strong>Employer:</strong> " . htmlspecialchars($job['company']) . "</p>";
                $externalHtml .= "<p><strong>Type:</strong> " . htmlspecialchars($job['type']) . "</p>";
                $externalHtml .= "<p><strong>Location:</strong> " . htmlspecialchars($job['location']) . "</p>";
                $externalHtml .= "<p><strong>Expires:</strong> {$formattedDate}</p>";
                $externalHtml .= "<p>" . nl2br(htmlspecialchars($job['excerpt_full'])) . "</p>";
                $externalHtml .= "<a class='view-job-btn' href='track_remote_click.php?url=" . urlencode($job['url']) . "' target='_blank'>View Job</a>";
                $externalHtml .= "</div>";
            }
            $externalHtml .= "</div>";
        }
        $xt->assign("external_jobs", $externalHtml);

        // Local user-posted jobs
        $localJobs = DB::Select("SELECT ID, Title, Details, Posted, Category, Subcategory, COALESCE(extended_due_date, due_date) AS ExpiryDate FROM jobsjobs ORDER BY Posted DESC");
        $userHtml = "";
        if ($localJobs) {
            $userHtml .= "<h3 style='text-align:center; margin-top:30px;'>👥 User-Posted Jobs</h3>";
            $userHtml .= "<div class='jobs-grid'>";
            foreach ($localJobs as $job) {
                $isExpired = strtotime($job["ExpiryDate"]) < time();
                $cardClass = "job-card card-user" . ($isExpired ? " expired-card" : "");
                $userHtml .= "<div class='{$cardClass}'>";
                $userHtml .= "<h3>" . htmlspecialchars($job["Title"]) . "</h3>";
                $userHtml .= "<p><strong>Category:</strong> " . htmlspecialchars($job["Category"]) . "</p>";
                $userHtml .= "<p><strong>Subcategory:</strong> " . htmlspecialchars($job["Subcategory"]) . "</p>";
                $userHtml .= "<p><strong>Posted:</strong> " . htmlspecialchars($job["Posted"]) . "</p>";
                $userHtml .= "<p><strong>Expires:</strong> " . htmlspecialchars($job["ExpiryDate"]) . "</p>";
                $userHtml .= "<p>" . nl2br(htmlspecialchars($job["Details"])) . "</p>";
                $userHtml .= "<a class='view-job-btn' href='jobsjobs_view.php?editid1=" . $job["ID"] . "'>View Job</a>";
                $userHtml .= "</div>";
            }
            $userHtml .= "</div>";
        } else {
            $userHtml .= "<div class='no-local-jobs'>No user-posted jobs available.</div>";
        }
        $xt->assign("job_cards", $userHtml);

        // Chart counts
        $user_active = DB::Lookup("SELECT COUNT(*) FROM jobsjobs WHERE COALESCE(extended_due_date, due_date) > CURDATE()");
        $user_expired7 = DB::Lookup("SELECT COUNT(*) FROM jobsjobs WHERE COALESCE(extended_due_date, due_date) <= CURDATE() AND COALESCE(extended_due_date, due_date) >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)");
        $user_archived = DB::Lookup("SELECT COUNT(*) FROM jobsjobs WHERE COALESCE(extended_due_date, due_date) < DATE_SUB(CURDATE(), INTERVAL 7 DAY)");
        $xt->assign("user_active_raw", $user_active);
        $xt->assign("user_expired7_raw", $user_expired7);
        $xt->assign("user_archived_raw", $user_archived);
        $xt->assign("user_active", number_format($user_active) . " Active");
        $xt->assign("user_expired7", number_format($user_expired7) . " Expired (7d)");
        $xt->assign("user_archived", number_format($user_archived) . " Archived");
    }
}
?>