<?php
require_once 'db_connect.php';
$interval_minutes = 5;
$client_code = 'bitsolution';

$sql = "SELECT id, username, fullname FROM sso_users 
        WHERE client_code=? AND is_active=1 AND last_active > (NOW() - INTERVAL ? MINUTE)";

$stmt = $conn->prepare($sql);
$stmt->bind_param("si", $client_code, $interval_minutes);
$stmt->execute();
$result = $stmt->get_result();

$admins = [];
while($row = $result->fetch_assoc()){
    $admins[] = $row;
}
header('Content-Type: application/json');
echo json_encode($admins);
