<?php
include("include/dbcommon.php");

function saveJob($title, $link, $description, $pub_date, $source) {
    $title = db_prepare_string($title);
    $link = db_prepare_string($link);
    $description = db_prepare_string(strip_tags($description));
    $pub_date = db_prepare_string($pub_date);
    $source = db_prepare_string($source);

    $check = DBLookup("SELECT COUNT(*) FROM remote_jobs WHERE link = $link");
    if ($check == 0) {
        DB::Exec("INSERT INTO remote_jobs (title, link, description, pub_date, source)
                  VALUES ($title, $link, $description, $pub_date, $source)");
    }
}

// UNDP
$xml = simplexml_load_file("https://jobs.undp.org/rss/");
foreach ($xml->channel->item as $item) {
    saveJob((string)$item->title, (string)$item->link, (string)$item->description, date('Y-m-d H:i:s', strtotime((string)$item->pubDate)), 'UNDP');
}

// SPREP
function fetch_sprep() {
    $html = file_get_contents("https://www.sprep.org/career-opportunities");
    preg_match_all('/<a href="(\/att\/.*?)">(.*?)<\/a>/i', $html, $matches, PREG_SET_ORDER);
    foreach ($matches as $match) {
        $link = "https://www.sprep.org" . $match[1];
        $title = strip_tags($match[2]);
        saveJob($title, $link, "PDF job listing from SPREP", date('Y-m-d'), 'SPREP');
    }
}

// SPC
function fetch_spc() {
    $html = file_get_contents("https://careers.spc.int");
    preg_match_all('/<a href="(\/.*?\/job\/.*?)">(.*?)<\/a>/i', $html, $matches, PREG_SET_ORDER);
    foreach ($matches as $match) {
        $link = "https://careers.spc.int" . $match[1];
        $title = strip_tags($match[2]);
        saveJob($title, $link, "SPC Job Listing", date('Y-m-d'), 'SPC');
    }
}

// Himalayas
function fetch_himalayas() {
    $html = file_get_contents("https://himalayas.app/jobs");
    preg_match_all('/<a class=".*?" href="(\/jobs\/[^"]+)">(.+?)<\/a>/', $html, $matches, PREG_SET_ORDER);
    foreach ($matches as $match) {
        $link = "https://himalayas.app" . $match[1];
        $title = strip_tags($match[2]);
        saveJob($title, $link, "Remote job from Himalayas", date('Y-m-d'), 'Himalayas');
    }
}

fetch_sprep();
fetch_spc();
fetch_himalayas();

echo "✅ All jobs fetched.";
?>
