<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_name('pbitsol_session');
session_set_cookie_params([
    'lifetime' => 0,
    'path' => '/',
    'secure' => isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on',
    'httponly' => true,
    'samesite' => 'Lax'
]);
session_start();
require_once('db_connect.php');

$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $password = $_POST['password'];
    $client_code = isset($_POST['client_code']) ? $_POST['client_code'] : '';

    $client_redirects = [
        'lta' => '/lta_mis/menu.php',
        'mwti' => '/mwti/menu.php',
        'fisheries' => '/fisheries/menu.php',
        'fesa' => '/fesa/menu.php',
        'sports' => '/sports/menu.php',
        'sta' => '/sta/menu.php',
        'mwti-bitsol' => '/mwti_sso/menu.php'
    ];

    if (!$client_code || !isset($client_redirects[$client_code])) {
        $error = "Please select a valid client.";
    } else {
        // Query sso_users table for selected client
        $stmt = $conn->prepare("SELECT * FROM sso_users WHERE client_code=? AND username=? AND is_active=1");
        $stmt->bind_param("ss", $client_code, $username);
        $stmt->execute();
        $result = $stmt->get_result();
        $user = $result->fetch_assoc();

        if ($user && password_verify($password, $user['password'])) {
            session_regenerate_id(true);
            $_SESSION['user_id'] = $user['client_user_id'];
            $_SESSION['username'] = $username;
            $_SESSION['client_code'] = $client_code;
            $_SESSION['sso_logged_in'] = true;

            // Place redirect here, after user is validated
            if ($client_code == 'mwti-bitsol') {
                header("Location: " . $client_redirects[$client_code] . "?sso_email=" . urlencode($user['email']));
            } else {
                header("Location: " . $client_redirects[$client_code]);
            }
            exit();
        } else {
            $error = "Invalid username or password";
        }
    }
}
?>
<!-- your HTML here -->



<!DOCTYPE html>
<html lang="en">
<head>
    <title>Bitsolution Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body {
            font-family: 'Segoe UI', Arial, sans-serif;
            background: #f4f7fa;
            min-height: 100vh;
            margin: 0;
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        .header-block {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-top: 1.5em;
            margin-bottom: 0.3em;
        }
        .logo {
            width: 100px;
            margin-bottom: 0.1em;
        }
        .company-name {
            font-size: 2em;
            color: #0288d1;
            font-weight: bold;
            margin-bottom: 0.3em;
            text-align: center;
        }
		
		#hideLoginBtn, #showLoginBtn {
    margin: 8px auto 12px auto;
    min-width: 120px;
    font-size: 1.1em;
    padding: 12px 28px;
    border-radius: 8px;
    border: none;
    background: #0288d1;
    color: #fff;
    box-shadow: 0 2px 12px #aaa;
    cursor: pointer;
    transition: background 0.15s;
	display: block;
}
#hideLoginBtn:hover, #showLoginBtn:hover {
    background: #026fa4;
}
@media (max-width: 600px) {
    #hideLoginBtn, #showLoginBtn {
        width: 98vw;
        padding: 12px 4vw;
        font-size: 1em;
    }
}
		

        .login-box {
            position: relative;
			padding-top: 2.2em;
			background: white;
            padding: 2em 3em;
            border-radius: 15px;
            box-shadow: 0 2px 24px #aaa;
            max-width: 340px;
            width: 100%;
            margin-bottom: 2em;
            display: flex;
            flex-direction: column;
            align-items: center;
			
        }
        .login-box form {
            width: 100%;
        }
        .login-box input[type="text"],
        .login-box input[type="password"],
        .login-box select {
            width: 100%;
            padding: 10px;
            margin-bottom: 1em;
            border: 1px solid #ccc;
            border-radius: 8px;
            font-size: 16px;
            box-sizing: border-box;
        }
        .login-box button {
            width: 100%;
            background: #0288d1;
            color: white;
            border: none;
            padding: 12px 0;
            border-radius: 8px;
            font-size: 16px;
            cursor: pointer;
        }
        .login-box button:hover {
            background: #026fa4;
        }
		
		
.login-close {
     position: absolute;
    top: 0.6em;       /* aligns with the top padding of .login-box */
    right: 1em;       /* aligns with the right padding of .login-box */
    font-size: 1em;
    background: none !important;
    border: none !important;
    color: #888 !important;
    cursor: pointer;
    z-index: 2;
    padding: 0 8px;
    line-height: 1.2;
    width: auto;
    height: auto;
    border-radius: 0 !important;
    box-shadow: none !important;
    display: flex;
    align-items: center;
    gap: 6px;
}


.login-close-caption {
    font-size: 1em;
    color: #555;
    margin-left: 2px;
    font-weight: 400;
    letter-spacing: 0.02em;
    user-select: none;
}

	@media (max-width: 450px) {
  .login-close-caption {
    display: none;
  }
}


@media (max-width: 600px) {
  .login-close-caption {
    display: none;
  }
}

@media (max-width: 500px) {
  .login-close-caption {
    display: none;
  }
}

		
.login-close:hover,
.login-close:focus {
    color: #d32f2f !important;
}
.login-close:hover .login-close-caption,
.login-close:focus .login-close-caption {
    color: #d32f2f;
}	
        .error {
            color: #b71c1c;
            background: #ffcdd2;
            padding: 0.5em 1em;
            border-radius: 6px;
            margin-bottom: 1em;
            text-align: center;
        }
        .about-box {
            background: #fff;
            padding: 1.3em 2em;
            border-radius: 16px;
            box-shadow: 0 1px 8px #e0e0e0;
            max-width: 900px;
            margin: 0.8em auto 1em auto;
            font-size: 16px;
            color: #222;
            text-align: justify;
            line-height: 1.7;
        }
        .about-box strong {
            color: #026fa4;
        }
        footer.about-box {
            margin-top: 0;
            margin-bottom: 2em;
        }
        @media (max-width: 500px) {
            .about-box {
                padding: 1em 0.7em;
                font-size: 15px;
            }
            .login-box {
                padding: 1em 0.7em;
                max-width: 97vw;
				position: relative;
				
            }
        }
		
		body {
			position: relative;
			overflow-x: hidden;
			}

		/* Faded, moving tech SVG background */
		.tech-bg {
			position: fixed;
			top: 0; left: 0;
			width: 100vw;
			height: 100vh;
			z-index: 0;
			background: transparent;
			pointer-events: none;
		}
		.tech-bg::before {
			content: '';
			position: absolute;
			width: 100vw;
			height: 100vh;
			opacity: 0.01; /* control fade */
			background: url('data:image/svg+xml;utf8,<svg width="1000" height="1000" xmlns="http://www.w3.org/2000/svg"><g stroke="%23028ad1" stroke-width="2" opacity="0.4"><line x1="0" y1="50" x2="1000" y2="50"/><line x1="0" y1="200" x2="1000" y2="200"/><line x1="0" y1="350" x2="1000" y2="350"/><line x1="0" y1="500" x2="1000" y2="500"/><line x1="0" y1="650" x2="1000" y2="650"/><line x1="0" y1="800" x2="1000" y2="800"/><circle cx="700" cy="150" r="24" fill="none"/><rect x="200" y="700" width="60" height="60" fill="none"/></g></svg>');
			background-size: cover;
			animation: bg-move 20s linear infinite;
		}

		@keyframes bg-move {
			0% { background-position: 0 0;}
			100% { background-position: 100px 100px;}
		}

		#matrix-bg {
			position: fixed;
			top: 0; left: 0;
			width: 100vw;
			height: 100vh;
			z-index: 0;
			opacity: 0.08; /* Adjust for more/less fade */
			pointer-events: none;
		}
		
		.content-container {
			position: relative;
			z-index: 1;
			width: 100%;
			display: flex;
			flex-direction: column;
			align-items: center;
		}

.preview-link {
    color: #1a0dab;
    text-decoration: underline;
    cursor: pointer;
    transition: color 0.2s;
}
.preview-link:hover {
    color: #d32f2f;
}

.preview-popup {
    display: none;
    position: absolute;
    z-index: 1000;
	background: #fff;
    border: 1px solid #ddd;
    box-shadow: 0 8px 32px rgba(0,0,0,0.18);
    padding: 1.3em 1.3em 1.3em 1.3em;
    max-width: 420px;
    border-radius: 16px;
    font-size: 1em;
    color: #222;
    overflow: auto;
    max-height: 350px;
    animation: fadeInPopup 0.32s cubic-bezier(0.36, 0.66, 0.04, 1) both;
    transition: box-shadow 0.2s;
}

@keyframes fadeInPopup {
    0% {
        opacity: 0;
        transform: translateY(20px) scale(0.97);
    }
    100% {
        opacity: 1;
        transform: translateY(0) scale(1);
    }
}

.preview-popup.hide {
    animation: fadeOutPopup 0.22s cubic-bezier(0.36, 0.66, 0.04, 1) both;
}

@keyframes fadeOutPopup {
    to {
        opacity: 0;
        transform: translateY(20px) scale(0.96);
    }
}

.preview-popup .popup-close {
    position: absolute;
    top: 7px;
    right: 9px;
    font-size: 1.3em;
    background: none;
    border: none;
    color: #888;
    cursor: pointer;
    transition: color 0.2s;
    z-index: 2;
    padding: 0;
}
.preview-popup .popup-close:hover {
    color: #d32f2f;
}

.preview-popup a {
    color: #0074cc;
    text-decoration: underline;
}

.client-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 0.8em 1.2em;
    margin-top: 0.7em;
}
.client-card {
    display: flex;
    align-items: center;
    gap: 0.6em;
    padding: 0.3em 0;
    font-size: 1em;
}
.client-icon {
    font-size: 1.3em;
}

@media (max-width: 600px) {
    .preview-popup {
        left: 50% !important;
        top: 50% !important;
        transform: translate(-50%, -50%) !important;
        width: 94vw !important;
        max-width: 96vw !important;
        min-width: 88vw !important;
        max-height: 70vh !important;
        min-height: 30vh !important;
        font-size: 1.13em !important;
        padding: 1.5em 1.1em 1.1em 1.1em !important;
        box-sizing: border-box !important;
    }
    .donor-tooltip {
        left: 50% !important;
        top: 50% !important;
        transform: translate(-50%, -50%) !important;
        width: 92vw !important;
        max-width: 97vw !important;
        min-width: 82vw !important;
        max-height: 60vh !important;
        min-height: 22vh !important;
        font-size: 1.13em !important;
        padding: 1.4em 1.1em 1.1em 1.1em !important;
        box-sizing: border-box !important;
        overflow-y: auto !important;
    }
    .donor-tooltip .donor-tooltip-close {
        top: 10px !important;
        right: 14px !important;
        font-size: 1.6em !important;
    }
    .client-grid {
        grid-template-columns: 1fr;
    }
}


/* Custom Scrollbar for preview-popup */
.preview-popup::-webkit-scrollbar {
    width: 10px;
}
.preview-popup::-webkit-scrollbar-thumb {
    background: #e1e1e1;
    border-radius: 8px;
}
.preview-popup::-webkit-scrollbar-track {
    background: #f6f6f6;
    border-radius: 8px;
}
.preview-popup:hover::-webkit-scrollbar-thumb {
    background: #bbb;
}

.donor-tooltip {
    display: none;
    position: absolute;
    background: #f9fafb;
    border: 1px solid #d2d6dc;
    box-shadow: 0 2px 14px rgba(0,0,0,0.11);
    padding: 0.9em 1.2em;
    border-radius: 10px;
    font-size: 0.98em;
    color: #232323;
    z-index: 2000;
    max-width: 280px;
    transition: opacity 0.17s;
    pointer-events: none;
}
.donor-tooltip strong {
    color: #1252c4;
    font-size: 1.04em;
}
.donor-tooltip a {
    color: #0080ff;
    text-decoration: underline;
    font-weight: 600;
    font-size: 0.97em;
}

.donor-modal {
    display: none;
    position: fixed;
    z-index: 2500;
    left: 0;
    top: 0;
    width: 100vw;
    height: 100vh;
    background: rgba(20,22,33,0.49);
    align-items: center;
    justify-content: center;
    animation: fadeInModal 0.21s;
}
@keyframes fadeInModal {
    from { opacity: 0;}
    to   { opacity: 1;}
}
.donor-modal-content {
    background: #fff;
    padding: 1em 1em 0.5em 1em;
    border-radius: 14px;
    max-width: 800px;
    width: 97vw;
    max-height: 86vh;
    box-shadow: 0 8px 32px rgba(0,0,0,0.22);
    position: relative;
    display: flex;
    flex-direction: column;
    animation: popupModalUp 0.33s;
}
@keyframes popupModalUp {
    from { transform: translateY(60px) scale(0.96);}
    to   { transform: translateY(0) scale(1);}
}
.donor-modal-header {
    font-size: 1.17em;
    font-weight: bold;
    margin-bottom: 0.4em;
    color: #225dc2;
}
.donor-modal-close {
    position: absolute;
    top: 10px;
    right: 16px;
    font-size: 2em;
    background: none;
    border: none;
    color: #888;
    cursor: pointer;
    z-index: 2;
    transition: color 0.18s;
}
.donor-modal-close:hover {
    color: #d32f2f;
}
.donor-modal-iframe {
    width: 100%;
    height: 65vh;
    border: none;
    background: #fcfcfc;
    border-radius: 8px;
    margin-bottom: 0.6em;
}


.donor-tooltip {
    display: none;
    position: absolute;
    background: #f9fafb;
    border: 1px solid #d2d6dc;
    box-shadow: 0 2px 14px rgba(0,0,0,0.11);
    padding: 0.9em 1.2em 1em 1.2em;
    border-radius: 10px;
    font-size: 0.98em;
    color: #232323;
    z-index: 2000;
    max-width: 280px;
    transition: opacity 0.17s;
    pointer-events: auto;
}

.donor-tooltip strong {
    color: #1252c4;
    font-size: 1.04em;
}

.donor-tooltip a {
    color: #0080ff;
    text-decoration: underline;
    font-weight: 600;
    font-size: 0.97em;
}

/* Tooltip Close Icon */
.donor-tooltip-close {
    position: absolute;
    top: 6px;
    right: 10px;
    font-size: 1.23em;
    color: #888;
    background: none;
    border: none;
    cursor: pointer;
    transition: color 0.19s;
    z-index: 2;
}
.donor-tooltip-close:hover {
    color: #d32f2f;
}

.modal-fallback {
    padding: 1.5em 1em 2em 1em;
    text-align: center;
}
.modal-fallback a.visit-in-new-tab {
    display: inline-block;
    margin-top: 0.9em;
    padding: 0.5em 1.3em;
    border-radius: 5px;
    background: #1752c4;
    color: #fff;
    text-decoration: none;
    font-weight: 600;
    transition: background 0.18s;
}
.modal-fallback a.visit-in-new-tab:hover {
    background: #d32f2f;
}

.modal-fallback {
    padding: 1.5em 1em 2em 1em;
    text-align: center;
}
.modal-fallback a.visit-in-new-tab {
    display: inline-block;
    margin-top: 0.9em;
    padding: 0.5em 1.3em;
    border-radius: 5px;
    background: #1752c4;
    color: #fff;
    text-decoration: none;
    font-weight: 600;
    transition: background 0.18s;
}
.modal-fallback a.visit-in-new-tab:hover {
    background: #d32f2f;
}


    </style>
</head>
<body>

<canvas id="matrix-bg"></canvas>
<div class="content-container">

<!--<div class="tech-bg"></div>  -->

<!-- HEADER: Logo and Company Name -->
<div class="header-block">
    <img src="/logo3.png" alt="Bitsolution Logo" class="logo" />
    <div class="company-name">Bitsolution</div>
</div>

<!-- Button Container -Hide and Show Login Form -->
<div id="loginToggleBtns" style="text-align:center; margin-bottom:24px;">
  <button id="hideLoginBtn"
    style="display:inline-block;padding:12px 28px;font-size:1.1em;background:#0288d1;color:#fff;border-radius:8px;border:none;box-shadow:0 2px 12px #aaa;cursor:pointer;">
    Hide Login
  </button>
  <button id="showLoginBtn"
    style="display:none;padding:12px 28px;font-size:1.1em;background:#0288d1;color:#fff;border-radius:8px;border:none;box-shadow:0 2px 12px #aaa;cursor:pointer;">
    Show Login
  </button>
</div>


<!-- LOGIN BLOCK -->
<div class="login-box" id="loginBox">
    <?php if (isset($error) && $error): ?>
        <div class="error" aria-live="polite"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>
    <form method="post" autocomplete="off">
        <label for="client_code">Select Client</label>
        <select name="client_code" id="client_code" required>
            <option value="">-- Select Client --</option>
            <option value="cdp">Central Dental Practice</option>
            <option value="fesa">Fire and Emergency Services Authority</option>
            <option value="samoa-golf">Golf Tournament System (Software)</option>
            <option value="lta">Land Transport Authority</option>
            <option value="mcil">Ministry of Commerce, Industry and Labour</option>
            <option value="mop">Ministry of Police</option>
            <option value="mwti">Ministry of Works, Transport and Infrastructure</option>
            <option value="spcs">Prisons & Corrections Services</option>
            <option value="pto">Public Trust Office</option>
            <option value="sbs">Samoa Bureau of Statistics</option>
            <option value="sss">Samoa Shipping Services</option>
            <option value="ssab">Samoa Stationary and Books</option>
            <option value="sta">Samoa Tourism Authority</option>
            <option value="sports">Sports Management System (Software)</option>
            <option value="tuvalu-fisheries">Tuvalu - Ministry of Fisheries</option>
			<option value="mwti-bitsol">Z-Bitsol Control</option>
        </select>
        <label for="username">Username</label>
        <input type="text" id="username" name="username" placeholder="Username" required autofocus>
        <label for="password">Password</label>
        <input type="password" id="password" name="password" placeholder="Password" required>
        <button type="submit">Sign In</button>
	</form>	
</div>




<!-- ABOUT US AND CONTACT INFO -->
<div class="about-box">
    <p>
        <strong>About Us:</strong> <div id="since-founded" style="font-weight:bold; color:#0288d1; margin-bottom:10px;"></div> 
		<span class="preview-link"
		tabindex="0"
      role="link"
      data-preview-title="Bitsolution Main Office"
      data-preview-text="Level 2, Room #30.<br> Wesley Bookshop<br>Apia, Samoa."
	  data-preview-link="https://www.google.com/maps/place/Wesley+Bookshop/@-13.8162243,-171.8410697,22558m/data=!3m1!1e3!4m10!1m2!2m1!1swesley+arcade+samoa!3m6!1s0x71a5139ad0c9380b:0xa0012a4d5e1ef5c4!8m2!3d-13.8314496!4d-171.767086!15sChN3ZXNsZXkgYXJjYWRlIHNhbW9hWhUiE3dlc2xleSBhcmNhZGUgc2Ftb2GSAQpib29rX3N0b3JlmgEkQ2hkRFNVaE5NRzluUzBWSlEwRm5TVU5pY3paeFlqaEJSUkFCqgFPEAEqESINd2VzbGV5IGFyY2FkZSgAMh8QASIbKN3gaZlHdIkJphYp88lTClNxWmdYBuN8XouPMhcQAiITd2VzbGV5IGFyY2FkZSBzYW1vYeABAPoBBAh8EEk!16s%2Fg%2F1td1q1_8?entry=ttu&g_ep=EgoyMDI1MDUxNS4wIKXMDSoJLDEwMjExNDU1SAFQAw%3D%3D">
    Bitsolution</span> is a locally owned Information Technology Consulting Firm specialising in serving mid-tier businesses, non-profit organisations, and government agencies across Samoa. Our expertise extends 
to designing, developing, and supporting ICT solutions for both local and regional clients in the Pacific.
    </p>
    <p>
        Bitsolution offers a comprehensive range of IT consulting services, utilising industry-proven methodologies to deliver practical, 
		world-class results. We have a strong track record of leading and implementing large, complex ICT 
		projects funded by major international donors and programs,
		including the United Nations Development Programme 
   <a href="#" class="donor-preview"
   data-preview-title="UNDP"
   data-preview-url="https://www.undp.org/samoa/about-us-0"
   data-preview-text="The Apia based UNDP office which was officially set up on 1st July 1979 covers four Pacific Island Countries (Cook Islands, Niue, Samoa and Tokelau) in the South Pacific Polynesian sub-region. The UNDP Multi-Country Office aims to “make a difference in Pacific people’s lives” by supporting countries to accelerate progress on human development.">
   (UNDP)</a>
   Secretariat of the Pacific Regional Environment Programme 
   <a href="#" class="donor-preview"
   data-preview-title="SPREP"
   data-preview-url="https://www.sprep.org/governance"
   data-preview-text="SPREP began life in the late 1970s as a joint initiative of SPC, SPEC, ESCAP and UNEP - eventually functioning as a component of UNEP's Regional Seas Programme. The Programme received further impetus as a result of the 1982 Conference on the Human Environment in the South Pacific. Following a period of expansion and long deliberations, SPREP left SPC in Noumea in 1992 and relocated to Samoa.">
   (SPREP)</a>, International Labour Organization 	
	<a href="#" class="donor-preview"
   data-preview-title="International Labour Organization (ILO)"
   data-preview-url="https://www.ilo.org/"
   data-preview-text="The International Labour Organization (ILO) is a United Nations agency focused on labor standards, social protection, and work opportunities for all.">
   (ILO)</a>,Pacific Regional Oceanscape Program for Economic Resilience
   <a href="#" class="donor-preview"
   data-preview-title="Pacific Regional Oceanscape Program for Economic Resilience"
   data-preview-url="https://norma.fm/pacific-islands-regional-oceanscape-program-prop/"
   data-preview-text="Through the Pacific Islands Regional Oceanscape Program (PROP), the World Bank is working closely with Pacific governments, regional organizations and communities to help countries improve their sustainable management of ocean fisheries, coastal fisheries and to strengthen institutions responsible for conservation. ">
   (PROPER)</a>,
   <a href="#" class="donor-preview"
   data-preview-title="World Bank"
   data-preview-url="https://www.worldbank.org/ext/en/who-we-are"
   data-preview-text="We exist to create a world free of poverty on a livable planet.. Our mission is to end extreme poverty and boost shared prosperity on a livable planet. This is threatened by multiple, intertwined crises. Time is of the essence.">
   World Bank</a>, and the Trade Facilitation Support Program 
   <a href="#" class="donor-preview"
   data-preview-title="World Bank"
   data-preview-url="https://www.worldbank.org/en/programs/trade-facilitation-support-program"
   data-preview-text="The Trade Facilitation Support Program (TFSP) was launched in June 2014 to help countries improve their cross-border trade environments and align their trade practices with the World Trade Organization Trade Facilitation Agreement (WTO TFA).
TFSP’s funding assists countries—particularly developing countries—achieve the full and effective implementation of the WTO TFA measures and related trade facilitation reforms.">
   (TFSP)</a>.

<br><br>In addition to our international partners, Bitsolution proudly provides ongoing IT consulting services for a diverse range of clients across 


<span class="preview-link"
      tabindex="0"
      role="link"
      data-preview-title="Our Clients in Samoa"
      data-preview-html="
        <div class='client-grid'>
          <div class='client-card'>
            <span class='client-icon'>🏥</span><a href='https://bitsolution.ws/cdp' target='_blank'>Central Dental Practice</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>🚒</span><a href='https://www.sfesa.ws/' target='_blank'>Fire and Emergency Services Authority</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>⛳</span><a href='https://bitsolution.ws/cdp' target='_blank'>Golf Tournament System</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>🚗</span><a href='https://lta.gov.ws/' target='_blank'>Land Transport Authority</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>🏢</span><a href='http://mcil.gov.ws/' target='_blank'>Ministry of Commerce, Industry and Labour - Jobseeker</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>👮</span><a href='https://www.samoapolice.ws/' target='_blank'>Ministry of Police</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>🛣️</span><a href='https://www.mwti.gov.ws/' target='_blank'>Ministry of Works, Transport and Infrastructure</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>🔒</span><a href='https://www.samoapolice.ws/' target='_blank'>Prisons & Corrections Services</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>📜</span><a href='https://publictrust.ws/' target='_blank'>Public Trust Office</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>📊</span><a href='https://www.sbs.gov.ws/' target='_blank'>Samoa Bureau of Statistics</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>🚢</span><a href='https://www.sssltd.ws/' target='_blank'>Samoa Shipping Services</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>📚</span><a href='https://ssab.ws/' target='_blank'>Samoa Stationary and Books</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>🏝️</span><a href='https://www.samoa.travel/' target='_blank'>Samoa Tourism Authority</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>⚽</span><a href='https://bitsolution.ws/cdp' target='_blank'>Sports Management System</a>
          </div>
         </div>
      ">
    Samoa
</span> and the 


<span class="preview-link"
      tabindex="0"
      role="link"
      data-preview-title="Our Client in the Region (Tuvalu)"
      data-preview-html="
        <div class='client-grid'>
          <div class='client-card'>
            <span class='client-icon'>🐟</span><a href='https://tuvalufisheries.tv/' target='_blank'>Tuvalu Government - Ministry of Fisheries and Trade</a>
          </div>
        </div>
      ">
Region, </span> 

including 

<span class="preview-link"
      tabindex="0"
      role="link"
      data-preview-title="Samoan Government Ministries Clients"
      data-preview-html="
        <div class='client-grid'>
          
          <div class='client-card'>
            <span class='client-icon'>🚒</span><a href='https://www.sfesa.ws/' target='_blank'>Fire and Emergency Services Authority</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>🏢</span><a href='http://mcil.gov.ws/' target='_blank'>Ministry of Commerce, Industry and Labour - Jobseeker</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>👮</span><a href='https://www.samoapolice.ws/' target='_blank'>Ministry of Police</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>🛣️</span><a href='https://www.mwti.gov.ws/' target='_blank'>Ministry of Works, Transport and Infrastructure</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>🔒</span><a href='https://www.samoapolice.ws/' target='_blank'>Prisons & Corrections Services</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>📊</span><a href='https://www.sbs.gov.ws/' target='_blank'>Samoa Bureau of Statistics</a>
          </div>
         </div>
      ">
    Ministries</span>,
	
<span class="preview-link"
      tabindex="0"
      role="link"
      data-preview-title="Samoan Government Corporations Clients"
      data-preview-html="
        <div class='client-grid'>
          <div class='client-card'>
            <span class='client-icon'>🚗</span><a href='https://lta.gov.ws/' target='_blank'>Land Transport Authority</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>📜</span><a href='https://publictrust.ws/' target='_blank'>Public Trust Office</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>🚢</span><a href='https://www.sssltd.ws/' target='_blank'>Samoa Shipping Services</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>🏝️</span><a href='https://www.samoa.travel/' target='_blank'>Samoa Tourism Authority</a>
          </div>
        </div>
      ">
    Corporations</span> and 


<span class="preview-link"
      tabindex="0"
      role="link"
      data-preview-title="Our Clients"
      data-preview-html="
        <div class='client-grid'>
          <div class='client-card'>
            <span class='client-icon'>🏥</span><a href='https://bitsolution.ws/cdp' target='_blank'>Central Dental Practice</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>📚</span><a href='https://ssab.ws/' target='_blank'>Samoa Stationary and Books</a>
          </div>
          <div class='client-card'>
            <span class='client-icon'>⚽</span><a href='https://bitsolution.ws/cdp' target='_blank'>Sports Management System</a>
          </div>
          </div>
      ">
Private Businesses.</span> 

We deliver innovative solutions that support digital transformation and improve operational efficiency for organisations throughout both the public and private sectors.
    </p>
    <p>
        Our successful partnerships with these clients underscore our commitment to quality and innovation, helping them achieve their digital transformation goals. Backed by a team with over 30 years of combined experience, Bitsolution has delivered enterprise system platforms and robust network infrastructures for organisations across Samoa and the Pacific region.
    </p>
    <p>
        At Bitsolution, we are dedicated to delivering exceptional value and sustainable ICT solutions tailored to
		


    our clients’ unique needs.
    </p>
    <div style="font-family: Arial, sans-serif; font-size: 16px;">
        <p>
            For further information or enquiries, please feel free to contact us via email or by phone:
        </p>
        <ul style="list-style-type: none; padding-left: 0;">
            <li><strong>Samoa:</strong> +685 7286825</li>
            <li><strong>New Zealand:</strong> +64 27 728 6825</li>
            <li><strong>Email:</strong> <a href="mailto:info@bitsolution.ws?cc=pelenato@gmail.com,pelenato@bitsolution.ws&subject=Bitsolution%20-%20Queries%20and%20Information">
            info@bitsolution.ws
        </a>
		<li><strong>Main Office:</strong> 
		

		<span class="preview-link"
		tabindex="0"
      role="link"
      data-preview-title="Bitsolution Main Office"
      data-preview-text="Level 2, Room #30.<br> Wesley Bookshop<br>Apia, Samoa."
	  data-preview-link="https://www.google.com/maps/place/Wesley+Bookshop/@-13.8162243,-171.8410697,22558m/data=!3m1!1e3!4m10!1m2!2m1!1swesley+arcade+samoa!3m6!1s0x71a5139ad0c9380b:0xa0012a4d5e1ef5c4!8m2!3d-13.8314496!4d-171.767086!15sChN3ZXNsZXkgYXJjYWRlIHNhbW9hWhUiE3dlc2xleSBhcmNhZGUgc2Ftb2GSAQpib29rX3N0b3JlmgEkQ2hkRFNVaE5NRzluUzBWSlEwRm5TVU5pY3paeFlqaEJSUkFCqgFPEAEqESINd2VzbGV5IGFyY2FkZSgAMh8QASIbKN3gaZlHdIkJphYp88lTClNxWmdYBuN8XouPMhcQAiITd2VzbGV5IGFyY2FkZSBzYW1vYeABAPoBBAh8EEk!16s%2Fg%2F1td1q1_8?entry=ttu&g_ep=EgoyMDI1MDUxNS4wIKXMDSoJLDEwMjExNDU1SAFQAw%3D%3D">
    
		
		Wesley Arcade Building, Level 2, Room #30</span> </li>
        </ul>
    </div>
</div>
</div>
<script>
// Matrix code background
const canvas = document.getElementById('matrix-bg');
const ctx = canvas.getContext('2d');
let w = canvas.width = window.innerWidth;
let h = canvas.height = window.innerHeight;
const letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789@#$%^&*";
const fontSize = 18;
const columns = Math.floor(w / fontSize);
const drops = Array(columns).fill(1);

function drawMatrix() {
    ctx.fillStyle = "rgba(0,0,0,0.30)";
    ctx.fillRect(0, 0, w, h);

    ctx.font = fontSize + "px monospace";
    ctx.fillStyle = "#00ff57";
    for (let i = 0; i < drops.length; i++) {
        const text = letters.charAt(Math.floor(Math.random() * letters.length));
        ctx.fillText(text, i * fontSize, drops[i] * fontSize);

        if (drops[i] * fontSize > h && Math.random() > 0.975) drops[i] = 0;
        drops[i]++;
    }
}

setInterval(drawMatrix, 140);

window.addEventListener('resize', () => {
    w = canvas.width = window.innerWidth;
    h = canvas.height = window.innerHeight;
});
</script>
<script>
// Display years and days since founding
function updateSinceFounded() {
    const founded = new Date("2012-11-20T00:00:00+13:00");
    const now = new Date();
    // Calculate total days
    const msPerDay = 1000 * 60 * 60 * 24;
    const days = Math.floor((now - founded) / msPerDay);
    // Calculate years and remaining days
    let years = now.getFullYear() - founded.getFullYear();
    let anniversary = new Date(founded);
    anniversary.setFullYear(now.getFullYear());
    if (now < anniversary) years--;
    anniversary.setFullYear(founded.getFullYear() + years);
    const daysSinceAnniversary = Math.floor((now - anniversary) / msPerDay);

    document.getElementById('since-founded').innerText =
        `Serving Samoa and the Pacific for ${years} years and ${daysSinceAnniversary} days (since Nov 20, 2012)`;
}
updateSinceFounded();
setInterval(updateSinceFounded, 3600 * 1000); // Update every hour
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const popup = document.createElement('div');
    popup.className = 'preview-popup';
    document.body.appendChild(popup);

    let hideTimeout;

    function closePopup() {
        popup.classList.add('hide');
        setTimeout(() => {
            popup.style.display = 'none';
            popup.classList.remove('hide');
        }, 220); // match fadeOutPopup animation duration
    }

    function showPopup(link) {
        clearTimeout(hideTimeout);
        const title = link.dataset.previewTitle || '';
        const htmlContent = link.dataset.previewHtml || '';
        const textContent = link.dataset.previewText || '';
        const mapLink = link.dataset.previewLink || '';

        // Close button HTML
        let closeBtn = `<button class="popup-close" aria-label="Close preview" tabindex="0">&times;</button>`;

        let inner = closeBtn;
        inner += title ? `<strong>${title}</strong><br>` : '';
        if (htmlContent) {
            inner += htmlContent;
        } else if (textContent) {
            inner += textContent;
            if (mapLink) {
                inner += `<br><a href="${mapLink}" target="_blank">View on Google Maps</a>`;
            }
        }
        popup.innerHTML = inner;
        popup.style.display = 'block';
        popup.scrollTop = 0;

        // Positioning
        const rect = link.getBoundingClientRect();
        let top = window.scrollY + rect.bottom + 8;
        let left = window.scrollX + rect.left;

        popup.style.maxHeight = '350px';
        popup.style.overflowY = 'auto';
        popup.style.width = '';
        popup.style.transform = '';
        popup.style.bottom = '';

        // Mobile: center and stick to bottom if screen is narrow
        if (window.innerWidth < 600) {
            popup.style.left = '50%';
            popup.style.top = '';
            popup.style.bottom = '10px';
            popup.style.transform = 'translateX(-50%)';
            popup.style.width = '96vw';
        } else {
            popup.style.top = `${top}px`;
            popup.style.left = `${left}px`;
            popup.style.width = '';
            popup.style.transform = '';
            popup.style.bottom = '';

            // Ensure popup stays in viewport (scroll up if needed)
            setTimeout(() => {
                const popupRect = popup.getBoundingClientRect();
                const overflow = (popupRect.bottom > window.innerHeight) ? (popupRect.bottom - window.innerHeight + 14) : 0;
                if (overflow > 0) {
                    popup.style.top = `${top - overflow}px`;
                }
            }, 10);
        }

        // Handle close button click
        popup.querySelector('.popup-close').onclick = closePopup;
    }

    document.querySelectorAll('.preview-link').forEach(link => {
        link.addEventListener('mouseenter', function(e) {
            showPopup(link);
        });
        link.addEventListener('focus', function(e) {
            showPopup(link);
        });
        link.addEventListener('mouseleave', function() {
            hideTimeout = setTimeout(closePopup, 180);
        });
        link.addEventListener('blur', function() {
            hideTimeout = setTimeout(closePopup, 180);
        });
    });

    popup.addEventListener('mouseenter', function() {
        clearTimeout(hideTimeout);
    });
    popup.addEventListener('mouseleave', function() {
        closePopup();
    });

    // Allow keyboard ESC to close the popup
    document.addEventListener('keydown', function(e) {
        if (popup.style.display === 'block' && (e.key === "Escape" || e.keyCode === 27)) {
            closePopup();
        }
    });
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tooltip creation
    let donorTooltip = document.createElement('div');
    donorTooltip.className = 'donor-tooltip';
    donorTooltip.tabIndex = 0; // For accessibility
    document.body.appendChild(donorTooltip);

    let tooltipTimeout;
    let currentTarget = null;

    // Show the tooltip
    function showTooltip(target) {
        currentTarget = target;
        const previewText = target.dataset.previewText || '';
        const previewUrl = target.dataset.previewUrl || target.href;
        const title = target.dataset.previewTitle || target.textContent;
        // Tooltip HTML with close icon
        donorTooltip.innerHTML = `
            <button class="donor-tooltip-close" aria-label="Close preview" tabindex="0">&times;</button>
            <strong>${title}</strong><br>${previewText}<br>
            <a href="#" class="donor-tooltip-visit" data-preview-title="${title}" data-preview-url="${previewUrl}" tabindex="0">Visit Website</a>
        `;
        donorTooltip.style.display = 'block';
        donorTooltip.style.opacity = '1';

        // Position below link
        let rect = target.getBoundingClientRect();
        donorTooltip.style.top = (window.scrollY + rect.bottom + 6) + 'px';
        donorTooltip.style.left = (window.scrollX + rect.left) + 'px';
    }

    // Hide the tooltip
    function hideTooltip() {
        donorTooltip.style.opacity = '0';
        tooltipTimeout = setTimeout(() => {
            donorTooltip.style.display = 'none';
        }, 160);
    }

    // Keep tooltip visible when mouse enters, hide when leaves both link and tooltip
    document.body.addEventListener('mouseover', function(e) {
        if (e.target.classList.contains('donor-preview')) {
            clearTimeout(tooltipTimeout);
            showTooltip(e.target);
        }
    });
    document.body.addEventListener('mouseout', function(e) {
        if (e.target.classList.contains('donor-preview')) {
            tooltipTimeout = setTimeout(hideTooltip, 180);
        }
    });
    donorTooltip.addEventListener('mouseenter', function() {
        clearTimeout(tooltipTimeout);
    });
    donorTooltip.addEventListener('mouseleave', function() {
        hideTooltip();
    });

    // Tooltip close icon
    donorTooltip.addEventListener('click', function(e) {
        if (e.target.classList.contains('donor-tooltip-close')) {
            hideTooltip();
        }
        // Intercept "Visit Website" click to open modal (if using modal for iframe preview)
        if (e.target.classList.contains('donor-tooltip-visit')) {
            e.preventDefault();
            const title = e.target.dataset.previewTitle;
            const url = e.target.dataset.previewUrl;
            // You can call your openDonorModal(title, url) function here if needed
            if (typeof openDonorModal === 'function') openDonorModal(title, url);
            hideTooltip();
        }
    });

    // ESC closes tooltip if focused
    donorTooltip.addEventListener('keydown', function(e) {
        if (e.key === "Escape" || e.keyCode === 27) {
            hideTooltip();
        }
    });
});
</script>


<script>
document.addEventListener('DOMContentLoaded', function() {
    // --- Modal Element References ---
    const modal = document.getElementById('donor-modal');
    const modalHeader = modal.querySelector('.donor-modal-header');
    const modalIframe = modal.querySelector('.donor-modal-iframe');
    const closeModalBtn = modal.querySelector('.donor-modal-close');
    const fallbackDiv = modal.querySelector('.modal-fallback');
    const modalContent = modal.querySelector('.donor-modal-content');

    // --- Modal Open/Close Functions ---
    function openDonorModal(title, url) {
        modalHeader.textContent = title;
        modalIframe.src = url;
        modalIframe.style.display = '';
        fallbackDiv.style.display = 'none';
        fallbackDiv.innerHTML = '';
        modal.style.display = 'flex';
        document.body.style.overflow = 'hidden';

        // Fallback: show external link if iframe does not load after 2.2 seconds
        setTimeout(function() {
            // Check if modal is still open and iframe hasn't been interacted with
            if (modal.style.display === 'flex') {
                // Try to detect blank iframe (some browsers block access to contents)
                // If you want to be more robust, always show fallback for known domains
                modalIframe.style.display = 'none';
                fallbackDiv.style.display = 'block';
                fallbackDiv.innerHTML = `
                    <p>Sorry, this website does not allow preview inside other sites.</p>
                    <a href="${url}" target="_blank" class="visit-in-new-tab">Open in New Tab</a>
                `;
            }
        }, 2200);

        // Optional: clear fallback if iframe loads successfully
        modalIframe.onload = function() {
            // Some sites may still block, but if iframe loads, show it
            fallbackDiv.style.display = 'none';
            modalIframe.style.display = '';
        };
        // Optional: show fallback immediately if iframe errors
        modalIframe.onerror = function() {
            modalIframe.style.display = 'none';
            fallbackDiv.style.display = 'block';
            fallbackDiv.innerHTML = `
                <p>Sorry, this website does not allow preview inside other sites.</p>
                <a href="${url}" target="_blank" class="visit-in-new-tab">Open in New Tab</a>
            `;
        };
    }

    function closeDonorModal() {
        modal.style.display = 'none';
        modalIframe.src = '';
        fallbackDiv.style.display = 'none';
        fallbackDiv.innerHTML = '';
        document.body.style.overflow = '';
    }

    // --- Modal Close Listeners ---
    closeModalBtn.addEventListener('click', closeDonorModal);
    modal.addEventListener('click', function(e) {
        if (e.target === modal) closeDonorModal();
    });
    document.addEventListener('keydown', function(e) {
        if (modal.style.display === 'flex' && (e.key === "Escape" || e.keyCode === 27)) {
            closeDonorModal();
        }
    });

    // --- Listen for Donor Preview Link Clicks ---
    document.body.addEventListener('click', function(e) {
        // For .donor-preview links (in popup or tooltip)
        if (e.target.classList.contains('donor-preview') || e.target.classList.contains('donor-tooltip-visit')) {
            e.preventDefault();
            const title = e.target.dataset.previewTitle || e.target.textContent;
            const url = e.target.dataset.previewUrl || e.target.href;
            openDonorModal(title, url);
            // Also hide any open tooltip (optional)
            if (window.donorTooltip) {
                window.donorTooltip.style.display = 'none';
            }
        }
    });
});
</script>


<script>
document.addEventListener('DOMContentLoaded', function() {
    const loginBox = document.getElementById('loginBox');
    const hideLoginBtn = document.getElementById('hideLoginBtn');
    const showLoginBtn = document.getElementById('showLoginBtn');

    hideLoginBtn.onclick = function() {
        loginBox.style.display = 'none';
        hideLoginBtn.style.display = 'none';
        showLoginBtn.style.display = 'inline-block';
    };
    showLoginBtn.onclick = function() {
        loginBox.style.display = 'flex'; // or 'block' depending on your CSS
        hideLoginBtn.style.display = 'inline-block';
        showLoginBtn.style.display = 'none';
    };
});
</script>






<div id="donor-modal" class="donor-modal">
  <div class="donor-modal-content">
    <button class="donor-modal-close" aria-label="Close preview">&times;</button>
    <div class="donor-modal-header"></div>
    <iframe src="" class="donor-modal-iframe" frameborder="0"></iframe>
    <div class="modal-fallback" style="display:none;"></div>
  </div>
</div>






</body>
</html>
