<?php
// contact_process.php
header('Content-Type: application/json');

// Validate POST data
$email = filter_var($_POST['email'], FILTER_VALIDATE_EMAIL);
$message = trim($_POST['message']);

if (!$email || empty($message)) {
    echo json_encode(['success' => false, 'error' => 'Invalid input.']);
    exit;
}

// Email configuration
$to = "pelenato@gmail.com"; // Change to your destination email
$subject = "New Contact Form Message";
$headers = "From: $email\r\n";
$headers .= "Reply-To: $email\r\n";
$headers .= "Content-Type: text/plain; charset=UTF-8";

// Message body
$body = "You received a new message from your contact form:\n\n";
$body .= "Email: $email\n";
$body .= "Message:\n$message\n";

// Send the email
$sent = mail($to, $subject, $body, $headers);

echo json_encode(['success' => $sent]);
