<?php
class ConnectionManager_Base
{
	/**
	 * Cached Connection objects
	 * @type Array
	 */
	protected $cache = array();

	/**
	 * Project connections data
	 * @type Array
	 */
	protected $_connectionsData;

	/**
	 * Project connections data
	 * @type Array
	 */
	protected $_connectionsIdByName = array();


	/**
	 * An array storing the correspondence between project
	 * datasource tables names and connections ids
	 * @type Array
	 */
	protected $_tablesConnectionIds;


	/**
	 * @constructor
	 */
	function __construct()
	{
		$this->_setConnectionsData();
		$this->_setTablesConnectionIds();
	}

	/**
	 * Get connection id by the table name
	 * @param String tName
	 * @return Connection
	 */
	public function getTableConnId( $tName )
	{
		return $this->_tablesConnectionIds[ $tName ];
	}


	/**
	 * Get connection object by the table name
	 * @param String tName
	 * @return Connection
	 */
	public function byTable( $tName )
	{
		$connId = $this->_tablesConnectionIds[ $tName ];
		if( !$connId )
			return $this->getDefault();
		return $this->byId( $connId );
	}

	/**
	 * Get connection object by the connection name
	 * @param String connName
	 * @return Connection
	 */
	public function byName( $connName )
	{
		$connId = $this->getIdByName( $connName );
		if( !$connId )
			return $this->getDefault();
		return $this->byId( $connId );
	}

	/**
	 * Get connection id by the connection name
	 * @param String connName
	 * @return String
	 */
	protected function getIdByName( $connName )
	{
		return $this->_connectionsIdByName[ $connName ];
	}

	/**
	 * Get connection object by the connection id
	 * @param String connId
	 * @return Connection
	 */
	public function byId( $connId )
	{
		if( !isset( $this->cache[ $connId ] ) ) {
			$conn = $this->getConnection( $connId );
			if( !$conn ) {
				global $restApis;
				$conn = $restApis->getConnection( $connId );
			}
			if( !$conn ) {
				$conn = $this->getDefault();
			}
			$this->cache[ $connId ] = $conn;
		}

		return $this->cache[ $connId ];
	}

	/**
	 * Get the default db connection class
	 * @return Connection
	 */
	public function getDefault()
	{
		return $this->byId( "jobs_at_localhost" );
	}

	/**
	 * Get the default db connection id
	 * @return String
	 */
	public function getDefaultConnId()
	{
		return "jobs_at_localhost";
	}



	/**
	 * Get the users table db connection
	 * @return Connection
	 */
	public function getForLogin() {
		return $this->byId( $this->getLoginConnId() );
	}

	public function getLoginConnId() {
		$db = &Security::dbProvider();		
		if( $db ) {
			return $db["table"]["connId"];
		}
		return "";
	}


	/**
	 * Get the log table db connection
	 * @return Connection
	 */
	public function getForAudit()
	{
		return $this->byId( "jobs_at_localhost" );
	}

	/**
	 * Get the locking table db connection
	 * @return Connection
	 */
	public function getForLocking()
	{
		return $this->byId( "jobs_at_localhost" );
	}

	/**
	 * Get the 'ug_groups' table db connection
	 * @return Connection
	 */
	public function getForUserGroups() {
		return $this->byId( $this->getUserGroupsConnId() );
	}

	public function getUserGroupsConnId() {
		return "jobs_at_localhost";
	}

	/**
	 * Get the saved searches table db connection
	 * @return Connection
	 */
	public function getForSavedSearches()
	{
		return $this->byId( $this->getSavedSearchesConnId() );
	}
	
	/**
	 * Get the saved searches table db connection
	 * @return Connection
	 */
	public function getSavedSearchesConnId()
	{
		return "jobs_at_localhost";
	}	

	/**
	 * Get the webreports tables db connection
	 * @return Connection
	 */
	public function getForWebReports() 
	{
		return $this->byId( $this->getSavedSearchesConnId() );
	}

	/**
	 * Get the webreports tables db connection id
	 * @return String
	 */
	public function getWebReportsConnId() {
		return "jobs_at_localhost";
	}	
	
	/**
	 * @param String connId
	 * @return Connection
	 */
	protected function getConnection( $connId )
	{
		return false;
	}

	public function getConectionsIds()
	{
		$connectionsIds = array();
		foreach ($this->_connectionsData as $connId => $data) {
			$connectionsIds[] = $connId;
		}

		return $connectionsIds;
	}

	/**
	 * Set the data representing the project's
	 * db connection properties
	 */
	protected function _setConnectionsData()
	{
        return null;
	}

	/**
	 * Set the data representing the correspondence between
	 * the project's table names and db connections
	 */
	protected function _setTablesConnectionIds()
	{
		$connectionsIds = array();
		$connectionsIds["jobsjobs"] = "jobs_at_localhost";
		$connectionsIds["jobsjobtype"] = "jobs_at_localhost";
		$connectionsIds["jobsstate"] = "jobs_at_localhost";
		$connectionsIds["jobsusers"] = "jobs_at_localhost";
		$connectionsIds["jobsjobs_admin"] = "jobs_at_localhost";
		$connectionsIds["jobs_employer_profile"] = "jobs_at_localhost";
		$connectionsIds["jobs_jobseeker_profile"] = "jobs_at_localhost";
		$connectionsIds["applications"] = "jobs_at_localhost";
		$connectionsIds["application_form"] = "jobs_at_localhost";
		$connectionsIds["jobs_settings"] = "jobs_at_localhost";
		$connectionsIds["mmencodings"] = "jobs_at_localhost";
		$connectionsIds["mmintervaltype"] = "jobs_at_localhost";
		$connectionsIds["mmlog"] = "jobs_at_localhost";
		$connectionsIds["mmqueries"] = "jobs_at_localhost";
		$connectionsIds["mmtasks"] = "jobs_at_localhost";
		$connectionsIds["preview_email"] = "jobs_at_localhost";
		$connectionsIds["mmsubscribers"] = "jobs_at_localhost";
		$connectionsIds["mmlists"] = "jobs_at_localhost";
		$connectionsIds["mmdummy"] = "jobs_at_localhost";
		$connectionsIds["mmoptions"] = "jobs_at_localhost";
		$connectionsIds["weekdays"] = "jobs_at_localhost";
		$connectionsIds["jobs_subs"] = "jobs_at_localhost";
		$connectionsIds["jobs_application"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile"] = "jobs_at_localhost";
		$connectionsIds["clcategory"] = "jobs_at_localhost";
		$connectionsIds["clsubcategory"] = "jobs_at_localhost";
		$connectionsIds["jobsusers_upload"] = "jobs_at_localhost";
		$connectionsIds["address"] = "jobs_at_localhost";
		$connectionsIds["jobs_application_archive_view"] = "jobs_at_localhost";
		$connectionsIds["jobs_application_archive"] = "jobs_at_localhost";
		$connectionsIds["your_application/s"] = "jobs_at_localhost";
		$connectionsIds["your_job/s"] = "jobs_at_localhost";
		$connectionsIds["incoming_applications"] = "jobs_at_localhost";
		$connectionsIds["registration"] = "jobs_at_localhost";
		$connectionsIds["jobs_application_employer"] = "jobs_at_localhost";
		$connectionsIds["jobs_application_jobseeker"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_gender"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_job_title"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_job_title_accounting"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_accounting"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_administration_n_office_support"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_advertising_arts_n_media"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_banking_n_financial_services"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_call_centre_n_customer_service"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_community_services_n_development"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_construction"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_education_n_training"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_design_n_architecture"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_consulting_n_strategy"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_engineering"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_farming_animals_n_conservation"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_government_n_defense"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_healthcare_medical"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_hospitality_n_tourism"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_human_resources_n_recruitment"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_information_n_communication_technology"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_insurance_n_superannuation"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_legal"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_manufacturing_transport_n_logistics"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_marketing_n_communication"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_mining_resource_n_energy"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_real_estate_n_property"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_retail_n_consumer_products"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_gender_employer"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_jobseeker"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_employer"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_jobseeker_education"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_jobseeker_education_empty"] = "jobs_at_localhost";
		$connectionsIds["jobs_profile_education_level"] = "jobs_at_localhost";
		$connectionsIds["jobsjobs-cards-limits-10"] = "jobs_at_localhost";
		$connectionsIds["jobs_subscriptions"] = "jobs_at_localhost";
		$connectionsIds["jobs_application_log"] = "jobs_at_localhost";
		$connectionsIds["remote_jobs_view"] = "rest";
		$connectionsIds["external_jobs"] = "jobs_at_localhost";
		$connectionsIds["remote_click_logs"] = "jobs_at_localhost";
		$connectionsIds["remote_job_clicks"] = "jobs_at_localhost";
		$connectionsIds["remote_jobs"] = "jobs_at_localhost";
		$connectionsIds["combine_charts-local-and-external"] = "jobs_at_localhost";
		$connectionsIds["external_jobs_view_001"] = "jobs_at_localhost";
		$connectionsIds["jobsjobs-dashboard"] = "jobs_at_localhost";
		$connectionsIds["click_logs"] = "jobs_at_localhost";

		$this->_tablesConnectionIds = &$connectionsIds;
	}

	/**
	 * Check if It's possible to add to one table's sql query
	 * an sql subquery to another table.
	 * Access doesn't support subqueries from the same table as main.
	 * @param String dataSourceTName1
	 * @param String dataSourceTName2
	 * @return Boolean
	 */
	public function checkTablesSubqueriesSupport( $dataSourceTName1, $dataSourceTName2 )
	{
		$connId1 = $this->_tablesConnectionIds[ $dataSourceTName1 ];
		$connId2 = $this->_tablesConnectionIds[ $dataSourceTName2 ];

		if( $connId1 != $connId2 )
			return false;

		if( $this->_connectionsData[ $connId1 ]["dbType"] == nDATABASE_Access && $dataSourceTName1 == $dataSourceTName2 )
			return false;

		return true;
	}

	/**
	 * Close db connections
    */
	function CloseConnections()
	{
		foreach( $this->cache as $connection )
		{
			if( $connection )
				$connection->close();
		}
	}
}
?>