<!doctype html>
<html  {$html_attrs}>
	<head>
	<meta http-equiv="X-UA-Compatible" content="IE=Edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>{$pagetitle}</title>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<base href="{$projectPath}">
	<link REL="stylesheet" href="styles/default.css?{$wizardBuildKey}" type="text/css">
	{BEGIN rtlCSS}
	<link REL="stylesheet" href="styles/defaultRTL.css?{$wizardBuildKey}" type="text/css">
	{END rtlCSS}
	{BEGIN styleCSSFiles}
	<link REL="stylesheet" href="{$stylepath}" type="text/css">
	{END styleCSSFiles}
	<!-- charts -->
	<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>
	<!-- External JS -->
    <script src="custom_assets/js/dashboard.js?v=1.0"></script>
    <!-- Optional CSS -->
    <link rel="stylesheet" href="custom_assets/css/dashboard.css?v=1.0">
    <!-- Chart.js -->
    <!-- Load Chart.js and the Data Labels plugin -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>
	
	</head>
	<body class="{$stylename} function-list">
<!-- charts -->
	<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>
	<!-- External JS -->
    <script src="custom_assets/js/dashboard.js?v=1.0"></script>
    <!-- Optional CSS -->
    <link rel="stylesheet" href="custom_assets/css/dashboard.css?v=1.0">
    <!-- Chart.js -->
    <!-- Load Chart.js and the Data Labels plugin -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>
<style>
{$containerCss}
 .dashboard {
  display: flex;
  flex-wrap: wrap;
  gap: 12px;
  justify-content: center;
  padding: 10px;
  transition: all 0.3s ease;
}

.dashboard-toggle-btn {
  position: fixed;
  bottom: 0;
  left: 50%;
  transform: translateX(-50%);
  background: #b45309;
  color: white;
  padding: 10px 28px;
  border: none;
  border-top: 6px solid orange;
  font-weight: bold;
  border-radius: 12px 12px 0 0;
  box-shadow: 0 -4px 8px rgba(0,0,0,0.15);
  cursor: pointer;
  z-index: 999;
  transition: all 0.3s ease;
}

.dashboard-toggle-btn.top {
  position: relative;
  margin: 10px 8px;
  top: auto;
  left: auto;
  transform: none;
  border-radius: 6px;
  padding: 6px 16px;
  font-size: 13px;
  border-top: none;
  box-shadow: 0 2px 6px rgba(0,0,0,0.1);
  display: inline-block;
  background-color: #b45309;
  color: white;
}

.dashboard-hidden,
.dashboard-charts-hidden,
.dashboard-filters-hidden {
  display: none;
  position: relative;
}

#dashboardCharts,
#dashboardFilters {
  transition: all 0.3s ease;
}

.chart-container-user-posted {
  width: 100%;
  height: 300
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  position: relative;
  margin: 0 auto;
}

.chart-container-user-posted h4 {
  margin-bottom: 8px;
  font-size: 16px;
  text-align: center;
  color: #333;
}
	/* Make UI Mobile-Friendly */
    @media (max-width: 600px) {
    .dashboard, .jobs-grid {
    flex-direction: column;
    align-items: center;
    }
    .card, .job-card {
    width: 100%;
    max-width: 90%;
    }
}

?*latest below*/
/* 🔁 Shared ::before layout for all logos */
.job-card::before {
  content: "";
  position: absolute;
  bottom: 0;
  right: 0;
  width: 100%;
  height: 100%;
  z-index: 1;
  background-position: bottom right;
  background-repeat: no-repeat;
  background-size: 100px auto;
  pointer-events: none;
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.95), rgba(255,255,255,0)),
    url('images/logos/default.png'); /* fallback */
}

/* ✅ Logo overrides */
.card-sprep::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.5), rgba(255,255,255,0)),
    url('images/logos/sprep_logo.png');
    background-size: 60px auto; /* 👈 adjust logo size */
}

.card-govt::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.5), rgba(255,255,255,0)),
    url('images/logos/govt.png');
    background-size: 50px auto; /* 👈 adjust logo size */
}

.card-undp::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.5), rgba(255,255,255,0)),
    url('images/logos/undp.png');
    background-size: 60px auto; /* 👈 adjust logo size */
}

.card-spc::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.5), rgba(255,255,255,0)),
    url('images/logos/spc.png');
    background-size: 60px auto; /* 👈 adjust logo size */
}

.card-pifs::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.5), rgba(255,255,255,0)),
    url('images/logos/pifs.png');
    background-size: 60px auto; /* 👈 adjust logo size */
}

.card-ffa::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.5), rgba(255,255,255,0)),
    url('images/logos/ffa.png');
    background-size: 70px auto; /* 👈 adjust logo size */
}

.card-himalayas::before {
  background-image:
    linear-gradient(to top left, rgba(255,255,255,0.6), rgba(255,255,255,0)),
    url('images/logos/himalayas.png');
}

/* 🌙 Dark mode with logo and soft dark gradient */
body.dark-mode .card-sprep::before {
  background-image:
    linear-gradient(to top left, rgba(0,0,0,0.9), rgba(0,0,0,0)),
    url('images/logos/sprep_logo.png');
}

body.dark-mode .card-govt::before {
  background-image:
    linear-gradient(to top left, rgba(0,0,0,0.9), rgba(0,0,0,0)),
    url('images/logos/govt.png');
}

body.dark-mode .card-undp::before {
  background-image:
    linear-gradient(to top left, rgba(0,0,0,0.9), rgba(0,0,0,0)),
    url('images/logos/undp.png');
}

body.dark-mode .card-spc::before {
  background-image:
    linear-gradient(to top left, rgba(0,0,0,0.9), rgba(0,0,0,0)),
    url('images/logos/spc.png');
}

body.dark-mode .card-pifs::before {
  background-image:
    linear-gradient(to top left, rgba(0,0,0,0.9), rgba(0,0,0,0)),
    url('images/logos/pifs.png');
}

body.dark-mode .card-ffa::before {
  background-image:
    linear-gradient(to top left, rgba(0,0,0,0.9), rgba(0,0,0,0)),
    url('images/logos/ffa.png');
}

body.dark-mode .card-himalayas::before {
  background-image:
    linear-gradient(to top left, rgba(0,0,0,0.9), rgba(0,0,0,0)),
    url('images/logos/himalayas.png');
}


.card-sprep:hover::before,
.card-govt:hover::before,
.card-undp:hover::before,
.card-spc:hover::before,
.card-pifs:hover::before,
.card-ffa:hover::before,
.card-himalayas:hover::before {
  opacity: 0.08;
  filter: saturate(1.1) brightness(1.5);
}

/* 🔺 Top-left triangle tag (uses ::after so it doesn't conflict with ::before logos) */
.job-card::after {
  content: "";
  position: absolute;
  top: 0;
  left: 0;
  width: 0;
  height: 0;
  border-style: solid;
  border-width: 0 28px 28px 0;
  border-color: transparent #f59e0b transparent transparent; /* Default FFA orange */
  z-index: 3;
  border-radius: 0 0 4px 0;
  box-shadow: 0 2px 4px rgba(0,0,0,0.2);
}


/* 🌐 Source-specific triangle colors */
.card-govt::after { border-color: transparent #3b82f6 transparent transparent; } /* Blue */
.card-sprep::after { border-color: transparent #10b981 transparent transparent; } /* Green */
.card-undp::after { border-color: transparent #6366f1 transparent transparent; } /* Indigo */
.card-spc::after { border-color: transparent #0ea5e9 transparent transparent; } /* Sky */
.card-pifs::after { border-color: transparent #ec4899 transparent transparent; } /* Pink */
.card-ffa::after { border-color: transparent #f59e0b transparent transparent; } /* Amber */
.card-himalayas::after { border-color: transparent #8b5cf6 transparent transparent; } /* Violet */

/* 🌙 Optional dark mode refinement */
body.dark-mode .job-card::after {
  opacity: 0.85;
}







/* ✅ Grace period tag - Light mode */
.grace-message {
  display: inline-block;
  background-color: #fff3cd; /* soft warning yellow */
  color: #856404;
  border: 1px solid #ffeeba;
  padding: 6px 10px;
  border-radius: 6px;
  font-size: 13px;
  margin-top: 6px;
}

/* 🌙 Dark mode override */
body.dark-mode .grace-message {
  background-color: rgba(255, 193, 7, 0.1); /* subtle dark amber */
  color: #ffc107; /* warm yellow text */
  border: 1px solid rgba(255, 193, 7, 0.3);
  backdrop-filter: blur(2px);
}



.badge-closing-inline {
  display: inline-block;
  padding: 2px 8px;
  font-size: 11px;
  border-radius: 4px;
  margin-left: 8px;
  font-weight: bold;
  vertical-align: middle;
}

.urgent-red {
  background-color: #dc3545;
  color: #fff;
}

.closing-soon-animated {
  background: #fdecea;
  color: #b91c1c;
  padding: 5px 10px;
  border-radius: 5px;
  font-size: 0.85em;
  display: inline-block;
  margin-top: 4px;
  font-weight: 500;
}

.closing-soon-animated:hover {
  transform: translateY(-2px) scale(1.05);
  font-size: 14px;
}

.expired-tag {
  margin-left: 6px;
  color: #6c757d;
  background-color: #e2e3e5;
  font-size: 13px;
  font-weight: bold;
  padding: 4px 8px;
  border-radius: 4px;
}

.expired-card {
  opacity: 0.6;
  filter: grayscale(20%);
/*  pointer-events: none;  optional: disable clicks */
}

.grace-message {
  display: inline-block;
  margin-left: 6px;
  font-size: 13px;
  color: #856404;
  background-color: #fff3cd;
  border-left: 4px solid #fd7e14;
  padding: 4px 8px;
  border-radius: 4px;
}


.no-local-jobs {
  background: #fff6f6;
  border: 1px solid #f5c2c7;
  color: #842029;
  padding: 20px 30px;
  border-radius: 12px;
  text-align: center;
  box-shadow: 0 2px 6px rgba(0,0,0,0.05);
  font-family: 'Segoe UI', sans-serif;
  max-width: 700px;
  margin: 40px auto;
  position: relative;
  transition: all 0.4s ease-in-out;
}

.dismiss-btn {
  position: absolute;
  top: 10px;
  right: 15px;
  border: none;
  background: transparent;
  font-size: 18px;
  color: #d63384;
  cursor: pointer;
  transition: opacity 0.3s;
}
.dismiss-btn:hover {
  opacity: 0.6;
}


.no-local-jobs h3 {
  font-size: 1.5rem;
  color: #d63384;
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 8px;
}

.no-local-jobs p {
  font-size: 1rem;
  line-height: 1.5;
  margin-top: 10px;
}






.jobs-grid {
display: flex;
flex-wrap: wrap;
gap: 20px;
justify-content: center;
padding: 40px 20px;
}
   
.job-card {
/* background: #fff; */
background: rgba(255,255,255,0.85);
border-radius: 10px;
box-shadow: 0 4px 10px rgba(0,0,0,0.1);
padding: 20px;
width: 280px;
border-left: 5px solid #007BFF;
position: relative;
z-index: 2;
transition: all 0.3s ease;
/* overflow: hidden; */
overflow: visible;
min-height: 180px;
}

/* Show only on hover */
.job-card:hover .hover-message {
  opacity: 1;
}

.job-card:hover {
  transform: translateY(-3px);
  box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
}

/*.card-hover-tip {
  position: absolute;
  bottom: 8px;
  left: 8px;
  right: 8px;
  background: rgba(255,255,255,0.95);
  border-left: 4px solid #0ea5e9;
  color: #0f172a;
  font-size: 13px;
  padding: 8px 10px;
  border-radius: 6px;
  opacity: 0;
  transform: translateY(10px);
  transition: opacity 0.4s ease, transform 0.4s ease;
  z-index: 2;
  pointer-events: none;
  font-style: italic;
}*/

.card-hover-tip {
  position: absolute;
  bottom: 15px;
  left: 15px;
  right: 15px;
  background: #ecfdf5;
  border-left: 4px solid #10b981;
  padding: 10px 14px 10px 14px;
  font-size: 14px;
  color: #047857;
  font-style: italic;
  border-radius: 6px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.05);
  opacity: 0;
  max-height: 0;
  overflow: hidden;
  transition: opacity 0.4s ease, max-height 0.4s ease;
  z-index: 3;
}


.card-hover-tip strong {
  font-weight: 600;
  color: #065f46;
}

.card-hover-tip .close-tip {
  position: absolute;
  top: 4px;
  right: 8px;
  font-size: 14px;
  color: #999;
  cursor: pointer;
  font-weight: bold;
}

.card-hover-tip .close-tip:hover {
  color: #555;
}


.job-card:hover .card-hover-tip {
  opacity: 1;
  max-height: 200px;
}

.job-card:not(:hover) .card-hover-tip {
  opacity: 0;
  pointer-events: none;
  transition: opacity 0.6s ease;
}

.job-description {
opacity: 0;
max-height: 0;
overflow: hidden;
transition: all 0.3s ease;
font-size: 13px;
color: #444;
margin-top: 10px;
}

.job-card:hover .job-description {
opacity: 1;
max-height: 150px;
}

/* ✅ Light mode gradient style */
/* Gradient from Coral to Blue */
/*.job-card h3 {
  background: linear-gradient(90deg, #ff7f50, #1e90ff); 
  -webkit-background-clip: text;
  color: transparent;
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
}*/

/* 🌙 Dark mode gradient style (with a slight brightness boost) */
body.dark-mode .job-card h3 {
  background: linear-gradient(90deg, #ff7f50, #1e90ff); /* Same gradient */
  -webkit-background-clip: text;
  color: transparent;
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
  opacity: 1; /* Fix opacity issue in dark mode */
}


.job-card p {
margin: 4px 0;
font-size: 14px;
}


.dropdown-btn {
  background: transparent;
  border: none;
  color: white;
  font-size: 14px;
  cursor: pointer;
}

.dropdown-content {
  display: none;
  position: absolute;
  right: 0;
  background-color: white;
  color: #333;
  min-width: 180px;
  border-radius: 6px;
  box-shadow: 0 8px 16px rgba(0,0,0,0.15);
  z-index: 9999;
}

.dropdown-content a {
  color: #004080;
  padding: 12px 16px;
  text-decoration: none;
  display: block;
}

.dropdown-content a:hover {
  background-color: #f1f1f1;
}

.show {
  display: block;
}




.filter-btn {
  background-color: #f8f9fa;
  color: #333;
  border: 1px solid #ccc;
  padding: 8px 16px;
  border-radius: 20px;
  font-size: 14px;
  cursor: pointer;
  transition: background-color 0.3s ease, transform 0.2s ease;
  display: inline-block;
  font-weight: 500;
  min-width: 120px;
  text-align: center;
}

.filter-btn:hover {
  background-color: #e2e6ea;
  transform: translateY(-2px);
}

 
  .filter-btn.red { background-color: #dc3545; color: white; }
.filter-btn.red:hover { background-color: #c82333; }

.filter-btn.blue { background-color: #007BFF; color: white; }
.filter-btn.blue:hover { background-color: #0056b3; }

.filter-btn.green { background-color: #28a745; color: white; }
.filter-btn.green:hover { background-color: #1e7e34; }

.filter-btn.purple { background-color: #6f42c1; color: white; }
.filter-btn.purple:hover { background-color: #563d7c; }

  .btn-blue {
    background-color: #007BFF;
    color: white;
    border-color: #007BFF;
  }

  .btn-green {
    background-color: #28a745;
    color: white;
    border-color: #28a745;
  }

  .btn-purple {
    background-color: #6f42c1;
    color: white;
    border-color: #6f42c1;
  }

  .btn-blue:hover {
    background-color: #0056b3;
  }

  .btn-green:hover {
    background-color: #1e7e34;
  }

  .btn-purple:hover {
    background-color: #563d7c;
  }

.toggle-chart-btn {
background-color: #dc3545;
color: white;
border: none;
padding: 6px 12px;
font-size: 14px;
border-radius: 4px;
cursor: pointer;
margin-right: 10px;
}
   
.toggle-chart-btn:hover {
background-color: #c82333;
}

.toggle-desc {
  display: inline-block;
  margin-left: 8px;
  color: #007BFF;
  cursor: pointer;
  font-size: 13px;
}
.toggle-desc:hover {
  text-decoration: underline;
}

.hover-message {
  position: absolute;
  bottom: 14px;
  right: 14px;
  z-index: 3;
  padding: 6px 10px;
  font-size: 13px;
  font-weight: 500;
  background: rgba(255,255,255,0.95);
  color: #1e293b;
  border-radius: 6px;
  box-shadow: 0 1px 5px rgba(0,0,0,0.1);
  opacity: 0;
  pointer-events: none;
  max-width: 80%;
  transition: all 0.3s ease;
  white-space: normal;
  text-align: left;
  line-height: 1.3;
}


}
#toggleSearchBtn {
  background: #0288d1;
  color: white;
  border: none;
  padding: 10px 15px;
  border-radius: 10px 0 0 10px;
  font-size: 16px;
  cursor: pointer;
}
.search-panel {
  background: white;
  padding: 10px;
  border-radius: 10px 0 0 10px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.2);
}

.search-panel input {
  width: 200px;
  padding: 6px;
  font-size: 14px;
  border: 1px solid #ccc;
  border-radius: 4px;
}

#clearSearch {
  background: transparent;
  border: none;
  font-size: 18px;
  color: #d33;
  margin-left: 5px;
  cursor: pointer;
}

mark {
  background: yellow;
  padding: 0 2px;
}

.theme-toggle-btn {
  background: #4b5563;
  color: white;
  border: none;
  padding: 10px 15px;
  margin-top: 8px;
  font-size: 14px;
  border-radius: 10px 0 0 10px;
  cursor: pointer;
}


#themeToggleBtn,
#toggleSearchBtn {
  background: #0288d1;
  color: white;
  border: none;
  padding: 10px 15px;
  border-radius: 10px 0 0 10px;
  font-size: 14px;
  cursor: pointer;
  min-width: 120px;
}

.search-panel {
  background: white;
  padding: 10px;
  border-radius: 10px 0 0 10px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.2);
  display: none;
}



/* 🌙 Dark Mode Setup */
body.dark-mode {
  background-color: #121212;
  color: #f3f3f3;
}

body.dark-mode .job-card {
  background-color: #1e1e1e;
  color: #eaeaea;
}

body.dark-mode .job-card h3 {
  color: #90cdf4;
}

body.dark-mode .card-hover-tip {
  background-color: #1a1a1a;
  color: #7dd3fc;
  border-left: 4px solid #38bdf8;
}

.floating-tools {
  position: fixed;
  top: 40%;
  right: 0;
  display: flex;
  flex-direction: column;
  gap: 12px;
  z-index: 9999;
  align-items: flex-end;
}

/* Generic floating button look */
.floating-btn {
  background: #0288d1;
  color: white;
  border: none;
  padding: 10px 16px;
  border-radius: 12px 0 0 12px;
  font-size: 15px;
  cursor: pointer;
  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
  transition: background-color 0.3s ease;
}

.floating-btn:hover {
  background-color: #0071b3;
}

/* Search panel appearance */
.floating-search {
  display: flex;
  flex-direction: column;
  align-items: flex-end;
}

.floating-search .search-panel {
  background: white;
  padding: 10px;
  margin-top: 6px;
  border-radius: 10px 0 0 10px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.2);
  display: none;
}

.floating-search .search-panel input {
  width: 200px;
  padding: 6px;
  font-size: 14px;
  border: 1px solid #ccc;
  border-radius: 4px;
}

.floating-search .search-panel button {
  background: transparent;
  border: none;
  font-size: 18px;
  color: #d33;
  margin-left: 5px;
  cursor: pointer;
}

.floating-search:not(.collapsed) .search-panel {
  display: block;
}

body.dark-mode {
  background-color: #121212 !important;
  color: #f3f3f3 !important;
}

body.dark-mode .panel,
body.dark-mode .navbar,
body.dark-mode .panel-heading,
body.dark-mode .panel-body,
body.dark-mode .panel-footer,
body.dark-mode .r-topbar-page,
body.dark-mode .r-form,
body.dark-mode .searchOptions {
  background-color: #1f1f1f !important;
  color: #eee !important;
  border-color: #444 !important;
}

body.dark-mode .btn,
body.dark-mode .dropdown-menu,
body.dark-mode .job-card {
  background-color: #2a2a2a !important;
  color: #f5f5f5 !important;
  border-color: #444 !important;
}

body.dark-mode .dropdown-menu a:hover {
  background-color: #333 !important;
}

body.dark-mode a {
  color: #90cdf4 !important;
}

body.dark-mode .btn-primary {
  background-color: #007bff !important;
  border-color: #007bff !important;
}

body.dark-mode .btn-primary:hover {
  background-color: #0056b3 !important;
}

/* 🌙 Fix input visibility in dark mode */
body.dark-mode .floating-search .search-panel input {
  background-color: #2c2c2c;
  color: #f1f1f1;
  border: 1px solid #444;
}

body.dark-mode .floating-search .search-panel input::placeholder {
  color: #999;
}


/* 🔲 Floating Tray Style */
/*esults-tray {
  position: fixed;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  display: flex;
  flex-wrap: wrap;
  gap: 16px;
  padding: 20px;
  max-width: 80vw;
  max-height: 80vh;
  background: rgba(255, 255, 255, 0.95);
  border-radius: 16px;
  box-shadow: 0 4px 20px rgba(0, 0, 0, 0.25);
  overflow: auto;
  z-index: 9999;
  display: none;
}

.results-tray .job-card {
  transform: scale(0.98);
  transition: transform 0.4s ease, opacity 0.4s ease;
  opacity: 1;
}

.fade-out {
  opacity: 0;
  transform: scale(0.9);
  pointer-events: none;
}*/

/* 🌐 Results Tray */
.results-tray {
  position: fixed;
  bottom: 80px;
  left: 50%;
  transform: translateX(-50%);
  z-index: 9999;
  background: rgba(255, 255, 255, 0.95);
  border: 2px dashed #38bdf8;
  border-radius: 14px;
  box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
  padding: 18px 20px;
  max-width: 95vw;
  display: none;
  flex-wrap: wrap;
  gap: 12px;
  justify-content: center;
  transition: all 0.5s ease-in-out;
}

.results-tray .job-card {
  transform: scale(0.95);
  transition: transform 0.3s, box-shadow 0.3s;
  animation: slideUpIn 0.5s ease;
}

@keyframes slideUpIn {
  from {
    transform: translateY(60px);
    opacity: 0;
  }
  to {
    transform: translateY(0);
    opacity: 1;
  }
}

/* Expanded card style for full-body view */
.expanded-card {
  width: 100% !important;
  max-width: none;
  flex-direction: column;
  padding: 20px;
  background: white;
  box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

/* 🧊 Results Tray Style */
.results-tray {
  position: relative;
  display: flex;
  flex-wrap: wrap;
  gap: 14px;
  margin-top: 30px;
  padding: 20px 10px;
  background: transparent;
  border-top: 2px dashed #38bdf8;
  justify-content: center;
}

.expanded-card {
  width: 100%;
  max-width: none;
  padding: 18px;
  background: #fff;
  box-shadow: 0 3px 10px rgba(0,0,0,0.1);
}

.dark-mode .expanded-card {
  background: #1e293b;
  color: white;
}

mark {
  background: yellow;
  padding: 2px 4px;
  border-radius: 3px;
}

#stickyHeader {
  position: sticky;
  top: 0;
  z-index: 9999;
  background: #4a148c; /* fallback background */
  box-shadow: 0 2px 5px rgba(0,0,0,0.1);
}

/* Ensure both sub-layers keep their background */
#stickyHeader .r-topbar-page,
#stickyHeader .r-top {
  background: #4a148c;
  z-index: 9999;
}

  /* 🧷 Sticky PHPRunner navbar override */
  nav.navbar.navbar-default[data-location="supertop"] {
    position: sticky;
    top: 0;
    z-index: 10000;
    background: #3b5998 !important; /* match your theme */
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
  }

  /* Prevent layout shift */
/*body {
    padding-top: 70px; /* adjust if needed depending on nav height */
  }*/


/* 🎨 Custom Login Button (Guest view) */
.navbar-form[data-itemid="loginform_login"] a.btn {
  background: #ff6b00 !important;     /* Orange gradient-style */
  color: #fff !important;
  font-weight: bold;
  border: none !important;
  border-radius: 8px;
  padding: 6px 16px;
  font-size: 1em;
  box-shadow: 0 2px 4px rgba(0,0,0,0.2);
  transition: background 0.3s ease;
}

.navbar-form[data-itemid="loginform_login"] a.btn:hover {
  background: #e55b00 !important;
}

/* 👤 Logged-in User Button */
.navbar-form[data-itemid="username_button"] .btn.dropdown-toggle {
  background: #ffffff !important;
  color: #333 !important;
  font-weight: 600;
  border: 1px solid #ccc !important;
  border-radius: 8px;
  padding: 6px 16px;
  font-size: 1em;
  box-shadow: 0 1px 3px rgba(0,0,0,0.1);
}

/* Optional hover effect */
.navbar-form[data-itemid="username_button"] .btn.dropdown-toggle:hover {
  background-color: #f2f2f2 !important;
}






/* end style */

</style>

	{BEGIN body}
	
		{$header}

		<div class="r-topbar-page">
			<div data-menu-width="full" 
				 
				class="r-topheader" 
				data-resize-name="topbar"
				data-body-align="left"
			>
			    
								{BEGIN supertop_block}
<nav class="navbar navbar-default" 
	data-location="supertop" id="form_supertop_{$pageid}" data-makeup="topbar" {$form_supertop} data-pageid="{$pageid}" >
			 
							 
				<span data-cellId="supertop_c1" data-pageid="{$pageid}" class="r-align-left navbar-header" data-itemid="logo" {$item_logo}>
				{BEGIN logo_block}
	<A data-itemtype="logo" data-itemid="logo" {$item_logo} data-pageid="{$pageid}" class="navbar-brand" href="{$home_link}" data-pageid="{$pageid}" {$logo_hiddenattr}>
		{$logo}
	</A>
{END logo_block}
				<button data-pageid="1" type="button" class="navbar-toggle collapsed" data-runner-toggle="collapse" data-target="[data-mobile-controlled]">	
					<span class="sr-only">Toggle navigation</span>	
					<span class="icon-bar"></span>					
				</button>				
			</span>
		 
				<span data-cellId="supertop_c1" data-pageid="{$pageid}" class="r-align-left navbar-collapse" data-itemtype="menu" data-itemid="menu" {$item_menu} data-pageid="{$pageid}">
				{BEGIN menuitems_main}
<ul data-itemtype="menu" data-itemid="menu" {$item_menu} data-pageid="{$pageid}"	class="r-menu nav navbar-nav" 
	data-menulevel="1"
>

{BEGIN item_children1}
<li class="
	{BEGIN item_haschildren2} dropdown {END item_haschildren2} 
	{$item_current}">
<a {$item_attrs} title="{$item_tooltip}" data-menu-link data-menu-h data-menu-top >
	{$item_separator}
	<span class="r-menu-link  "> 
		<span class="r-menu-title">
		{$item_icon} {$item_title}
		</span>
		{BEGIN item_haschildren2}
		{BEGIN item_expand_icon}
		<span class="r-menu-expand-icon glyphicon glyphicon-triangle-bottom"></span>
		<span class="r-menu-mobile-expand-icon fa fa-angle-left"></span>
		{END item_expand_icon}
		{END item_haschildren2}
	</span>
	</a>
{BEGIN item_showchildren2}
<ul class="
			dropdown-menu
			{$submenu_class}" 
		id="submenu{$item_id}" data-menulevel="2">
	{BEGIN item_children2}
		{BEGIN item_menulink2}
		<li class="
						{BEGIN item_haschildren2} dropdown {END item_haschildren2}
						{$item_current}"
		>
			<a {$item_attrs} title="{$item_tooltip}" data-menu-link data-menu-h >
	{$item_separator}
	<span class="r-menu-link  "> 
		<span class="r-menu-title">
		{$item_icon} {$item_title}
		</span>
		{BEGIN item_haschildren2}
		{BEGIN item_expand_icon}
		<span class="r-menu-expand-icon glyphicon glyphicon-triangle-right"></span>
		<span class="r-menu-mobile-expand-icon fa fa-angle-left"></span>
		{END item_expand_icon}
		{END item_haschildren2}
	</span>
	</a>
			{BEGIN item_showchildren3}
<ul class="
			dropdown-menu
			{$submenu_class}" 
		id="submenu{$item_id}" data-menulevel="3">
	{BEGIN item_children3}
		{BEGIN item_menulink3}
		<li class="
						{BEGIN item_haschildren3} dropdown {END item_haschildren3}
						{$item_current}"
		>
			<a {$item_attrs} title="{$item_tooltip}" data-menu-link data-menu-h >
	{$item_separator}
	<span class="r-menu-link  "> 
		<span class="r-menu-title">
		{$item_icon} {$item_title}
		</span>
		{BEGIN item_haschildren3}
		{BEGIN item_expand_icon}
		<span class="r-menu-expand-icon glyphicon glyphicon-triangle-right"></span>
		<span class="r-menu-mobile-expand-icon fa fa-angle-left"></span>
		{END item_expand_icon}
		{END item_haschildren3}
	</span>
	</a>
			{BEGIN item_showchildren4}
<ul class="
			dropdown-menu
			{$submenu_class}" 
		id="submenu{$item_id}" data-menulevel="4">
	{BEGIN item_children4}
		{BEGIN item_menulink4}
		<li class="
						{BEGIN item_haschildren4} dropdown {END item_haschildren4}
						{$item_current}"
		>
			<a {$item_attrs} title="{$item_tooltip}" data-menu-link data-menu-h >
	{$item_separator}
	<span class="r-menu-link  "> 
		<span class="r-menu-title">
		{$item_icon} {$item_title}
		</span>
		{BEGIN item_haschildren4}
		{BEGIN item_expand_icon}
		<span class="r-menu-expand-icon glyphicon glyphicon-triangle-right"></span>
		<span class="r-menu-mobile-expand-icon fa fa-angle-left"></span>
		{END item_expand_icon}
		{END item_haschildren4}
	</span>
	</a>
			{BEGIN item_showchildren5}
<ul class="
			dropdown-menu
			{$submenu_class}" 
		id="submenu{$item_id}" data-menulevel="5">
	{BEGIN item_children5}
		{BEGIN item_menulink5}
		<li class="
						{BEGIN item_haschildren5} dropdown {END item_haschildren5}
						{$item_current}"
		>
			<a {$item_attrs} title="{$item_tooltip}" data-menu-link data-menu-h >
	{$item_separator}
	<span class="r-menu-link  "> 
		<span class="r-menu-title">
		{$item_icon} {$item_title}
		</span>
		{BEGIN item_haschildren5}
		{BEGIN item_expand_icon}
		<span class="r-menu-expand-icon glyphicon glyphicon-triangle-right"></span>
		<span class="r-menu-mobile-expand-icon fa fa-angle-left"></span>
		{END item_expand_icon}
		{END item_haschildren5}
	</span>
	</a>
					</li>
		{END item_menulink5}
	{END item_children5}
</ul>
{END item_showchildren5}
		</li>
		{END item_menulink4}
	{END item_children4}
</ul>
{END item_showchildren4}
		</li>
		{END item_menulink3}
	{END item_children3}
</ul>
{END item_showchildren3}
		</li>
		{END item_menulink2}
	{END item_children2}
</ul>
{END item_showchildren2}
</li>
{END item_children1}
</ul>
{END menuitems_main}
			</span>
		 
		 

				<span class="navbar-form r-align-left navbar-collapse" data-cellId="supertop_c1" data-pageid="{$pageid}" data-itemid="Subscribe_button" {$item_Subscribe_button} data-topcell-item-type="custom_button" >
				<span data-itemtype="custom_button" data-itemid="Subscribe_button" {$item_Subscribe_button} data-pageid="{$pageid}" data-small data-button-item>
	<a type="button" title="" class="btn btn-primary   
	" id="Subscribe_button" href="javascript:void(0)" typeid="ib" >
							Subscribe Button			</a>
</span>
			</span>
							 
							 
				<span class="navbar-form r-align-right navbar-collapse" data-cellId="supertop_c2" data-pageid="{$pageid}" data-itemid="simple_search" {$item_simple_search} data-topcell-item-type="simple_search" >
				<span data-itemtype="simple_search" data-itemid="simple_search" {$item_simple_search} data-pageid="{$pageid}" class="form-group">


</span>			</span>

<span>
<!-- 🔍 Enhanced Search Embedded in Navbar -->
<form id="topSearchForm" style="display: flex; gap: 10px; max-width: 800px; width: 100%; margin-right: auto; align-items: center;">
  <input type="text" id="topSearchInput" placeholder="Search jobs..."
         style="flex: 1; min-width: 300px; max-width: 500px; padding: 10px 18px;
                border-radius: 24px; border: none; font-size: 1em;
                background-color: #fff; color: #333;
                box-shadow: inset 0 1px 4px rgba(0,0,0,0.1); outline: none;">
  <button type="submit"
          style="background: #0d99ff; color: white; font-weight: 600;
                 border: none; border-radius: 24px; padding: 10px 20px;
                 font-size: 1em; cursor: pointer; box-shadow: 0 2px 5px rgba(0,0,0,0.15);">
    🔍 Search
  </button>
</form>
</span>
	
			<span>
<button class="dashboard-toggle-btn top" onclick="toggleDashboardCards()" id="dashToggleBtnTop">
    Hide Dashboard
  </button></span>
  <span>
 <!-- 🌗  Toggle -->
<button id="themeToggleBtn" class="btn btn-outline-light" style="border-radius: 20px;">
      🌓 Toggle Theme
    </button>
</span>

				<span class="navbar-form r-align-right navbar-collapse" data-cellId="supertop_c2" data-pageid="{$pageid}" data-itemid="loginform_login" {$item_loginform_login} data-topcell-item-type="loginform_login" >
				{BEGIN guestloginbutton}
<span data-itemtype="loginform_login" data-itemid="loginform_login" {$item_loginform_login} data-pageid="{$pageid}" data-small data-button-item>
	<a type="button" title="" class="btn btn-primary   
	" href="#" {$guestloginlink_attrs} >
							Login			</a>
</span>
{END guestloginbutton}
			</span>
		 
				<span class="navbar-form r-align-right navbar-collapse" data-cellId="supertop_c2" data-pageid="{$pageid}" data-itemid="username_button" {$item_username_button} data-topcell-item-type="username_button" >
				{BEGIN loggedas_message}
<span data-itemtype="username_button" data-itemid="username_button" {$item_username_button} data-pageid="{$pageid}" data-small data-button-item>
	<span class="dropdown ">
		<button type="button" title="" class="btn btn-default   dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">		
			{BEGIN userbutton_icon}							<span class="glyphicon glyphicon-user"></span>
						{END userbutton_icon}{$userbutton_image}			{$username}			<span class="caret"></span>
		</button>
		<ul class="dropdown-menu">
							{BEGIN userinfo_link}
	<li data-itemtype="userinfo_link" data-itemid="userinfo_link" {$item_userinfo_link} data-pageid="{$pageid}" data-small >
				<a  href="userinfo.php"  title="" >
				
		User Profile		
		</a>
	</li>
{END userinfo_link}
							{BEGIN logoutbutton}
	<li data-itemtype="logout_link" data-itemid="logout_link" {$item_logout_link} data-pageid="{$pageid}" data-small >
				<a  href="#" {$logoutlink_attrs}  title="" >
				
		Log out		
		</a>
	</li>
{END logoutbutton}
							{BEGIN changepwd_link}
	<li data-itemtype="changepassword_link" data-itemid="changepassword_link" {$item_changepassword_link} data-pageid="{$pageid}" data-small >
				<a  href="changepwd.php" {$changepwdlink_attrs} id="changePasswordButton{$id}"  title="" >
				
		Change password		
		</a>
	</li>
{END changepwd_link}
					</ul>
	</span>
</span>
{END loggedas_message}
			</span>
								</nav>
{END supertop_block}




					{$locking}
			</div>	
			<div data-body-align="left"  data-body-width="standard" class="r-body" data-resize-top="topbar" >
				<div class="r-top">
								{BEGIN top_block}
<div class="r-form" data-location="top" id="form_top_{$pageid}" data-makeup="topbar" {$form_top} data-pageid="{$pageid}" >		
	 
				<div class="row">
			 
				<div 
	data-cellId="top_c1" data-pageid="{$pageid}" data-page="jobsjobs_list"	{$cell_top_c1}
	class=" r-ori-vert			col-md-12
	
">
		 
		{BEGIN menuitems_categories}
<ul data-itemtype="menu" data-itemid="menu1" {$item_menu1} data-pageid="{$pageid}"	class="r-menu nav navbar-nav" 
	data-menulevel="1"
>

{BEGIN item_children1}
<li class="
	{BEGIN item_haschildren2} dropdown {END item_haschildren2} 
	{$item_current}">
<a {$item_attrs} title="{$item_tooltip}" data-menu-link data-menu-h data-menu-top >
	{$item_separator}
	<span class="r-menu-link  "> 
		<span class="r-menu-title">
		{$item_icon} {$item_title}
		</span>
		{BEGIN item_haschildren2}
		{BEGIN item_expand_icon}
		<span class="r-menu-expand-icon glyphicon glyphicon-triangle-bottom"></span>
		<span class="r-menu-mobile-expand-icon fa fa-angle-left"></span>
		{END item_expand_icon}
		{END item_haschildren2}
	</span>
	</a>
{BEGIN item_showchildren2}
<ul class="
			dropdown-menu
			{$submenu_class}" 
		id="submenu{$item_id}" data-menulevel="2">
	{BEGIN item_children2}
		{BEGIN item_menulink2}
		<li class="
						{BEGIN item_haschildren2} dropdown {END item_haschildren2}
						{$item_current}"
		>
			<a {$item_attrs} title="{$item_tooltip}" data-menu-link data-menu-h >
	{$item_separator}
	<span class="r-menu-link  "> 
		<span class="r-menu-title">
		{$item_icon} {$item_title}
		</span>
		{BEGIN item_haschildren2}
		{BEGIN item_expand_icon}
		<span class="r-menu-expand-icon glyphicon glyphicon-triangle-right"></span>
		<span class="r-menu-mobile-expand-icon fa fa-angle-left"></span>
		{END item_expand_icon}
		{END item_haschildren2}
	</span>
	</a>
			{BEGIN item_showchildren3}
<ul class="
			dropdown-menu
			{$submenu_class}" 
		id="submenu{$item_id}" data-menulevel="3">
	{BEGIN item_children3}
		{BEGIN item_menulink3}
		<li class="
						{BEGIN item_haschildren3} dropdown {END item_haschildren3}
						{$item_current}"
		>
			<a {$item_attrs} title="{$item_tooltip}" data-menu-link data-menu-h >
	{$item_separator}
	<span class="r-menu-link  "> 
		<span class="r-menu-title">
		{$item_icon} {$item_title}
		</span>
		{BEGIN item_haschildren3}
		{BEGIN item_expand_icon}
		<span class="r-menu-expand-icon glyphicon glyphicon-triangle-right"></span>
		<span class="r-menu-mobile-expand-icon fa fa-angle-left"></span>
		{END item_expand_icon}
		{END item_haschildren3}
	</span>
	</a>
			{BEGIN item_showchildren4}
<ul class="
			dropdown-menu
			{$submenu_class}" 
		id="submenu{$item_id}" data-menulevel="4">
	{BEGIN item_children4}
		{BEGIN item_menulink4}
		<li class="
						{BEGIN item_haschildren4} dropdown {END item_haschildren4}
						{$item_current}"
		>
			<a {$item_attrs} title="{$item_tooltip}" data-menu-link data-menu-h >
	{$item_separator}
	<span class="r-menu-link  "> 
		<span class="r-menu-title">
		{$item_icon} {$item_title}
		</span>
		{BEGIN item_haschildren4}
		{BEGIN item_expand_icon}
		<span class="r-menu-expand-icon glyphicon glyphicon-triangle-right"></span>
		<span class="r-menu-mobile-expand-icon fa fa-angle-left"></span>
		{END item_expand_icon}
		{END item_haschildren4}
	</span>
	</a>
			{BEGIN item_showchildren5}
<ul class="
			dropdown-menu
			{$submenu_class}" 
		id="submenu{$item_id}" data-menulevel="5">
	{BEGIN item_children5}
		{BEGIN item_menulink5}
		<li class="
						{BEGIN item_haschildren5} dropdown {END item_haschildren5}
						{$item_current}"
		>
			<a {$item_attrs} title="{$item_tooltip}" data-menu-link data-menu-h >
	{$item_separator}
	<span class="r-menu-link  "> 
		<span class="r-menu-title">
		{$item_icon} {$item_title}
		</span>
		{BEGIN item_haschildren5}
		{BEGIN item_expand_icon}
		<span class="r-menu-expand-icon glyphicon glyphicon-triangle-right"></span>
		<span class="r-menu-mobile-expand-icon fa fa-angle-left"></span>
		{END item_expand_icon}
		{END item_haschildren5}
	</span>
	</a>
					</li>
		{END item_menulink5}
	{END item_children5}
</ul>
{END item_showchildren5}
		</li>
		{END item_menulink4}
	{END item_children4}
</ul>
{END item_showchildren4}
		</li>
		{END item_menulink3}
	{END item_children3}
</ul>
{END item_showchildren3}
		</li>
		{END item_menulink2}
	{END item_children2}
</ul>
{END item_showchildren2}
</li>
{END item_children1}
</ul>
{END menuitems_categories}
		</div>					</div>
			</div>		
{END top_block}
					</div>
					</div>
					
					
					
					
					
				<div class="r-content">
										<div class="r-left" {$blockattr_left} {$form_left} >
										{BEGIN left_block}

<table class="r-fluid r-form" data-location="left" id="form_left_{$pageid}" data-makeup="topbar" {$form_left} data-pageid="{$pageid}" >
						<tbody>
			
								<tr {$row_left_0} >
									<td 
	class=" r-ori-vert			"
			 
	data-cellId="left_c1" data-pageid="{$pageid}">
 
<!-- Begin Search panel content -->
<div class="searchOptions panel panel-primary searchPanelContainer " {$srchOpt_attrs} data-itemtype="search_panel" data-itemid="search_panel" {$item_search_panel} data-pageid="{$pageid}"	 >

	<div class="panel-heading">
		<div class="btn-group r-sp-addfield" id="addSearchFieldButton{$id}">
			<button id="showHideControlChooseMenu{$id}" type="button" class="btn btn-default dropdown-toggle btn-sm )" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
			Search in			<span class="caret"></span>
			</button>
		</div>


		<div class="btn-group r-sp-options" id="searchPanelOptions{$id}">
			<button type="button" class="btn btn-default dropdown-toggle btn-sm" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
				<span class="glyphicon glyphicon glyphicon-option-vertical"></span>
			</button>
			<ul class="dropdown-menu dropdown-left">
				<li id="showHideSearchType{$id}" {$showHideCtrlsOpt_attrs}><a>Show options</a></li>
				<li role="separator" class="divider"></li>
				<li class="srchCritTop" style="display: none;"><a><input type="radio" name="srchType{$id}" id="radioAll" {$all_checkbox}><label for="radioAll"><span class="glyphicon">&nbsp;</span>all conditions</label></a></li>
				<li class="srchCritTop" style="display: none;"><a><input type="radio" name="srchType{$id}" id="radioAny" {$any_checkbox}><label for="radioAny"><span class="glyphicon">&nbsp;</span>any condition</label></a></li>
				<li role="separator" class="divider"></li>
				<li><a class="close-button"><span class="glyphicon glyphicon-remove">&nbsp;</span>hide</a></li>
			</ul>
		</div>


		</div>
	<div class="panel-body controlsBlock" {$bottomSearchButt_attrs} >


		
		{BEGIN searchCtrlBlock}
		<div class="srchPanelRow form-group" {$filterRow_attrs}>
			<label>{$fLabel}</label>	{$delCtrlButt}
				<span class="rnr-searchtype">{$searchtype}</span>
				<span class="rnr-searchcontrol">{$searchcontrol}</span>
				<span class="rnr-searchcontrol">{$searchcontrol1}</span>
		</div>
		{END searchCtrlBlock}
																		{BEGIN searchCtrlBlock_employer_businessname}


		<div class="form-group srchPanelRow {$filterRow_class_employer_businessname}" {$filterRow_attrs_employer_businessname}>
			<label>{$label jobsjobs employer_businessname }</label>

							{$delCtrlButt}
			
								<span class="rnr-searchtype">{$searchtype_employer_businessname}</span>
								<span class="rnr-searchcontrol">{$searchcontrol_employer_businessname}</span>
								<span class="rnr-searchcontrol">{$searchcontrol1_employer_businessname}</span>
						</div>
		{END searchCtrlBlock_employer_businessname}
																{BEGIN searchCtrlBlock_LogoURL}


		<div class="form-group srchPanelRow {$filterRow_class_LogoURL}" {$filterRow_attrs_LogoURL}>
			<label>{$label jobsjobs LogoURL }</label>

							{$delCtrlButt}
			
								<span class="rnr-searchtype">{$searchtype_LogoURL}</span>
								<span class="rnr-searchcontrol">{$searchcontrol_LogoURL}</span>
								<span class="rnr-searchcontrol">{$searchcontrol1_LogoURL}</span>
						</div>
		{END searchCtrlBlock_LogoURL}
																{BEGIN searchCtrlBlock_Zip}


		<div class="form-group srchPanelRow {$filterRow_class_Zip}" {$filterRow_attrs_Zip}>
			<label>{$label jobsjobs Zip }</label>

							{$delCtrlButt}
			
								<span class="rnr-searchtype">{$searchtype_Zip}</span>
								<span class="rnr-searchcontrol">{$searchcontrol_Zip}</span>
								<span class="rnr-searchcontrol">{$searchcontrol1_Zip}</span>
						</div>
		{END searchCtrlBlock_Zip}
																{BEGIN searchCtrlBlock_Website}


		<div class="form-group srchPanelRow {$filterRow_class_Website}" {$filterRow_attrs_Website}>
			<label>{$label jobsjobs Website }</label>

							{$delCtrlButt}
			
								<span class="rnr-searchtype">{$searchtype_Website}</span>
								<span class="rnr-searchcontrol">{$searchcontrol_Website}</span>
								<span class="rnr-searchcontrol">{$searchcontrol1_Website}</span>
						</div>
		{END searchCtrlBlock_Website}
																{BEGIN searchCtrlBlock_state}


		<div class="form-group srchPanelRow {$filterRow_class_state}" {$filterRow_attrs_state}>
			<label>{$label jobsjobs state }</label>

							{$delCtrlButt}
			
								<span class="rnr-searchtype">{$searchtype_state}</span>
								<span class="rnr-searchcontrol">{$searchcontrol_state}</span>
								<span class="rnr-searchcontrol">{$searchcontrol1_state}</span>
						</div>
		{END searchCtrlBlock_state}
																{BEGIN searchCtrlBlock_HowToApply}


		<div class="form-group srchPanelRow {$filterRow_class_HowToApply}" {$filterRow_attrs_HowToApply}>
			<label>{$label jobsjobs HowToApply }</label>

							{$delCtrlButt}
			
								<span class="rnr-searchtype">{$searchtype_HowToApply}</span>
								<span class="rnr-searchcontrol">{$searchcontrol_HowToApply}</span>
								<span class="rnr-searchcontrol">{$searchcontrol1_HowToApply}</span>
						</div>
		{END searchCtrlBlock_HowToApply}
																{BEGIN searchCtrlBlock_Description}


		<div class="form-group srchPanelRow {$filterRow_class_Description}" {$filterRow_attrs_Description}>
			<label>{$label jobsjobs Description }</label>

							{$delCtrlButt}
			
								<span class="rnr-searchtype">{$searchtype_Description}</span>
								<span class="rnr-searchcontrol">{$searchcontrol_Description}</span>
								<span class="rnr-searchcontrol">{$searchcontrol1_Description}</span>
						</div>
		{END searchCtrlBlock_Description}
																{BEGIN searchCtrlBlock_Country}


		<div class="form-group srchPanelRow {$filterRow_class_Country}" {$filterRow_attrs_Country}>
			<label>{$label jobsjobs Country }</label>

							{$delCtrlButt}
			
								<span class="rnr-searchtype">{$searchtype_Country}</span>
								<span class="rnr-searchcontrol">{$searchcontrol_Country}</span>
								<span class="rnr-searchcontrol">{$searchcontrol1_Country}</span>
						</div>
		{END searchCtrlBlock_Country}
																{BEGIN searchCtrlBlock_SubCategory}


		<div class="form-group srchPanelRow {$filterRow_class_SubCategory}" {$filterRow_attrs_SubCategory}>
			<label>{$label jobsjobs SubCategory }</label>

							{$delCtrlButt}
			
								<span class="rnr-searchtype">{$searchtype_SubCategory}</span>
								<span class="rnr-searchcontrol">{$searchcontrol_SubCategory}</span>
								<span class="rnr-searchcontrol">{$searchcontrol1_SubCategory}</span>
						</div>
		{END searchCtrlBlock_SubCategory}
																{BEGIN searchCtrlBlock_TypeID}


		<div class="form-group srchPanelRow {$filterRow_class_TypeID}" {$filterRow_attrs_TypeID}>
			<label>{$label jobsjobs TypeID }</label>

							{$delCtrlButt}
			
								<span class="rnr-searchtype">{$searchtype_TypeID}</span>
								<span class="rnr-searchcontrol">{$searchcontrol_TypeID}</span>
								<span class="rnr-searchcontrol">{$searchcontrol1_TypeID}</span>
						</div>
		{END searchCtrlBlock_TypeID}
		

	</div>

	<div class="panel-footer bottomSearchButt" {$bottomSearchButt_attrs}>
		<button class="btn btn-primary btn-sm" id="searchButton{$id}" {$searchbutton_attrs}>Search</button>

				<button class="btn btn-default btn-sm" {$showAllCont_attrs} {$showallbutton_attrs}>Show all</button>
	</div>
</div>
<!-- End Search panel content -->
</td>
							</tr>
											<tr {$row_left_1} >
									<td 
	class=" r-ori-vert			"
			 
	data-cellId="left_c2" data-pageid="{$pageid}">
</td>
							</tr>
					
					</tbody>
				</table>
{END left_block}
						</div>
										<div class="r-data-block" data-body-width="standard" >
						
											<div class="r-above">
					{BEGIN above-grid_block}
<div class="r-form" data-location="above-grid" id="form_above-grid_{$pageid}" data-makeup="topbar" {$form_above-grid} data-pageid="{$pageid}" >		
	 
				<div class="row">
			 
				<div 
	data-cellId="above-grid_c1" data-pageid="{$pageid}"	{$cell_above-grid_c1}
	class="			col-md-12
	
">
		{BEGIN firstAboveGridCell}
		 
		{BEGIN breadcrumb}
<ol class="breadcrumb" data-itemtype="breadcrumb" data-itemid="breadcrumb" {$item_breadcrumb} data-pageid="{$pageid}">
<li ><a href="{$crumb_home_link}"><span class="glyphicon glyphicon-home"></span></a>{$crumb_dropdown}</li>
{BEGIN crumb}
  <li class="{$crumb_item_class}">
{BEGIN crumb_title_link}
	<a {$crumb_attrs}>{$crumb_title}</a>
{END crumb_title_link}
{BEGIN crumb_title_span}
	<span {$crumb_attrs}>{$crumb_title}</span>
{END crumb_title_span}	
	{$crumb_dropdown}
  </li>
{END crumb}
</ol>
{END breadcrumb}	 
		<span data-itemtype="details_found" data-itemid="details_found" {$item_details_found} data-pageid="{$pageid}" data-small >
{$mlp_push}{$mlparam first var first_shown}{$mlparam last var last_shown}{$mlparam total var records_found}{mlang_message DISPLAYING}{$mlp_pop}</span>	 
		<span data-itemtype="page_size" data-itemid="page_size" {$item_page_size} data-pageid="{$pageid}" >
		{$recsPerPage}
</span>	 
		{BEGIN saveall_link}
<span data-itemtype="inline_save_all" data-itemid="inline_save_all" {$item_inline_save_all} data-pageid="{$pageid}" data-small data-button-item>
	<a type="button" title="" class="btn btn-primary   
	" {$savealllink_attrs} {$savealllink_span} >
							Save all			</a>
</span>
{END saveall_link}
	 
		{BEGIN cancelall_link}
<span data-itemtype="inline_cancel_all" data-itemid="inline_cancel_all" {$item_inline_cancel_all} data-pageid="{$pageid}" data-small data-button-item>
	<a type="button" title="" class="btn btn-default   
	" {$cancelalllink_attrs} {$cancelalllink_span} >
							Cancel			</a>
</span>
{END cancelall_link}
			{END firstAboveGridCell}	
	</div>					</div>
			 
				<div class="row">
			 
				<div 
	data-cellId="above-grid_c2" data-pageid="{$pageid}"	{$cell_above-grid_c2}
	class=" r-ori-vert			col-md-6
	
">
			</div>			 
				<div 
	data-cellId="above-grid_c3" data-pageid="{$pageid}"	{$cell_above-grid_c3}
	class="r-align-right r-ori-vert			col-md-6
	
">
		 
		{BEGIN print_friendly}
<span id="printpanelblock{$id}"  data-pageid="{$pageid}" {$printpanel_hiddenattr} data-itemtype="print_panel" data-itemid="print_panel" {$item_print_panel} data-pageid="{$pageid}">
	<button title="Print-friendly page" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
					<span class="glyphicon glyphicon-print"></span>
				<span class="caret"></span>
	</button>
	<ul class="dropdown-menu pull-right">
					</ul>
</span>
{END print_friendly}
		</div>					</div>
			 
				<div class="row">
			 
				<div 
	data-cellId="above-grid_c4" data-pageid="{$pageid}"	{$cell_above-grid_c4}
	class="			col-md-12
	
">
		 
		<span data-itemtype="snippet" data-itemid="category_text" {$item_category_text} data-pageid="{$pageid}" >
{$event category_text}
</span>	 
		<span data-itemtype="custom_button" data-itemid="custom_button" {$item_custom_button} data-pageid="{$pageid}" data-small data-button-item>
	<a type="button" title="" class="btn btn-success   
	" id="Email_Selected" href="javascript:void(0)" typeid="ib" >
					<span class="glyphicon glyphicon-envelope"></span>
							Email Selected			</a>
</span>
		</div>					</div>
			 
				<div class="row">
			 
				<div 
	data-cellId="above-grid_c" data-pageid="{$pageid}"	{$cell_above-grid_c}
	class=" r-ori-vert			col-md-12
	
">
		 
		{BEGIN add_link}
<span data-itemtype="add" data-itemid="add" {$item_add} data-pageid="{$pageid}" data-small data-button-item>
	<a type="button" title="" class="btn btn-primary   
	" {$addlink_attrs} href="jobsjobs_add.php{$stateLink_full}" >
							Add new			</a>
</span>
{END add_link}
		</div>					</div>
			</div>		
{END above-grid_block}
	</div>
<div class="r-grid">
	{BEGIN grid_tabs}
  <ul class="nav nav-tabs bsgrid_tabs">
	{$grid_tabs_content}
  </ul>
{END grid_tabs}

	
	
			
<!-- ananei-->


<!-- ✅ DASHBOARD AREA -->
<br>
<div class="dashboard-filters" id="dashboardFilters"style="text-align:center;">
  <button id="filterAll" class="filter-btn blue">📊 All Data</button>
<!--  <button id="filterMonth" class="filter-btn green">🗓 This Month</button> -->
<!--  <button id="filter12mo" class="filter-btn purple">📅 Last 12 Months</button> -->
  <button id="downloadBtn">⬇️ Download</button>
</div>
<!-- Load Chart.js and the Data Labels plugin -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>
<div class="chart-container-user-posted dashboard-chart-wrapper" id="dashboardCharts">
  <h3 style="text-align:center;">
    User-Posted Jobs by Location – {$filter_label}
    <span style="font-size: 16px; color: #666;">(Total: {$chart_total})</span>
  </h3>
  <canvas id="productChart" width="900" height="220"></canvas>
</div>

<div class="dashboard" id="dashboard">
<!-- GOVT -->
  <!-- Flip Card Template -->
  <div class="flip-card draggable" id="card_govt">
    <div class="flip-card-inner" id="govt_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟩</span>
            <strong>Government Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_govt', 'govt_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="govtChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="govt_active_pct"></span> {$govt_active}</div>
          <div><span class="dot expired"></span> <span id="govt_expired_pct"></span> {$govt_expired7}</div>
          <div><span class="dot archived"></span> <span id="govt_archived_pct"></span> {$govt_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟩</span>
            <strong>Government Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_govt', 'govt_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
        These jobs are posted by government ministries or agencies. Most roles have fixed expiry dates and are managed via official HR systems.
        </div>

        </div>
      </div>
    </div>

  <!-- sprep -->
  <div class="flip-card draggable" id="card_sprep">
    <div class="flip-card-inner" id="sprep_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟧</span>
            <strong>SPREP Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_sprep', 'sprep_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="sprepChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="sprep_active_pct"></span> {$sprep_active}</div>
          <div><span class="dot expired"></span> <span id="sprep_expired_pct"></span> {$sprep_expired7}</div>
          <div><span class="dot archived"></span> <span id="sprep_archived_pct"></span> {$sprep_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟧</span>
            <strong>SPREP Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_sprep', 'sprep_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Jobs posted by the Secretariat of the Pacific Regional Environment Programme. Often focused on climate, conservation, and sustainability.
</div>

      </div>
    </div>
  </div>
 
    <!-- spc -->
  <div class="flip-card draggable" id="card_spc">
    <div class="flip-card-inner" id="spc_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟪</span>
            <strong>SPC Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_spc', 'spc_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="spcChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="spc_active_pct"></span> {$spc_active}</div>
          <div><span class="dot expired"></span> <span id="spc_expired_pct"></span> {$spc_expired7}</div>
          <div><span class="dot archived"></span> <span id="spc_archived_pct"></span> {$spc_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟪</span>
            <strong>SPC Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_spc', 'spc_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Positions offered by the Pacific Community (SPC), covering health, education, agriculture, and regional development sectors.
</div>

      </div>
    </div>
  </div>
 
    <!-- undp -->
  <div class="flip-card draggable" id="card_undp">
    <div class="flip-card-inner" id="undp_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟥</span>
            <strong>UNDP Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_undp', 'undp_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="undpChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="undp_active_pct"></span> {$undp_active}</div>
          <div><span class="dot expired"></span> <span id="undp_expired_pct"></span> {$undp_expired7}</div>
          <div><span class="dot archived"></span> <span id="undp_archived_pct"></span> {$undp_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟥</span>
            <strong>UNDP Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_undp', 'undp_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Vacancies from the United Nations Development Programme. These often involve policy, climate resilience, or technical advisory roles.
</div>

      </div>
    </div>
  </div>
 
    <!-- pifs -->
  <div class="flip-card draggable" id="card_pifs">
    <div class="flip-card-inner" id="pifs_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟨</span>
            <strong>PIFS Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_pifs', 'pifs_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="pifsChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="pifs_active_pct"></span> {$pifs_active}</div>
          <div><span class="dot expired"></span> <span id="pifs_expired_pct"></span> {$pifs_expired7}</div>
          <div><span class="dot archived"></span> <span id="pifs_archived_pct"></span> {$pifs_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟨</span>
            <strong>PIFS Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_pifs', 'pifs_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Jobs listed by the Pacific Islands Forum Secretariat. Focused on regional cooperation, diplomacy, and policy development.
</div>

      </div>
    </div>
  </div>
 
   <!-- ffa -->
  <div class="flip-card draggable" id="card_ffa">
    <div class="flip-card-inner" id="ffa_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🪟</span>
            <strong>FFA Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_ffa', 'ffa_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="ffaChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="ffa_active_pct"></span> {$ffa_active}</div>
          <div><span class="dot expired"></span> <span id="ffa_expired_pct"></span> {$ffa_expired7}</div>
          <div><span class="dot archived"></span> <span id="ffa_archived_pct"></span> {$ffa_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🪟</span>
            <strong>FFA Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_ffa', 'ffa_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Roles from the Pacific Islands Forum Fisheries Agency, often technical and regional in nature, especially fisheries compliance and policy.
</div>

      </div>
    </div>
  </div>
 
    <!-- pjn -->
  <div class="flip-card draggable" id="card_pjn">
    <div class="flip-card-inner" id="pjn_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">📂</span>
            <strong>Pacific Vacancies Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_pjn', 'pjn_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="pjnChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="pjn_active_pct"></span> {$pjn_active}</div>
          <div><span class="dot expired"></span> <span id="pjn_expired_pct"></span> {$pjn_expired7}</div>
          <div><span class="dot archived"></span> <span id="pjn_archived_pct"></span> {$pjn_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Text -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">📂</span>
            <strong>Pacific Vacancies Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_pjn', 'pjn_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Curated job opportunities from multiple Pacific organizations and private sectors, collected to support regional talent access.
</div>

      </div>
    </div>
  </div>
 
    <!-- user -->
  <!-- Flip Card Template -->
  <div class="flip-card draggable" id="card_user">
    <div class="flip-card-inner" id="user_inner">
      <!-- FRONT: Chart Summary -->
      <div class="flip-card-front">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟦</span>
            <strong>User-Posted Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_user', 'user_inner')"></button>
            <small class="pin-label"></small>
            <span class="drag-icon" title="Drag"></span>
          </div>
        </div>
        <div class="chart-center">
          <canvas id="userChart"></canvas>
        </div>
        <div class="chart-legend-stats">
          <div><span class="dot active"></span> <span id="user_active_pct"></span> {$user_active}</div>
          <div><span class="dot expired"></span> <span id="user_expired_pct"></span> {$user_expired7}</div>
          <div><span class="dot archived"></span> <span id="user_archived_pct"></span> {$user_archived}</div>
        </div>
      </div>
      <!-- BACK: Info Description -->
      <div class="flip-card-back">
        <div class="card-header">
          <div style="display:flex;align-items:center;gap:6px;">
            <span class="job-source-icon">🟦</span>
            <strong>User-Posted Jobs</strong>
          </div>
          <div class="pin-control">
            <button class="pin-btn" onclick="togglePin(this, 'card_user', 'user_inner')">📌</button>
            <small class="pin-label">Pin to stop flip</small>
            <span class="drag-icon" title="Drag">⤧</span>
          </div>
        </div>
        <div class="card-description">
Jobs manually submitted by employers or recruiters on this platform. These listings follow platform expiry, extension, and archive rules.
</div>

      </div>
    </div>
  </div>
</div>

<!-- 📢 Job Feed Disclaimer & Guest Prompt -->
<div id="disclaimerPopup" class="disclaimer-popup-centered">
  <div class="popup-content">
    <h4 style="margin-bottom: 4px;">📢 Job Sources & Feed <i class="fas fa-info-circle"></i> Disclaimer</h4>
    <small style="font-size: 12px; color: #666;">Transparency notice for all listed opportunities</small>

    <p>This live feed highlights job opportunities from the career pages of regional organizations like SPREP, SPC, PIFS, FFA, and UNDP, government listings from the Samoa Public Service Commission (PSC), and postings from government-owned corporations. It also includes remote global live-feed API job listings from platforms like the Himalayas.</p>

    <p>These listings help jobseekers discover local, regional, and international employment opportunities. Please note that all application procedures, rights, and recruitment decisions are the sole responsibility of the respective hiring organizations or agencies.</p>

    <hr style="margin: 10px 0;">

    <p style="font-weight: bold; font-size: 14px;">👋 Welcome, Guest!</p>
    <p 🧑‍💼 style="font-size: 13px;">To apply for jobs posted by <strong>Private Sector Employers</strong> or receive alerts for <strong>Public Sector</strong> opportunities listed on this platform, please register below:</p>

    <div class="guest-popup-buttons" style="display: flex; gap: 10px; margin-bottom: 12px;">
      <button onclick="openModal('register.php?page=register_jobseeker')" class="btn btn-sm btn-primary">Jobseeker Register</button>
      <button onclick="openModal('register.php?page=register_employer')" class="btn btn-sm btn-success">Employer Register</button>
    </div>
   
    <div style="margin-top: 10px; display: flex; align-items: center; gap: 8px;">
    <input type="checkbox" id="dontShowAgain" style="transform: scale(1.2);" />
    <label for="dontShowAgain" style="font-size: 13px;">Don’t show this again for 7 days</label>
    </div>
   
    <button class="btn btn-sm btn-secondary" onclick="toggleDisclaimerPopup()">Close</button>
  </div>
</div>

<!-- 🌐 Collapsible Floating Panel -->
<div id="floatingPanel" class="floating-panel collapsed">
  <button class="panel-toggle" onclick="togglePanel()">☰</button>

 <div class="panel-buttons">
    <button onclick="toggleDisclaimerPopup()">Disclaimer ℹ️</button>
    </div>
</div>

<div class="custom-jobs-grid">{$job_cards}</div>
<div class="custom-external-jobs-wrapper">{$external_jobs}</div>

<!--end-ananei -->
	
<div class="r-below">
					{BEGIN below-grid_block}
<div class="r-form" data-location="below-grid" id="form_below-grid_{$pageid}" data-makeup="topbar" {$form_below-grid} data-pageid="{$pageid}" >		
	 
				<div class="row">
			 
				<div 
	data-cellId="below-grid_c" data-pageid="{$pageid}"	{$cell_below-grid_c}
	class="r-align-center r-ori-vert			col-md-12
	
">
		 
		{BEGIN pagination_block}
<span data-itemtype="pagination" data-itemid="pagination" {$item_pagination} data-pageid="{$pageid}" >
{$pagination}
</span>
{END pagination_block}
		</div>					</div>
			</div>		
{END below-grid_block}
	</div>

					</div>
				</div>
			</div>
		</div>
		

<!-- script start -->

<script>
// 🔍 On scroll, resize the logo for a sleek effect
window.addEventListener("scroll", function () {
  const logo = document.querySelector(".logo");     // Logo image element
  const header = document.querySelector("header");  // Main page header

  // 🎯 If user scrolls down more than 80px, shrink the logo
  if (window.scrollY > 80) {
    logo.style.transform = "scale(0.8)";
  } else {
    logo.style.transform = "scale(1)";
  }
});
</script>

<script>
function scrollToTop() {
  window.scrollTo({
    top: 0,
    behavior: 'smooth'
  });
  const header = document.querySelector("header");
  // 👇 Add a glow or bounce effect when header becomes visible
  header.classList.add("highlight-top");
  // Remove the class after animation ends (1 second)
  setTimeout(() => {
    header.classList.remove("highlight-top");
  }, 900);
}
</script>



<script>
// 🎯 Toggle popup and store dismiss state
function toggleDisclaimerPopup() {
  const popup = document.getElementById("disclaimerPopup");
  const trigger = document.getElementById("disclaimerTrigger");
  const dontShow = document.getElementById("dontShowAgain");
  const toast = document.getElementById("toastDisclaimer");

  const isHidden = popup.style.display === "none" || !popup.style.display;
  popup.style.display = isHidden ? "block" : "none";
  trigger.style.display = isHidden ? "none" : "block";

  if (!isHidden) {
    const dismissUntil = dontShow?.checked
      ? Date.now() + 7 * 24 * 60 * 60 * 1000 // 7 days
      : Date.now() + 1 * 60 * 60 * 1000;     // 1 hour

    localStorage.setItem("jobDisclaimerDismissedUntil", dismissUntil);

    // ✅ Show toast if checkbox was ticked
    if (dontShow?.checked && toast) {
      toast.style.display = "block";
      setTimeout(() => {
        toast.style.display = "none";
      }, 4000); // hide after 4 seconds
    }
  }
}

document.addEventListener("DOMContentLoaded", function () {
  const jobCards = document.getElementById("jobsContainer");
  const externalJobs = document.querySelector(".external-jobs-wrapper");
  const popup = document.getElementById("disclaimerPopup");
  const trigger = document.getElementById("disclaimerTrigger");

  const hasJobs = jobCards && jobCards.innerHTML.trim() !== "";
  const hasExternal = externalJobs && externalJobs.innerHTML.trim() !== "";

  const storedTime = localStorage.getItem("jobDisclaimerDismissedUntil");
  const now = Date.now();

  const isDismissed = storedTime && parseInt(storedTime) > now;

  if (!hasJobs && !hasExternal) {
    popup.style.display = "none";
    trigger.style.display = "none";
  } else {
    popup.style.display = isDismissed ? "none" : "block";
    trigger.style.display = isDismissed ? "block" : "none";
  }
});
</script>


<script>
// 🔁 Toggle between showing preview and full description in job cards
function toggleDescription(link) {
  // 🔍 Find the preview and full description elements
  const preview = link.previousElementSibling.previousElementSibling; // The short preview
  const full = link.previousElementSibling;                           // The full description

  // 🎭 Show or hide full/preview description
  if (full.style.display === "none") {
    preview.style.display = "none";      // Hide preview
    full.style.display = "inline";       // Show full text
    link.textContent = "Show less";      // Update link text
  } else {
    preview.style.display = "inline";    // Show preview again
    full.style.display = "none";         // Hide full description
    link.textContent = "Read more";      // Reset link text
  }
}
</script>

<script>
// ❌ Close the guest welcome popup
function closeGuestPopup() {
  const popup = document.getElementById("guestPopup");
  popup.style.display = "none";
}
</script>

<!-- Script No user-posted JObs -->
<script>
function dismissNoJobs() {
  const alert = document.getElementById('noJobsAlert');
  alert.style.opacity = '0';
  alert.style.transform = 'translateY(-20px)';
  setTimeout(() => alert.style.display = 'none', 400);
}
</script>

<script>
// 📊 Chart instance reference and default type
let chartInstance = null;
let currentType = 'bar';

// 📁 Chart data passed from PHP (PHPRunner variables)
const allData = {
  labels: {$chart_labels},              // X-axis labels
  values: {$chart_values},              // Y-axis values
  year: "<?php echo $selected_year ?>"  // Selected year
};

// 🔧 Main function to draw the chart
function drawChart(type = 'bar') {
  const ctx = document.getElementById('productChart').getContext('2d');

  // If a chart already exists, destroy it before redrawing
  if (chartInstance) chartInstance.destroy();

  // Create new chart
chartInstance = new Chart(ctx, {
    type: type,
    data: {
      labels: allData.labels,
      datasets: [{
        label: '',
        data: allData.values,
        backgroundColor: [
          '#007BFF', '#28A745', '#DC3545', '#FFC107', '#6F42C1', '#17A2B8'
        ],
        borderRadius: 6
      }]
    },
    options: {
      responsive: true,
      plugins: {
        // 🎯 Show labels directly on top of bars (if bar chart)
        datalabels: {
          display: type === 'bar',
          anchor: 'end',
          align: 'top',
          font: {
            weight: 'bold'
          }
        },
        legend: {
          display: type !== 'bar' // Only show legend for non-bar charts
        },
        title: {
          display: false // Title is hidden (you can enable it if you want)
        }
      },
      animation: {
        duration: 1000,
        easing: 'easeOutBounce'
      },
      scales: type === 'bar' ? {
        y: {
          beginAtZero: true
        }
      } : {} // No Y-axis if not bar
    },
    plugins: [ChartDataLabels]
  });
}


// 🔄 Toggle between bar and pie chart views
function toggleChartType() {
  currentType = currentType === 'bar' ? 'pie' : 'bar';
  drawChart(currentType);
}

// ⬇️ Export the chart as a PNG image
function downloadChart() {
  const link = document.createElement('a');
  link.download = 'product_chart.png';
  link.href = chartInstance.toBase64Image(); // Convert chart to image
  link.click();
}

// 📅 Apply year-based filter to reload the page with a query string
function filterByYear(year) {
  if (year === "all") {
    window.location.href = window.location.pathname;
  } else {
    const params = new URLSearchParams(window.location.search);
    params.set('year', year);
    window.location.search = params.toString();
  }
}

// 🧠 Draw chart after page is fully loaded
document.addEventListener("DOMContentLoaded", () => {
  drawChart();
});
</script>

<!-- 📊 SCRIPT: Initialize All Charts -->
<script>
document.addEventListener("DOMContentLoaded", function () {
  const charts = [
    { id: "govtChart", data: [{$govt_active_raw}, {$govt_expired7_raw}, {$govt_archived_raw}], prefix: 'govt' },
    { id: "sprepChart", data: [{$sprep_active_raw}, {$sprep_expired7_raw}, {$sprep_archived_raw}], prefix: 'sprep' },
    { id: "spcChart", data: [{$spc_active_raw}, {$spc_expired7_raw}, {$spc_archived_raw}], prefix: 'spc' },
    { id: "undpChart", data: [{$undp_active_raw}, {$undp_expired7_raw}, {$undp_archived_raw}], prefix: 'undp' },
    { id: "pifsChart", data: [{$pifs_active_raw}, {$pifs_expired7_raw}, {$pifs_archived_raw}], prefix: 'pifs' },
    { id: "ffaChart", data: [{$ffa_active_raw}, {$ffa_expired7_raw}, {$ffa_archived_raw}], prefix: 'ffa' },
    { id: "pjnChart", data: [{$pjn_active_raw}, {$pjn_expired7_raw}, {$pjn_archived_raw}], prefix: 'pjn' },
    { id: "userChart", data: [{$user_active_raw}, {$user_expired7_raw}, {$user_archived_raw}], prefix: 'user' },
    { id: "himalayasChart", data: [0, 0, 0] }
  ];

    charts.forEach(({ id, data, prefix }) => {
    const ctx = document.getElementById(id);
    if (!ctx) return;

    const total = data.reduce((a, b) => a + b, 0);
    const percentages = data.map(v => total > 0 ? ((v / total) * 100).toFixed(1) + '%' : '0%');

    if (prefix) {
      const activeEl = document.getElementById(`${prefix}_active_pct`);
      const expiredEl = document.getElementById(`${prefix}_expired_pct`);
      const archivedEl = document.getElementById(`${prefix}_archived_pct`);
      if (activeEl) activeEl.textContent = percentages[0];
      if (expiredEl) expiredEl.textContent = percentages[1];
      if (archivedEl) archivedEl.textContent = percentages[2];
    }

    new Chart(ctx, {
      type: 'doughnut',
      data: {
        labels: ["Active", "Expired", "Archived"],
        datasets: [{
          data: data,
          backgroundColor: ["#34a853", "#ea4335", "#9aa0a6"],
          borderWidth: 0
        }]
      },
      options: {
        plugins: {
          legend: { display: false },
          datalabels: {
            color: '#fff',
            font: { weight: 'bold', size: 12 },
            formatter: (value, ctx) => {
              const sum = ctx.chart.data.datasets[0].data.reduce((a, b) => a + b, 0);
              return sum ? Math.round((value / sum) * 100) + '%' : '';
            }
          }
        },
        cutout: "70%",
        responsive: true,
        maintainAspectRatio: false
      },
      plugins: [ChartDataLabels]
    });
  });
});
</script>

<!-- 📌 DRAG + PIN SCRIPT -->
<script>
function togglePin(button, cardId, innerId) {
  const card = document.getElementById(cardId);
  const inner = document.getElementById(innerId);
  const label = button.nextElementSibling;

  if (inner.classList.contains("pinned")) {
    inner.classList.remove("pinned");
    card.classList.remove("pinned");
    label.textContent = "Pin to stop flip";
    button.textContent = "";
  } else {
    inner.classList.add("pinned");
    card.classList.add("pinned");
    label.textContent = "Unpin to allow flip";
    button.textContent = "📌";
  }
}

function makeDraggable(selector) {
  const container = document.getElementById("dashboard");
  let dragged = null;

  document.querySelectorAll(selector).forEach(card => {
    card.setAttribute("draggable", true);

    card.addEventListener("dragstart", function (e) {
      dragged = this;
      e.dataTransfer.effectAllowed = "move";
      this.style.opacity = 0.5;
    });

    card.addEventListener("dragend", function () {
      this.style.opacity = 1;
    });

    card.addEventListener("dragover", function (e) {
      e.preventDefault();
      e.dataTransfer.dropEffect = "move";
    });

    card.addEventListener("drop", function (e) {
      e.preventDefault();
      if (dragged && dragged !== this) {
        const children = Array.from(container.children);
        const draggedIndex = children.indexOf(dragged);
        const targetIndex = children.indexOf(this);
        if (draggedIndex < targetIndex) {
          container.insertBefore(dragged, this.nextSibling);
        } else {
          container.insertBefore(dragged, this);
        }
      }
    });
  });
}

document.addEventListener("DOMContentLoaded", function () {
  makeDraggable(".draggable");
});
</script>

<script>
function togglePin(button, cardId, innerId) {
  const card = document.getElementById(cardId);
  const inner = document.getElementById(innerId);
  const label = button.nextElementSibling;

  if (inner.classList.contains("pinned")) {
    inner.classList.remove("pinned");
    card.classList.remove("pinned");
    label.textContent = "Pin to stop flip";
    button.textContent = "📌";
  } else {
    inner.classList.add("pinned");
    card.classList.add("pinned");
    label.textContent = "Unpin to allow flip";
    button.textContent = "📍";
  }
}
</script>

<script>
function toggleDashboardCards() {
  const dash = document.getElementById("dashboard");
  const filters = document.getElementById("dashboardFilters");
  const charts = document.getElementById("dashboardCharts");
  const btn = document.getElementById("dashToggleBtnTop");

  dash.classList.toggle("dashboard-hidden");
  filters.classList.toggle("dashboard-filters-hidden");
  charts.classList.toggle("dashboard-charts-hidden");
  charts.classList.toggle("dashboard-chart-wrapper-hidden");

  const isHidden = dash.classList.contains("dashboard-hidden");
  btn.textContent = isHidden ? "Show Dashboard" : "Hide Dashboard";
  localStorage.setItem("dashboardVisible", isHidden ? "hidden" : "visible");

  if (!isHidden) {
    window.scrollTo({ top: 0, behavior: 'smooth' });
  }
}

document.addEventListener("DOMContentLoaded", function () {
  const dash = document.getElementById("dashboard");
  const filters = document.getElementById("dashboardFilters");
  const charts = document.getElementById("dashboardCharts");
  const btn = document.getElementById("dashToggleBtnTop");

  const dashState = localStorage.getItem("dashboardVisible");
  const isInitiallyHidden = dashState === "hidden";

  if (isInitiallyHidden) {
    dash.classList.add("dashboard-hidden");
    filters.classList.add("dashboard-filters-hidden");
    charts.classList.add("dashboard-charts-hidden", "dashboard-chart-wrapper-hidden");
    btn.textContent = "Show Dashboard";
  }
});

function togglePin(button, cardId, innerId) {
  const card = document.getElementById(cardId);
  const inner = document.getElementById(innerId);
  const label = button.nextElementSibling;

  if (inner.classList.contains("pinned")) {
    inner.classList.remove("pinned");
    card.classList.remove("pinned");
    label.textContent = "Pin to stop flip";
    button.textContent = "📌";
  } else {
    inner.classList.add("pinned");
    card.classList.add("pinned");
    label.textContent = "Unpin to allow flip";
    button.textContent = "📍";
  }
}

function toggleUserPostedChart() {
  const chart = document.getElementById("dashboardCharts");
  const filtersToHide = [
    document.getElementById("filterAll"),
    document.getElementById("filterMonth"),
    document.getElementById("filter12mo"),
    document.getElementById("downloadBtn")
  ];
  const btn = document.getElementById("toggleChartBtn");

  const isHidden = chart.classList.toggle("dashboard-charts-hidden");
  chart.classList.toggle("dashboard-chart-wrapper-hidden");

  filtersToHide.forEach(el => {
    if (isHidden) {
      el.classList.add("dashboard-buttons-hidden");
    } else {
      el.classList.remove("dashboard-buttons-hidden");
    }
  });

  btn.textContent = isHidden ? "📊 Show Chart" : "📉 Hide Chart";
}
</script>


<script>
document.addEventListener("DOMContentLoaded", function () {
  const searchInput = document.getElementById("jobSearchInput");
  const floatingSearch = document.getElementById("floatingSearch");
  const resultsTray = document.getElementById("resultsTray");
  const sectionHeadings = document.querySelectorAll("h3[id^='section--']");
  const allCards = document.querySelectorAll(".job-card");

  let originalPositions = new Map();

  function escapeRegExp(string) {
    return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
  }

  function highlightText(container, regex) {
    const walker = document.createTreeWalker(container, NodeFilter.SHOW_TEXT, null, false);
    const nodesToHighlight = [];

    while (walker.nextNode()) {
      const currentNode = walker.currentNode;
      if (regex.test(currentNode.textContent)) {
        nodesToHighlight.push(currentNode);
      }
    }

    nodesToHighlight.forEach(node => {
      const parent = node.parentNode;
      const frag = document.createDocumentFragment();
      let lastIndex = 0;
      const text = node.textContent;

      text.replace(regex, (match, _, offset) => {
        const before = text.slice(lastIndex, offset);
        if (before) frag.appendChild(document.createTextNode(before));

        const mark = document.createElement('mark');
        mark.textContent = match;
        frag.appendChild(mark);

        lastIndex = offset + match.length;
      });

      const after = text.slice(lastIndex);
      if (after) frag.appendChild(document.createTextNode(after));

      parent.replaceChild(frag, node);
    });
  }

  function filterJobCards(query) {
    const cards = document.querySelectorAll(".job-card");
    const regex = new RegExp(`(${escapeRegExp(query)})`, "gi");

    cards.forEach(card => {
      const title = card.querySelector("h3")?.innerText || "";
      const company = card.querySelector("p:nth-of-type(1)")?.innerText || "";
      const desc = card.querySelector(".desc-preview, .desc-full")?.innerText || "";
      const combinedText = `${title} ${company} ${desc}`;
      const match = combinedText.toLowerCase().includes(query.toLowerCase());

      card.style.display = match || query === "" ? "block" : "none";

      // Clear old highlights
      card.querySelectorAll("mark").forEach(mark => {
        const parent = mark.parentNode;
        parent.replaceChild(document.createTextNode(mark.textContent), mark);
        parent.normalize();
      });

      if (match && query !== "") {
        highlightText(card, regex);
      }
    });

    // 🧠 Toggle section headers
    document.querySelectorAll("h3[id^='section--']").forEach(sectionHeading => {
      const sourceSlug = sectionHeading.id.replace("section--", "");
      const cardsInSection = document.querySelectorAll(".card-" + sourceSlug);
      const anyVisible = Array.from(cardsInSection).some(card => card.style.display !== "none");
      sectionHeading.style.display = anyVisible ? "block" : "none";
    });
  }

  // 🌙 Theme toggle
  document.getElementById("themeToggleBtn")?.addEventListener("click", function () {
    document.body.classList.toggle("dark-mode");
  });

  // 🔍 Search toggle
  document.getElementById("toggleSearchBtn")?.addEventListener("click", function () {
    document.getElementById("floatingSearch")?.classList.toggle("collapsed");
  });

  // ✅ Reset button - clears search
  document.getElementById("resetSearch")?.addEventListener("click", function () {
    const searchInput = document.getElementById("jobSearchInput");
    if (searchInput) {
      searchInput.value = "";
      filterJobCards("");
    }
  });

  // ❌ Close button - hides panel only
  document.getElementById("closeSearchBox")?.addEventListener("click", function () {
    document.getElementById("floatingSearch")?.classList.add("collapsed");
  });

  // 🔎 Live filter
  document.getElementById("jobSearchInput")?.addEventListener("input", function () {
    const query = this.value.trim();
    filterJobCards(query);
  });

});
</script>


<script>
document.addEventListener("DOMContentLoaded", function () {
  // Attach same dark mode toggle to the floating button
  const floatingThemeBtn = document.querySelector(".floating-tools #themeToggleBtn");
  floatingThemeBtn?.addEventListener("click", function () {
    document.body.classList.toggle("dark-mode");
  });
});
</script>

<script>
document.getElementById("logo")?.addEventListener("click", () => {
  window.scrollTo({ top: 0, behavior: "smooth" });
});
</script>

<script>
  // 🧭 Scroll to top when logo is clicked
  document.addEventListener("DOMContentLoaded", function () {
    const logo = document.querySelector(".navbar-brand");
    if (logo) {
      logo.addEventListener("click", function (e) {
        e.preventDefault();
        window.scrollTo({ top: 0, behavior: "smooth" });
      });
    }
  });
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {
  // Force clean classes on login button
  const loginBtn = document.querySelector('[data-itemid="loginform_login"] a.btn');
  if (loginBtn) {
    loginBtn.className = 'btn custom-login-btn';
  }

  // Optional: customize dropdown button for logged-in users
  const userBtn = document.querySelector('[data-itemid="username_button"] .dropdown-toggle');
  if (userBtn) {
    userBtn.className = 'btn custom-user-btn dropdown-toggle';
  }
});
</script>



<script>
document.addEventListener("DOMContentLoaded", function () {
  const topInput = document.getElementById("topSearchInput");
  const floatingInput = document.getElementById("jobSearchInput");

  // 🔁 Top search reuses floating search logic
  document.getElementById("topSearchForm").addEventListener("submit", function (e) {
    e.preventDefault();

    const query = topInput.value.trim();

    // Sync value to the floating input
    floatingInput.value = query;

    // Trigger input event to use the same filtering
    const inputEvent = new Event("input", { bubbles: true });
    floatingInput.dispatchEvent(inputEvent);
  });

  // 🔄 Optional: sync both inputs in real-time
  topInput.addEventListener("input", function () {
    floatingInput.value = topInput.value;
    const inputEvent = new Event("input", { bubbles: true });
    floatingInput.dispatchEvent(inputEvent);
  });
});
</script>



<div id="stickyHeader">
  <!-- Row 1: Logo + Navigation -->
  <div class="top-bar">
    <!-- Logo, menu, register links -->
  </div>

  <!-- Row 2: Filters or Tabs -->
  <div class="sub-bar">
    <!-- Dropdowns like 'Industrial Areas' -->
  </div>
</div>


<!-- 🌗 Floating Tools Wrapper -->
<div class="floating-tools">
  <!-- Theme toggle button -->
  <button id="themeToggleBtn" class="floating-btn">🌓 Theme</button>

  <!-- Search toggle and input -->
  <div id="floatingSearch" class="floating-search collapsed">
    <button id="toggleSearchBtn" title="Search Jobs">🔍 Search</button>
    <div class="search-panel">
      <input type="text" id="jobSearchInput" placeholder="Search job title, company, or description..." />
      <div style="display: flex; gap: 6px; margin-top: 6px;">
        <button id="resetSearch" title="Clear search and show all">Reset</button>
        <button id="closeSearchBox" title="Hide search panel">✖</button>
      </div>
    </div>
  </div>
</div>

<div id="chatWaver" style="
  position: fixed;
  bottom: 80px;
  right: 20px;
  z-index: 9999;
">
  <a href="https://m.me/MCILSamoa" target="_blank" id="chatBtn" style="
    display: flex;
    align-items: center;
    justify-content: center;
    background: #0084FF;
    color: #fff;
    padding: 10px 16px;
    border-radius: 8px;
    text-decoration: none;
    font-weight: 500;
    font-size: 14px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    transition: transform 0.3s ease;
  ">
    💬 Chat with our team
  </a>
</div>


		{$footer}
	{END body}
	</body>
</html>
