<?php
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");

include("include/dbcommon.php");

if (!isLogged()) {
    HeaderRedirect("login.php");
    exit();
}

$job_id = isset($_GET['job_id']) ? intval($_GET['job_id']) : 0;
$job_title = "";
$user_id = $_SESSION["UserID"];
$full_name = "";
$email = "";
$mobile = "";
$address = "";
$education_level = "";

if ($job_id > 0) {
    $job = DB::Query("SELECT Title FROM jobsjobs WHERE ID = $job_id")->fetchAssoc();
    $job_title = $job['Title'];
}

$profile = DB::Query("SELECT fullName, Email, Mobile, Address, education_level FROM jobs_profile WHERE user_id = '{$user_id}'")->fetchAssoc();
if ($profile) {
    $full_name = $profile['fullName'];
    $email = $profile['Email'];
    $mobile = $profile['Mobile'];
    $address = $profile['Address'];
    $education_level = $profile['education_level'];
}
?>
<!DOCTYPE html>
<html>
<head>
  <title>Apply for Job</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body { font-family: Arial, sans-serif; padding: 20px; }
    form { max-width: 600px; margin: auto; background: #f9f9f9; padding: 20px; border-radius: 10px; }
    h2 { text-align: center; }
    input, textarea, select { width: 100%; padding: 10px; margin-bottom: 15px; border-radius: 6px; border: 1px solid #ccc; }
    button { background-color: #007bff; color: white; border: none; padding: 12px 20px; border-radius: 6px; cursor: pointer; }
    button:hover { background-color: #0056b3; }
    label { font-weight: bold; display: block; margin-bottom: 5px; }
  </style>
</head>
<body>
  <form action="jobs_application_submit.php" method="post">
    <h2>Apply for: <?php echo htmlspecialchars($job_title); ?></h2>
    <input type="hidden" name="job_id" value="<?php echo $job_id; ?>">
    <label>Full Name</label>
    <input type="text" name="full_name" value="<?php echo htmlspecialchars($full_name); ?>" required>

    <label>Email</label>
    <input type="email" name="email" value="<?php echo htmlspecialchars($email); ?>" required>

    <label>Mobile</label>
    <input type="text" name="mobile" value="<?php echo htmlspecialchars($mobile); ?>">

    <label>Address</label>
    <input type="text" name="address" value="<?php echo htmlspecialchars($address); ?>">

    <label>Education Level</label>
    <input type="text" name="education" value="<?php echo htmlspecialchars($education_level); ?>">

    <label>Cover Letter</label>
    <textarea name="cover_letter" rows="6" placeholder="Write your cover letter here..." required></textarea>

    <button type="submit">Submit Application</button>
  </form>
</body>
</html>
