<?php
include("include/dbcommon.php");

if (!isset($_GET['job_id']) || !is_numeric($_GET['job_id'])) {
    echo "Invalid job ID.";
    exit;
}

$job_id = (int)$_GET['job_id'];

$sql = "SELECT * FROM jobsjobs WHERE ID = {$job_id}";
$rs = DB::Query($sql);

// Check if query worked
if (!$rs) {
    echo "SQL Error: " . DB::LastError();
    exit;
}

$job = $rs->fetchAssoc();

// Check if job was found
if (!$job) {
    echo "No job found with ID {$job_id}.";
    exit;
}

// Optional: store job data in session for the form
$_SESSION["application"]["job_id"] = $job['ID'];
$_SESSION["application"]["employer"] = $job['Company'];  // used in later events

// Redirect or include your job application form page here
?>

<!DOCTYPE html>
<html>
<head>
  <title>Apply for Job</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f2f2f2;
    }
    .form-container {
      background: white;
      max-width: 600px;
      margin: 30px auto;
      padding: 30px;
      border-radius: 10px;
      box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    h2 {
      margin-bottom: 20px;
    }
    label {
      font-weight: bold;
    }
    input[type="text"], input[type="email"] {
      width: 100%;
      padding: 10px;
      margin-bottom: 15px;
      border: 1px solid #ccc;
      border-radius: 6px;
    }
    .btn-submit {
      background-color: #28a745;
      color: white;
      border: none;
      padding: 10px 18px;
      border-radius: 6px;
      cursor: pointer;
    }
    .btn-submit:hover {
      background-color: #218838;
    }
  </style>
</head>
<body>

<div class="form-container">
  <h2>Apply for: <strong><?= htmlspecialchars($job_title) ?></strong></h2>
  <form method="post">
    <label>Full Name</label>
    <input type="text" name="full_name" value="<?= htmlspecialchars($full_name) ?>" required>

    <label>Email</label>
    <input type="email" name="email" value="<?= htmlspecialchars($email) ?>" required>

    <label>Mobile</label>
    <input type="text" name="mobile" value="<?= htmlspecialchars($mobile) ?>">

    <label>Address</label>
    <input type="text" name="address" value="<?= htmlspecialchars($address) ?>">

    <label>Education Level</label>
    <input type="text" name="education" value="<?= htmlspecialchars($education_level) ?>">

    <button type="submit" class="btn-submit">Submit Application</button>
  </form>
</div>

</body>
</html>
