<?php
session_start();
require_once 'libs/dompdf-3.1.0/dompdf/autoload.inc.php'; // Dompdf required
use Dompdf\Dompdf;

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

try {
    $pdo = new PDO('mysql:host=192.185.39.233;dbname=pelenato_Jobs20240819_123744', 'pelenato_bits', 'opklnm');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Scheduled summary email (every 24 hours or manually triggered for testing)
    if (isset($_GET['send_summary'])) {
        $stmt = $pdo->query("SELECT session_id, COUNT(*) as msg_count FROM chat_messages WHERE created_at >= NOW() - INTERVAL 1 DAY GROUP BY session_id");
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($rows) {
            $summary = "Chat Summary (Last 24h):\n";
            foreach ($rows as $r) {
                $summary .= "Session: {$r['session_id']} - Messages: {$r['msg_count']}\n";
            }
            mail("info@bitsolution.ws", "Daily Chat Summary", $summary);
        }
        header("Location: admin_chat_view.php?summary_sent=1");
        exit;
    }

    // Admin reply logic
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['send_admin_reply'])) {
        $replyMsg = trim($_POST['admin_message'] ?? '');
        $replySid = $_POST['reply_session'] ?? '';
        if ($replyMsg && $replySid) {
			file_put_contents("chat_debug.log", "Inserting: $guestSid | $guestName | $guestMsg\n", FILE_APPEND);
            $stmt = $pdo->prepare("INSERT INTO chat_messages (session_id, sender, message, created_at) VALUES (?, 'admin', ?, NOW())");
            $stmt->execute([$replySid, $replyMsg]);
            mail("info@bitsolution.ws", "New Admin Reply", "A new admin reply has been posted to session $replySid.");
            header("Location: admin_chat_view.php?sid=" . urlencode($replySid));
            exit;
        }
    }

    // Guest bot auto-response
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['guest_message'])) {
        $guestMsg = strip_tags(trim($_POST['guest_message'] ?? ''));
        $guestSid = $_POST['guest_session'] ?? session_id();
        $guestName = strip_tags(substr($_POST['guest_name'] ?? 'Guest', 0, 50));
        $guestEmail = filter_var($_POST['guest_email'] ?? '', FILTER_SANITIZE_EMAIL);
        $guestPhone = strip_tags($_POST['guest_phone'] ?? '');

        if ($guestMsg) {
            $stmt = $pdo->prepare("INSERT INTO chat_messages (session_id, sender, message, created_at) VALUES (?, ?, ?, NOW())");
            $stmt->execute([$guestSid, $guestName, $guestMsg]);

            $pdo->prepare("INSERT IGNORE INTO chat_sessions (session_id) VALUES (?)")->execute([$guestSid]);

            // Bot reply logic
            $reply = "Thank you for contacting us. We'll be in touch shortly.";
            if (stripos($guestMsg, 'job') !== false) {
                $reply = "Looking for a job? Please check our Job Board or specify your interest.";
            } elseif (stripos($guestMsg, 'email') !== false || stripos($guestMsg, 'contact') !== false) {
                $reply = "Please ensure your contact details are correct. We'll respond as soon as we can.";
            }

            $stmt = $pdo->prepare("INSERT INTO chat_messages (session_id, sender, message, created_at) VALUES (?, 'bot', ?, NOW())");
            $stmt->execute([$guestSid, $reply]);

            mail("info@bitsolution.ws", "New Guest Chat", "Guest $guestName ($guestEmail / $guestPhone): $guestMsg");
            echo "✅ Message captured from guest: $guestMsg<br>Session: $guestSid";
			exit;
        }
    }

    // File upload support
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['chat_file']) && isset($_POST['upload_session'])) {
        $fileTmp = $_FILES['chat_file']['tmp_name'];
        $fileName = basename($_FILES['chat_file']['name']);
        $uploadDir = 'uploads/';
        $targetPath = $uploadDir . time() . '_' . preg_replace('/[^a-zA-Z0-9._-]/', '_', $fileName);

        if (move_uploaded_file($fileTmp, $targetPath)) {
            $stmt = $pdo->prepare("INSERT INTO chat_messages (session_id, sender, message, created_at) VALUES (?, 'admin', ?, NOW())");
            $stmt->execute([$_POST['upload_session'], "[File uploaded: <a href='$targetPath' target='_blank'>$fileName</a>]"]);
            header("Location: admin_chat_view.php?sid=" . urlencode($_POST['upload_session']));
            exit;
        }
    }

    // Delete session
    if (isset($_GET['delete_sid'])) {
        $stmt = $pdo->prepare("DELETE FROM chat_sessions WHERE session_id = ?");
        $stmt->execute([$_GET['delete_sid']]);
        header("Location: admin_chat_view.php");
        exit;
    }

    // PDF export
    if (isset($_GET['export_pdf'])) {
        $sid = $_GET['export_pdf'];
        $stmt = $pdo->prepare("SELECT sender, message, created_at FROM chat_messages WHERE session_id = ? ORDER BY id ASC");
        $stmt->execute([$sid]);
        $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);

        $html = "<h2>Chat History for Session: $sid</h2><hr>";
        foreach ($messages as $msg) {
            $html .= "<p><strong>{$msg['sender']}:</strong> {$msg['message']}<br><small>{$msg['created_at']}</small></p>";
        }

        $pdf = new Dompdf();
        $pdf->loadHtml($html);
        $pdf->setPaper('A4', 'portrait');
        $pdf->render();
        $pdf->stream("chat_$sid.pdf", ["Attachment" => false]);
        exit;
    }

    // UI starts
    echo '<!DOCTYPE html><html><head><meta charset="UTF-8">
    <title>Admin Chat Panel</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <script>
    setInterval(function() {
        if (window.location.href.includes("sid=")) {
            location.reload();
        }
    }, 5000);
    </script>
    </head><body class="bg-light text-dark">';

    echo "<div class='container py-4'>";

    // Chat session summary card
    $summary = $pdo->query("SELECT COUNT(*) as total_sessions FROM chat_sessions")->fetch(PDO::FETCH_ASSOC);
    $msgStats = $pdo->query("SELECT COUNT(*) as total_messages, MAX(created_at) as last_message FROM chat_messages")->fetch(PDO::FETCH_ASSOC);
    echo "<script src='https://cdn.jsdelivr.net/npm/chart.js'></script>
<div class='row mb-4'>
        <div class='col-md-4'>
            <div class='card text-bg-info mb-3'><div class='card-body'>
                <h5 class='card-title'>📊 Total Sessions</h5>
                <p class='card-text fs-4'>{$summary['total_sessions']}</p>
            </div></div>
        </div>
        <div class='col-md-4'>
            <div class='card text-bg-warning mb-3'><div class='card-body'>
                <h5 class='card-title'>💬 Total Messages</h5>
                <p class='card-text fs-4'>{$msgStats['total_messages']}</p>
            </div></div>
        </div>
        <div class='col-md-4'>
            <div class='card text-bg-success mb-3'><div class='card-body'>
                <h5 class='card-title'>🕓 Last Message</h5>
                <p class='card-text fs-6'>{$msgStats['last_message']}</p>
            </div></div>
        </div>
    </div>";
    echo "<h2 class='mb-4'>Chat Sessions 
        <a class='btn btn-sm btn-outline-primary' href='?send_summary=1'>Daily Summary</a> 
        <a class='btn btn-sm btn-outline-secondary' href='export_all_chats.php'>Export CSV</a> 
        <a class='btn btn-sm btn-outline-danger' href='logout.php'>Logout</a>
    </h2>";

    // Filters + Search
    echo '<form class="row g-2 mb-3" method="get">
        <div class="col-md-3">
            <label class="form-label">From</label>
            <input type="date" class="form-control" name="from" value="' . htmlspecialchars($_GET['from'] ?? '') . '">
        </div>
        <div class="col-md-3">
            <label class="form-label">To</label>
            <input type="date" class="form-control" name="to" value="' . htmlspecialchars($_GET['to'] ?? '') . '">
        </div>
        <div class="col-md-3">
            <label class="form-label">Sender</label>
            <input type="text" class="form-control" name="sender" value="' . htmlspecialchars($_GET['sender'] ?? '') . '">
        </div>
        <div class="col-md-3 align-self-end">
            <button type="submit" class="btn btn-success">Filter</button>
        </div>
    </form>';

    echo '<form method="get" class="mb-3">
        <input type="text" class="form-control" name="search" placeholder="Search keyword..." value="' . htmlspecialchars($_GET['search'] ?? '') . '">
    </form>';

    // Sessions list
    echo '<ul class="list-group mb-4">';
    $sessions = $pdo->query("SELECT * FROM chat_sessions ORDER BY started_at DESC")->fetchAll(PDO::FETCH_ASSOC);
    foreach ($sessions as $s) {
        $sid = htmlspecialchars($s['session_id']);
        echo "<li class='list-group-item d-flex justify-content-between align-items-center'>
            <div><a href='?sid=$sid'><strong>$sid</strong></a><br><small>{$s['started_at']}</small></div>
            <div>
                <a class='btn btn-sm btn-outline-primary' href='?export_pdf=$sid'>🧾 PDF</a>
                <a class='btn btn-sm btn-outline-danger' href='?delete_sid=$sid' onclick=\"return confirm('Delete this session?');\">🗑 Delete</a>
            </div>
        </li>";
    }
    echo "</ul>";

    // Chart of daily messages (last 7 days)
    $chartData = $pdo->query("SELECT DATE(created_at) as chat_date, COUNT(*) as total FROM chat_messages GROUP BY DATE(created_at) ORDER BY chat_date DESC LIMIT 7")->fetchAll(PDO::FETCH_ASSOC);
    $labels = array_reverse(array_column($chartData, 'chat_date'));
    $totals = array_reverse(array_column($chartData, 'total'));
    echo "<div class='card mb-4'><div class='card-body'>
        <h5 class='card-title'>📈 Daily Message Volume</h5>
        <canvas id='chatChart' height='100'></canvas>
    </div></div>
    <script>
    new Chart(document.getElementById('chatChart').getContext('2d'), {
        type: 'bar',
        data: {
            labels: " . json_encode($labels) . ",
            datasets: [{
                label: 'Messages',
                data: " . json_encode($totals) . ",
                backgroundColor: 'rgba(54, 162, 235, 0.7)'
            }]
        },
        options: {
            scales: {
                y: { beginAtZero: true }
            }
        }
    });
    </script>";

    // Chart of hourly activity
    $hourData = $pdo->query("SELECT HOUR(created_at) as hour, 
        SUM(CASE WHEN sender = 'admin' THEN 1 ELSE 0 END) AS admin_count,
        SUM(CASE WHEN sender = 'bot' THEN 1 ELSE 0 END) AS bot_count,
        SUM(CASE WHEN sender NOT IN ('admin', 'bot') THEN 1 ELSE 0 END) AS guest_count
        FROM chat_messages GROUP BY hour ORDER BY hour")->fetchAll(PDO::FETCH_ASSOC);

    $hourLabels = array_map(function($h) { return str_pad($h['hour'], 2, '0', STR_PAD_LEFT) . ':00'; }, $hourData);
    $adminCounts = array_column($hourData, 'admin_count');
    $botCounts = array_column($hourData, 'bot_count');
    $guestCounts = array_column($hourData, 'guest_count');

    // Get peak hour by total
    $totals = array_map(function($a, $b, $c) { return $a + $b + $c; }, $adminCounts, $botCounts, $guestCounts);
    $maxIndex = array_keys($totals, max($totals))[0];
    $peakHourLabel = $hourLabels[$maxIndex];
    $peakHourCount = $totals[$maxIndex];

    echo "<div class='card mb-4'><div class='card-body'>
        <h5 class='card-title'>🕒 Hourly Activity</h5>
        <p class='text-muted'>Peak Hour: <strong>$peakHourLabel</strong> with <strong>$peakHourCount</strong> messages</p>
        <canvas id='hourChart' height='120'></canvas>
    </div></div>
    <script>
    new Chart(document.getElementById('hourChart').getContext('2d'), {
        type: 'bar',
        data: {
            labels: " . json_encode($hourLabels) . ",
            datasets: [
                {
                    label: 'Admin',
                    data: " . json_encode($adminCounts) . ",
                    backgroundColor: 'rgba(255, 99, 132, 0.6)'
                },
                {
                    label: 'Bot',
                    data: " . json_encode($botCounts) . ",
                    backgroundColor: 'rgba(54, 162, 235, 0.6)'
                },
                {
                    label: 'Guest',
                    data: " . json_encode($guestCounts) . ",
                    backgroundColor: 'rgba(255, 206, 86, 0.6)'
                }
            ]
        },
        options: {
            responsive: true,
            plugins: { legend: { position: 'top' } },
            scales: {
                y: { beginAtZero: true }
            }
        }
    });
    </script>";

// Sender breakdown chart
$senderData = $pdo->query("
    SELECT 
        CASE 
            WHEN sender = 'admin' THEN 'Admin'
            WHEN sender = 'bot' THEN 'Bot'
            ELSE 'Guest'
        END as label, 
        COUNT(*) as count 
    FROM chat_messages 
    GROUP BY label
")->fetchAll(PDO::FETCH_ASSOC);

$senderLabels = array_column($senderData, 'label');
$senderCounts = array_column($senderData, 'count');

echo "<div class='card mb-4'><div class='card-body'>
    <h5 class='card-title'>👥 Message Sender Breakdown</h5>
    <canvas id='senderChart' height='120'></canvas>
</div></div>
<script>
new Chart(document.getElementById('senderChart').getContext('2d'), {
    type: 'pie',
    data: {
        labels: " . json_encode($senderLabels) . ",
        datasets: [{
            data: " . json_encode($senderCounts) . ",
            backgroundColor: [
                'rgba(255, 99, 132, 0.6)',
                'rgba(54, 162, 235, 0.6)',
                'rgba(255, 206, 86, 0.6)'
            ]
        }]
    },
    options: {
        plugins: {
            tooltip: {
                callbacks: {
                    label: function(context) {
                        let label = context.label || '';
                        let value = context.parsed;
                        let sum = context.dataset.data.reduce((a, b) => a + b, 0);
                        let percentage = ((value / sum) * 100).toFixed(1);
                        return `${label}: ${value} (${percentage}%)`;
                    }
                }
            }
        }
    }
});
</script>";

} catch (PDOException $e) {
    echo "<div class='alert alert-danger'>DB error: " . $e->getMessage() . "</div>";
}
?>
